/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import com.karumi.dexter.listener.OnDialogButtonClickListener;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.single.BasePermissionListener;

public class DialogOnDeniedPermissionListener
extends BasePermissionListener {
    private final Context context;
    private final String title;
    private final String message;
    private final String positiveButtonText;
    private final Drawable icon;
    private final OnDialogButtonClickListener onDialogButtonClickListener;

    private DialogOnDeniedPermissionListener(Context context, String string, String string2, String string3, Drawable drawable, OnDialogButtonClickListener onDialogButtonClickListener) {
        this.context = context;
        this.title = string;
        this.message = string2;
        this.positiveButtonText = string3;
        this.icon = drawable;
        this.onDialogButtonClickListener = onDialogButtonClickListener;
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        super.onPermissionDenied(permissionDeniedResponse);
        new AlertDialog.Builder(this.context).setTitle((CharSequence)this.title).setMessage((CharSequence)this.message).setPositiveButton((CharSequence)this.positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.dismiss();
                DialogOnDeniedPermissionListener.this.onDialogButtonClickListener.onClick();
            }
        }).setIcon(this.icon).show();
    }

    public static class Builder {
        private final Context context;
        private String title;
        private String message;
        private String buttonText;
        private Drawable icon;
        private OnDialogButtonClickListener onDialogButtonClickListener;

        private Builder(Context context) {
            this.context = context;
        }

        public static Builder withContext(Context context) {
            return new Builder(context);
        }

        public Builder withTitle(String string) {
            this.title = string;
            return this;
        }

        public Builder withTitle(@StringRes int n) {
            Builder builder = this;
            builder.title = builder.context.getString(n);
            return builder;
        }

        public Builder withMessage(String string) {
            this.message = string;
            return this;
        }

        public Builder withMessage(@StringRes int n) {
            Builder builder = this;
            builder.message = builder.context.getString(n);
            return builder;
        }

        public Builder withButtonText(String string) {
            this.buttonText = string;
            return this;
        }

        public Builder withButtonText(@StringRes int n) {
            Builder builder = this;
            builder.buttonText = builder.context.getString(n);
            return builder;
        }

        public Builder withButtonText(String string, OnDialogButtonClickListener onDialogButtonClickListener) {
            this.buttonText = string;
            this.onDialogButtonClickListener = onDialogButtonClickListener;
            return this;
        }

        public Builder withButtonText(@StringRes int n, OnDialogButtonClickListener onDialogButtonClickListener) {
            this.buttonText = this.context.getString(n);
            this.onDialogButtonClickListener = onDialogButtonClickListener;
            return this;
        }

        public Builder withIcon(Drawable drawable) {
            this.icon = drawable;
            return this;
        }

        public Builder withIcon(@DrawableRes int n) {
            Builder builder = this;
            builder.icon = builder.context.getResources().getDrawable(n);
            return builder;
        }

        public DialogOnDeniedPermissionListener build() {
            OnDialogButtonClickListener onDialogButtonClickListener;
            String string;
            String string2;
            String string3 = builder2.title;
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = builder2.message) == null) {
                string2 = "";
            }
            if ((string = builder2.buttonText) == null) {
                string = "";
            }
            if ((onDialogButtonClickListener = builder2.onDialogButtonClickListener) == null) {
                OnDialogButtonClickListener onDialogButtonClickListener2;
                onDialogButtonClickListener = onDialogButtonClickListener2;
                onDialogButtonClickListener2 = new OnDialogButtonClickListener(){

                    @Override
                    public void onClick() {
                    }
                };
            }
            Builder builder = builder2;
            Builder builder2 = builder.context;
            Drawable drawable = builder.icon;
            return new DialogOnDeniedPermissionListener((Context)builder2, string3, string2, string, drawable, onDialogButtonClickListener);
        }
    }
}

