/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.compose;

import android.graphics.Bitmap;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import com.karumi.shot.compose.ScreenshotMetadata;
import com.karumi.shot.compose.ScreenshotSaver;
import com.karumi.shot.compose.ScreenshotSource;
import com.karumi.shot.compose.ScreenshotTestSession;
import com.karumi.shot.compose.ScreenshotToSave;
import com.karumi.shot.permissions.AndroidStoragePermissions;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/karumi/shot/compose/ComposeScreenshot;", "", "session", "Lcom/karumi/shot/compose/ScreenshotTestSession;", "saver", "Lcom/karumi/shot/compose/ScreenshotSaver;", "permissions", "Lcom/karumi/shot/permissions/AndroidStoragePermissions;", "(Lcom/karumi/shot/compose/ScreenshotTestSession;Lcom/karumi/shot/compose/ScreenshotSaver;Lcom/karumi/shot/permissions/AndroidStoragePermissions;)V", "saveMetadata", "saveScreenshot", "", "bitmap", "Landroid/graphics/Bitmap;", "data", "Lcom/karumi/shot/compose/ScreenshotMetadata;", "node", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "shot-android_release"})
public final class ComposeScreenshot {
    @NotNull
    private final ScreenshotTestSession session;
    @NotNull
    private final ScreenshotSaver saver;
    @NotNull
    private final AndroidStoragePermissions permissions;

    public ComposeScreenshot(@NotNull ScreenshotTestSession session, @NotNull ScreenshotSaver saver, @NotNull AndroidStoragePermissions permissions) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)saver, (String)"saver");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.session = session;
        this.saver = saver;
        this.permissions = permissions;
    }

    public final void saveScreenshot(@NotNull Bitmap bitmap, @NotNull ScreenshotMetadata data) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.permissions.checkPermissions();
        this.saver.saveScreenshot(new ScreenshotToSave(new ScreenshotSource.Bitmap(bitmap), data));
        this.session.add(data);
    }

    public final void saveScreenshot(@NotNull SemanticsNodeInteraction node, @NotNull ScreenshotMetadata data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.permissions.checkPermissions();
        this.saver.saveScreenshot(new ScreenshotToSave(new ScreenshotSource.Node(node), data));
        this.session.add(data);
    }

    @NotNull
    public final ScreenshotTestSession saveMetadata() {
        if (!((Collection)this.session.getScreenshotSessionMetadata().getScreenshotsData()).isEmpty()) {
            this.saver.saveMetadata(this.session);
        }
        return this.session;
    }
}

