/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.compose;

import android.graphics.Bitmap;
import android.os.Build;
import com.google.gson.Gson;
import com.karumi.shot.AndroidStorageInfo;
import com.karumi.shot.compose.ScreenshotMetadata;
import com.karumi.shot.compose.ScreenshotSessionMetadata;
import com.karumi.shot.compose.ScreenshotSource;
import com.karumi.shot.compose.ScreenshotTestSession;
import com.karumi.shot.compose.ScreenshotToSave;
import com.karumi.shot.compose.SemanticsNodeBitmapGenerator;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/karumi/shot/compose/ScreenshotSaver;", "", "packageName", "", "bitmapGenerator", "Lcom/karumi/shot/compose/SemanticsNodeBitmapGenerator;", "(Ljava/lang/String;Lcom/karumi/shot/compose/SemanticsNodeBitmapGenerator;)V", "gson", "Lcom/google/gson/Gson;", "metadataFile", "screenshotsFolder", "createFileIfNotExists", "Ljava/io/File;", "path", "createScreenshotsFolderIfDoesNotExist", "", "deleteFileIfExists", "getBitmapFromScreenshotToSave", "Landroid/graphics/Bitmap;", "screenshot", "Lcom/karumi/shot/compose/ScreenshotToSave;", "getScreenshotSdCardPath", "data", "Lcom/karumi/shot/compose/ScreenshotMetadata;", "saveMetadata", "session", "Lcom/karumi/shot/compose/ScreenshotTestSession;", "saveScreenshot", "saveScreenshotBitmap", "bitmap", "saveSerializedMetadata", "serializedMetadata", "shot-android_release"})
public final class ScreenshotSaver {
    @NotNull
    private final String packageName;
    @NotNull
    private final SemanticsNodeBitmapGenerator bitmapGenerator;
    @NotNull
    private final String screenshotsFolder;
    @NotNull
    private final String metadataFile;
    @NotNull
    private final Gson gson;

    public ScreenshotSaver(@NotNull String packageName, @NotNull SemanticsNodeBitmapGenerator bitmapGenerator) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)bitmapGenerator, (String)"bitmapGenerator");
        this.packageName = packageName;
        this.bitmapGenerator = bitmapGenerator;
        this.screenshotsFolder = AndroidStorageInfo.INSTANCE.getStorageBaseUrl() + "/screenshots/" + this.packageName + "/screenshots-compose-default/";
        this.metadataFile = this.screenshotsFolder + "/metadata_compose.json";
        this.gson = new Gson();
    }

    public final void saveScreenshot(@NotNull ScreenshotToSave screenshot) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        Bitmap bitmap = this.getBitmapFromScreenshotToSave(screenshot);
        this.createScreenshotsFolderIfDoesNotExist();
        this.saveScreenshotBitmap(bitmap, screenshot.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Bitmap getBitmapFromScreenshotToSave(ScreenshotToSave screenshot) {
        Bitmap bitmap;
        ScreenshotSource screenshotSource = screenshot.getSource();
        if (screenshotSource instanceof ScreenshotSource.Bitmap) {
            bitmap = ((ScreenshotSource.Bitmap)screenshot.getSource()).getBitmap();
            return bitmap;
        } else {
            if (!(screenshotSource instanceof ScreenshotSource.Node)) throw new NoWhenBranchMatchedException();
            if (Build.VERSION.SDK_INT < 26) throw new IllegalArgumentException("Can't extract bitmap from node in a SDK version lower than Build.VERSION_CODES.O");
            bitmap = this.bitmapGenerator.generateBitmap((ScreenshotSource.Node)screenshot.getSource());
        }
        return bitmap;
    }

    public final void saveMetadata(@NotNull ScreenshotTestSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.createScreenshotsFolderIfDoesNotExist();
        ScreenshotSessionMetadata metadata = session.getScreenshotSessionMetadata();
        String serializedMetadata = this.gson.toJson((Object)metadata);
        Intrinsics.checkNotNullExpressionValue((Object)serializedMetadata, (String)"serializedMetadata");
        this.saveSerializedMetadata(serializedMetadata);
    }

    private final void createScreenshotsFolderIfDoesNotExist() {
        File folder = new File(this.screenshotsFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private final void saveSerializedMetadata(String serializedMetadata) {
        File file;
        this.deleteFileIfExists(this.metadataFile);
        File file2 = file = this.createFileIfNotExists(this.metadataFile);
        Charset charset = Charsets.UTF_8;
        File file3 = file2;
        int n = 8192;
        Object object = file3;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        PrintWriter printWriter = new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
        printWriter.print(serializedMetadata);
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveScreenshotBitmap(Bitmap bitmap, ScreenshotMetadata data) {
        String screenshotPath = this.getScreenshotSdCardPath(data);
        this.deleteFileIfExists(screenshotPath);
        this.createFileIfNotExists(screenshotPath);
        FileOutputStream fileOutputStream = new FileOutputStream(screenshotPath);
        Closeable closeable = fileOutputStream;
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            boolean bl2 = bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        fileOutputStream.close();
    }

    private final void deleteFileIfExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    private final File createFileIfNotExists(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private final String getScreenshotSdCardPath(ScreenshotMetadata data) {
        return this.screenshotsFolder + data.getName() + ".png";
    }
}

