/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.permissions;

import android.app.Instrumentation;
import android.app.UiAutomation;
import android.content.Context;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class AndroidStoragePermissions {
    private static final String WRITE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String READ_PERMISSION = "android.permission.READ_EXTERNAL_STORAGE";
    private static final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    private final Instrumentation instrumentation;

    public AndroidStoragePermissions(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public void checkPermissions() {
        Context testAppContext = this.instrumentation.getContext();
        for (String permission : REQUIRED_PERMISSIONS) {
            if (testAppContext.checkCallingOrSelfPermission(permission) == 0) continue;
            if (Build.VERSION.SDK_INT < 23) {
                throw new RuntimeException("We need " + permission + " permission for screenshot tests");
            }
            Context targetContext = this.instrumentation.getTargetContext();
            this.grantPermission(targetContext, permission);
            this.grantPermission(testAppContext, permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantPermission(Context context, String permission) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        UiAutomation automation = this.instrumentation.getUiAutomation();
        String command = String.format(Locale.ENGLISH, "pm grant %s %s", context.getPackageName(), permission);
        ParcelFileDescriptor pfd = automation.executeShellCommand(command);
        FileInputStream stream = new FileInputStream(pfd.getFileDescriptor());
        try {
            byte[] buffer = new byte[1024];
            while (((InputStream)stream).read(buffer) != -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            try {
                pfd.close();
            }
            catch (IOException iOException) {}
        }
    }
}

