/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.karumi.shot.Files;
import com.karumi.shot.android.Adb;
import com.karumi.shot.android.Adb$;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.ui.Console;
import com.karumi.shot.xml.ScreenshotsSuiteXmlParser$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.tinyzip.TinyZip;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001%\u0011Aa\u00155pi*\u00111\u0001B\u0001\u0005g\"|GO\u0003\u0002\u0006\r\u000511.\u0019:v[&T\u0011aB\u0001\u0004G>l7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0007\u0005$'\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0005\u00059\u0011M\u001c3s_&$\u0017BA\f\u0015\u0005\r\tEM\u0019\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005)a-\u001b7fgB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0006\r&dWm\u001d\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005)2o\u0019:fK:\u001c\bn\u001c;t\u0007>l\u0007/\u0019:bi>\u0014\bCA\u0011%\u001b\u0005\u0011#BA\u0012\u0003\u0003-\u00198M]3f]NDw\u000e^:\n\u0005\u0015\u0012#!F*de\u0016,gn\u001d5piN\u001cu.\u001c9be\u0006$xN\u001d\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005A2o\u0019:fK:\u001c\bn\u001c;t\t&4gmR3oKJ\fGo\u001c:\u0011\u0005\u0005J\u0013B\u0001\u0016#\u0005a\u00196M]3f]NDw\u000e^:ES\u001a4w)\u001a8fe\u0006$xN\u001d\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005\u00012o\u0019:fK:\u001c\bn\u001c;t'\u00064XM\u001d\t\u0003C9J!a\f\u0012\u0003!M\u001b'/Z3og\"|Go]*bm\u0016\u0014\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u000f\r|gn]8mKB\u00111GN\u0007\u0002i)\u0011QGA\u0001\u0003k&L!a\u000e\u001b\u0003\u000f\r{gn]8mK\"A\u0011\b\u0001B\u0001B\u0003%!(\u0001\u0005sKB|'\u000f^3s!\tYd(D\u0001=\u0015\ti$!A\u0004sKB|'\u000f^:\n\u0005}b$!E#yK\u000e,H/[8o%\u0016\u0004xN\u001d;fe\"A\u0011\t\u0001B\u0001B\u0003%!)A\bd_:\u001cx\u000e\\3SKB|'\u000f^3s!\tY4)\u0003\u0002Ey\ty1i\u001c8t_2,'+\u001a9peR,'\u000fC\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\n\u0011&S5\nT'O\u001fB\u0003\"a\u0007\u0001\t\u000bE)\u0005\u0019\u0001\n\t\u000be)\u0005\u0019\u0001\u000e\t\u000b})\u0005\u0019\u0001\u0011\t\u000b\u001d*\u0005\u0019\u0001\u0015\t\u000b1*\u0005\u0019A\u0017\t\u000bE*\u0005\u0019\u0001\u001a\t\u000be*\u0005\u0019\u0001\u001e\t\u000b\u0005+\u0005\u0019\u0001\"\t\u000bI\u0003A\u0011A*\u0002!\r|gNZ5hkJ,\u0017\t\u001a2QCRDGC\u0001+X!\tYQ+\u0003\u0002W\u0019\t!QK\\5u\u0011\u0015A\u0016\u000b1\u0001Z\u0003\u001d\tGM\u0019)bi\"\u0004\"A\u00176\u000f\u0005m;gB\u0001/f\u001d\tiFM\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011\rC\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!\u0011B\u00014\u0003\u0003\u0019!w.\\1j]&\u0011\u0001.[\u0001\u0006[>$W\r\u001c\u0006\u0003M\nI!a\u001b7\u0003\r\u0019{G\u000eZ3s\u0015\tA\u0017\u000eC\u0003o\u0001\u0011\u0005q.A\ne_^tGn\\1e'\u000e\u0014X-\u001a8tQ>$8\u000fF\u0003UaJdh\u0010C\u0003r[\u0002\u0007\u0011,A\u0007qe>TWm\u0019;G_2$WM\u001d\u0005\u0006g6\u0004\r\u0001^\u0001\u0007M2\fgo\u001c:\u0011\u0005ULhB\u0001<x!\tyF\"\u0003\u0002y\u0019\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAH\u0002C\u0003~[\u0002\u0007A/A\u0005ck&dG\rV=qK\"1q0\u001ca\u0001\u0003\u0003\tQ!\u00199q\u0013\u0012\u00042AWA\u0002\u0013\r\t)\u0001\u001c\u0002\u0006\u0003B\u0004\u0018\n\u001a\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003E\u0011XmY8sIN\u001b'/Z3og\"|Go\u001d\u000b\u000e)\u00065\u0011qBA\n\u0003+\tI\"a\u0007\t\u000f}\f9\u00011\u0001\u0002\u0002!9\u0011\u0011CA\u0004\u0001\u0004I\u0016a\u00032vS2$gi\u001c7eKJDa!]A\u0004\u0001\u0004I\u0006bBA\f\u0003\u000f\u0001\r\u0001^\u0001\faJ|'.Z2u\u001d\u0006lW\r\u0003\u0004t\u0003\u000f\u0001\r\u0001\u001e\u0005\u0007{\u0006\u001d\u0001\u0019\u0001;\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005\tb/\u001a:jMf\u001c6M]3f]NDw\u000e^:\u0015!\u0005\r\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0002\u0003BA\u0013\u0003Oi\u0011![\u0005\u0004\u0003SI'\u0001H*de\u0016,gn\u001d5piN\u001cu.\u001c9be&\u001c\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u007f\u0006u\u0001\u0019AA\u0001\u0011\u001d\t\t\"!\bA\u0002eCa!]A\u000f\u0001\u0004I\u0006BB:\u0002\u001e\u0001\u0007A\u000f\u0003\u0004~\u0003;\u0001\r\u0001\u001e\u0005\b\u0003/\ti\u00021\u0001u\u0011!\tI$!\bA\u0002\u0005m\u0012AF:i_VdG\r\u0015:j]R\u0014\u0015m]37i\u0015\u0013(o\u001c:\u0011\u0007-\ti$C\u0002\u0002@1\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002D\u0001!\t!!\u0012\u0002#I,Wn\u001c<f'\u000e\u0014X-\u001a8tQ>$8\u000fF\u0002U\u0003\u000fBqa`A!\u0001\u0004\t\t\u0001C\u0004\u0002L\u0001!I!!\u0014\u0002!\rdW-\u0019:TGJ,WM\\:i_R\u001cHc\u0001+\u0002P!9q0!\u0013A\u0002\u0005\u0005\u0001bBA*\u0001\u0011%\u0011QK\u0001&GJ,\u0017\r^3TGJ,WM\\:i_R\u001chi\u001c7eKJLe\rR8fg:{G/\u0012=jgR$B!a\u000f\u0002X!A\u0011\u0011LA)\u0001\u0004\t\t!A\ttGJ,WM\\:i_R\u001chi\u001c7eKJDq!!\u0018\u0001\t\u0013\ty&A\bqk2d7k\u0019:fK:\u001c\bn\u001c;t)%!\u0016\u0011MA2\u0003K\n9\u0007\u0003\u0004r\u00037\u0002\r!\u0017\u0005\b\u007f\u0006m\u0003\u0019AA\u0001\u0011\u0019\u0019\u00181\fa\u0001i\"1Q0a\u0017A\u0002QDq!a\u001b\u0001\t\u0013\ti'\u0001\nsK:\fW.Z'fi\u0006$\u0017\r^1GS2,G#\u0003+\u0002p\u0005E\u00141OA;\u0011\u0019\t\u0018\u0011\u000ea\u00013\"11/!\u001bA\u0002QDa!`A5\u0001\u0004!\bbBA<\u0003S\u0002\r\u0001^\u0001\u0007I\u00164\u0018nY3\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u00059\"/Z1e'\u000e\u0014X-\u001a8tQ>$8/T3uC\u0012\fG/\u0019\u000b\u000b\u0003\u007f\n))a\"\u0002\n\u0006-\u0005c\u0001.\u0002\u0002&\u0019\u00111\u00117\u0003!M\u001b'/Z3og\"|Go]*vSR,\u0007BB9\u0002z\u0001\u0007\u0011\f\u0003\u0004t\u0003s\u0002\r\u0001\u001e\u0005\u0007{\u0006e\u0004\u0019\u0001;\t\u000f\u0005]\u0011\u0011\u0010a\u0001i\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0015A\n:f[>4X\r\u0015:pU\u0016\u001cG\u000fV3na>\u0014\u0018\r\\*de\u0016,gn\u001d5piN4u\u000e\u001c3feR9A+a%\u0002\u0016\u0006]\u0005BB9\u0002\u000e\u0002\u0007\u0011\f\u0003\u0004t\u0003\u001b\u0003\r\u0001\u001e\u0005\u0007{\u00065\u0005\u0019\u0001;\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006IR\r\u001f;sC\u000e$\b+[2ukJ,7O\u0012:p[\n+h\u000e\u001a7f)\r!\u0016q\u0014\u0005\b\u00033\nI\n1\u0001u\u0001")
public class Shot {
    private final Adb adb;
    private final Files files;
    private final ScreenshotsComparator screenshotsComparator;
    private final ScreenshotsDiffGenerator screenshotsDiffGenerator;
    private final ScreenshotsSaver screenshotsSaver;
    private final Console console;
    private final ExecutionReporter reporter;
    private final ConsoleReporter consoleReporter;

    public void configureAdbPath(String adbPath) {
        Adb$.MODULE$.adbBinaryPath_$eq(adbPath);
    }

    public void downloadScreenshots(String projectFolder, String flavor, String buildType, String appId) {
        this.console.show("\u2b07\ufe0f  Pulling screenshots from your connected devices!");
        this.pullScreenshots(projectFolder, appId, flavor, buildType);
    }

    public void recordScreenshots(String appId, String buildFolder, String projectFolder, String projectName, String flavor, String buildType) {
        this.console.show("\ud83d\udcbe  Saving screenshots.");
        Seq<Screenshot> screenshots = this.readScreenshotsMetadata(projectFolder, flavor, buildType, projectName);
        this.screenshotsSaver.saveRecordedScreenshots(projectFolder, flavor, buildType, screenshots);
        this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(projectFolder, flavor, buildType, buildFolder + Config$.MODULE$.recordingReportFolder(flavor, buildType) + "/images/recorded/");
        this.console.show("\ud83d\ude03  Screenshots recorded and saved at: " + projectFolder + Config$.MODULE$.screenshotsFolderName(flavor, buildType));
        this.reporter.generateRecordReport(appId, screenshots, buildFolder, flavor, buildType);
        this.console.show("\ud83e\udd13  You can review the execution report here: " + buildFolder + Config$.MODULE$.recordingReportFolder(flavor, buildType) + "/index.html");
        this.removeProjectTemporalScreenshotsFolder(projectFolder, flavor, buildType);
    }

    public ScreenshotsComparisionResult verifyScreenshots(String appId, String buildFolder, String projectFolder, String flavor, String buildType, String projectName, boolean shouldPrintBase64Error) {
        this.console.show("\ud83d\udd0e  Comparing screenshots with previous ones.");
        Seq<Screenshot> screenshots = this.readScreenshotsMetadata(projectFolder, flavor, buildType, projectName);
        String newScreenshotsVerificationReportFolder = buildFolder + Config$.MODULE$.verificationReportFolder(flavor, buildType) + "/images/";
        this.screenshotsSaver.saveTemporalScreenshots(screenshots, projectName, newScreenshotsVerificationReportFolder);
        ScreenshotsComparisionResult comparision = this.screenshotsComparator.compare(screenshots);
        ScreenshotsComparisionResult updatedComparision = this.screenshotsDiffGenerator.generateDiffs(comparision, newScreenshotsVerificationReportFolder, shouldPrintBase64Error);
        this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(projectFolder, flavor, buildType, buildFolder + Config$.MODULE$.verificationReportFolder(flavor, buildType) + "/images/recorded/");
        if (updatedComparision.hasErrors()) {
            this.consoleReporter.showErrors(updatedComparision, newScreenshotsVerificationReportFolder);
            this.console.showError("\ud83e\udd14 Do you a need a hand with your automated tests or your Android app?");
            this.console.showError("   We'll be happy to help! Send us an email to hello@karumi.com\n");
        } else {
            this.console.showSuccess("\u2705  Yeah!!! Your tests are passing.");
        }
        this.removeProjectTemporalScreenshotsFolder(projectFolder, flavor, buildType);
        this.reporter.generateVerificationReport(appId, comparision, buildFolder, flavor, buildType);
        this.console.show("\ud83e\udd13  You can review the execution report here: " + buildFolder + Config$.MODULE$.verificationReportFolder(flavor, buildType) + "/index.html");
        return comparision;
    }

    public void removeScreenshots(String appId) {
        this.clearScreenshots(appId);
    }

    private void clearScreenshots(String appId) {
        this.adb.devices().foreach((Function1 & Serializable & scala.Serializable)device -> {
            this.adb.clearScreenshots(device, appId);
            return BoxedUnit.UNIT;
        });
    }

    private boolean createScreenshotsFolderIfDoesNotExist(String screenshotsFolder) {
        File folder = new File(screenshotsFolder);
        return folder.mkdirs();
    }

    private void pullScreenshots(String projectFolder, String appId, String flavor, String buildType) {
        this.adb.devices().foreach((Function1 & Serializable & scala.Serializable)device -> {
            Shot.$anonfun$pullScreenshots$1(this, projectFolder, appId, flavor, buildType, device);
            return BoxedUnit.UNIT;
        });
    }

    private void renameMetadataFile(String projectFolder, String flavor, String buildType, String device) {
        String metadataFilePath = projectFolder + Config$.MODULE$.metadataFileName(flavor, buildType);
        String newMetadataFilePath = metadataFilePath + "_" + device;
        this.files.rename(metadataFilePath, newMetadataFilePath);
    }

    private Seq<Screenshot> readScreenshotsMetadata(String projectFolder, String flavor, String buildType, String projectName) {
        String screenshotsFolder = projectFolder + Config$.MODULE$.pulledScreenshotsFolder(flavor, buildType);
        File[] filesInScreenshotFolder = new File(screenshotsFolder).listFiles();
        File[] metadataFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesInScreenshotFolder)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$readScreenshotsMetadata$1(flavor, buildType, file)));
        Screenshot[] screenshotSuite = (Screenshot[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataFiles)).flatMap((Function1 & Serializable & scala.Serializable)metadataFilePath -> {
            String metadataFileContent = $this.files.read(metadataFilePath.getAbsolutePath());
            return ScreenshotsSuiteXmlParser$.MODULE$.parseScreenshots(metadataFileContent, projectName, projectFolder + Config$.MODULE$.screenshotsFolderName(flavor, buildType), projectFolder + Config$.MODULE$.pulledScreenshotsFolder(flavor, buildType));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Screenshot.class)));
        return ((ParIterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])screenshotSuite)).par().map((Function1 & Serializable & scala.Serializable)screenshot -> {
            String viewHierarchyFileName = projectFolder + Config$.MODULE$.pulledScreenshotsFolder(flavor, buildType) + screenshot.viewHierarchy();
            String viewHierarchyContent = $this.files.read(viewHierarchyFileName);
            return ScreenshotsSuiteXmlParser$.MODULE$.parseScreenshotSize((Screenshot)screenshot, viewHierarchyContent);
        }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toList();
    }

    private void removeProjectTemporalScreenshotsFolder(String projectFolder, String flavor, String buildType) {
        block0: {
            File projectTemporalScreenshots = new File(projectFolder + Config$.MODULE$.pulledScreenshotsFolder(flavor, buildType));
            if (!projectTemporalScreenshots.exists()) break block0;
            FileUtils.deleteDirectory((File)projectTemporalScreenshots);
        }
    }

    private void extractPicturesFromBundle(String screenshotsFolder) {
        block0: {
            String bundleFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/screenshot_bundle.zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{screenshotsFolder}));
            if (!java.nio.file.Files.exists(Paths.get(bundleFile, new String[0]), new LinkOption[0])) break block0;
            TinyZip.unzip((String)bundleFile, (String)screenshotsFolder);
        }
    }

    public static final /* synthetic */ void $anonfun$pullScreenshots$1(Shot $this, String projectFolder$1, String appId$1, String flavor$1, String buildType$1, String device) {
        String screenshotsFolder = projectFolder$1 + Config$.MODULE$.screenshotsFolderName(flavor$1, buildType$1);
        $this.createScreenshotsFolderIfDoesNotExist(screenshotsFolder);
        $this.adb.pullScreenshots(device, screenshotsFolder, appId$1);
        $this.extractPicturesFromBundle(projectFolder$1 + Config$.MODULE$.pulledScreenshotsFolder(flavor$1, buildType$1));
        $this.renameMetadataFile(projectFolder$1, flavor$1, buildType$1, device);
    }

    public static final /* synthetic */ boolean $anonfun$readScreenshotsMetadata$1(String flavor$2, String buildType$2, File file) {
        return file.getAbsolutePath().contains(Config$.MODULE$.metadataFileName(flavor$2, buildType$2));
    }

    public Shot(Adb adb, Files files, ScreenshotsComparator screenshotsComparator, ScreenshotsDiffGenerator screenshotsDiffGenerator, ScreenshotsSaver screenshotsSaver, Console console, ExecutionReporter reporter, ConsoleReporter consoleReporter) {
        this.adb = adb;
        this.files = files;
        this.screenshotsComparator = screenshotsComparator;
        this.screenshotsDiffGenerator = screenshotsDiffGenerator;
        this.screenshotsSaver = screenshotsSaver;
        this.console = console;
        this.reporter = reporter;
        this.consoleReporter = consoleReporter;
    }
}

