/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisionError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.ui.Console;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0017\ty1i\u001c8t_2,'+\u001a9peR,'O\u0003\u0002\u0004\t\u00059!/\u001a9peR\u001c(BA\u0003\u0007\u0003\u0011\u0019\bn\u001c;\u000b\u0005\u001dA\u0011AB6beVl\u0017NC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u000591m\u001c8t_2,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\t)\u0018.\u0003\u0002\u001a-\t91i\u001c8t_2,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)1C\u0007a\u0001)!)\u0011\u0005\u0001C\u0001E\u0005Q1\u000f[8x\u000bJ\u0014xN]:\u0015\u0007\r2c\u0006\u0005\u0002\u000eI%\u0011QE\u0004\u0002\u0005+:LG\u000fC\u0003(A\u0001\u0007\u0001&A\u0006d_6\u0004\u0018M]5tS>t\u0007CA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u0019!w.\\1j]&\u0011QF\u000b\u0002\u001d'\u000e\u0014X-\u001a8tQ>$8oQ8na\u0006\u0014\u0018n]5p]J+7/\u001e7u\u0011\u0015y\u0003\u00051\u00011\u00031yW\u000f\u001e9vi\u001a{G\u000eZ3s!\t\t\u0004H\u0004\u00023mA\u00111GD\u0007\u0002i)\u0011QGC\u0001\u0007yI|w\u000e\u001e \n\u0005]r\u0011A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!a\u000e\b\t\u000bq\u0002A\u0011B\u001f\u0002\u001dMDwn\u001e\"bg\u00164D\u0007R5gMR\u00191EP\"\t\u000b}Z\u0004\u0019\u0001!\u0002\u0015M\u001c'/Z3og\"|G\u000f\u0005\u0002*\u0003&\u0011!I\u000b\u0002\u000b'\u000e\u0014X-\u001a8tQ>$\b\"\u0002#<\u0001\u0004)\u0015A\u00032bg\u00164D\u0007R5gMB\u0019QB\u0012\u0019\n\u0005\u001ds!AB(qi&|g\u000e")
public class ConsoleReporter {
    private final Console console;

    public void showErrors(ScreenshotsComparisionResult comparision, String outputFolder) {
        this.console.showError("\u274c  Hummmm...the following screenshot tests are broken:\n");
        comparision.errors().foreach((Function1 & java.io.Serializable & Serializable)error -> {
            ConsoleReporter.$anonfun$showErrors$1(this, error);
            return BoxedUnit.UNIT;
        });
    }

    private void showBase64Diff(Screenshot screenshot, Option<String> base64Diff) {
        Option<String> option = base64Diff;
        if (option instanceof Some) {
            Some some = (Some)option;
            String diff = (String)some.value();
            this.console.showError("            \ud83e\udd16  The option printBase64 is enabled. In order to see the generated diff image for this failing test, run the following command in your terminal:");
            this.console.showError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"            > echo '", "' | base64 -D > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{diff, screenshot.fileName()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$showErrors$1(ConsoleReporter $this, ScreenshotComparisionError error) {
        ScreenshotComparisionError screenshotComparisionError = error;
        if (screenshotComparisionError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisionError;
            Screenshot screenshot = screenshotNotFound.screenshot();
            $this.console.showError("   \ud83d\udd0e  Recorded screenshot not found for test: " + screenshot.name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (screenshotComparisionError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisionError;
            Screenshot screenshot = differentScreenshots.screenshot();
            Option<String> base64Diff = differentScreenshots.base64Diff();
            $this.console.showError("   \ud83e\udd14  The application UI has been modified for test: " + screenshot.name());
            $this.console.showError("            \ud83d\udcbe  You can find the original screenshot here: " + screenshot.recordedScreenshotPath());
            $this.console.showError("            \ud83c\udd95  You can find the new recorded screenshot here: " + screenshot.temporalScreenshotPath());
            $this.showBase64Diff(screenshot, base64Diff);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (screenshotComparisionError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisionError;
            Screenshot screenshot = differentImageDimensions.screenshot();
            Dimension originalDimension = differentImageDimensions.originalDimension();
            Dimension newDimension = differentImageDimensions.newDimension();
            $this.console.showError("   \ud83d\udcf1  The size of the screenshot taken has changed for test: " + screenshot.name());
            $this.console.showError("            \ud83d\udcbe  Original screenshot dimension: " + originalDimension + ". You can find the original screenshot here: " + screenshot.recordedScreenshotPath());
            $this.console.showError("            \ud83c\udd95  New recorded screenshot dimension: " + newDimension + ". You can find the new recorded screenshot here: " + screenshot.temporalScreenshotPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.console.showError("   \ud83d\ude1e  Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.console.lineBreak();
    }

    public ConsoleReporter(Console console) {
        this.console = console;
    }
}

