/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.karumi.shot.Files;
import com.karumi.shot.android.Adb;
import com.karumi.shot.android.Adb$;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ScreenshotsComparisionResult$;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.json.ScreenshotsComposeSuiteJsonParser$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.system.EnvVars;
import com.karumi.shot.ui.Console;
import com.karumi.shot.xml.ScreenshotsSuiteXmlParser$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.tinyzip.TinyZip;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u000f\u001e\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t1\u0002\u0011\t\u0011)A\u00053\")q\f\u0001C\u0001A\")1\u000e\u0001C\u0001Y\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002`\u0002!I!!9\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u00111\u001e\u0001\u0005\n\u00055\bbBAy\u0001\u0011%\u00111\u001f\u0002\u0005'\"|GO\u0003\u0002\u001f?\u0005!1\u000f[8u\u0015\t\u0001\u0013%\u0001\u0004lCJ,X.\u001b\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0007\u0005$'\r\u0005\u0002.a5\taF\u0003\u00020;\u00059\u0011M\u001c3s_&$\u0017BA\u0019/\u0005\r\tEMY\u0001\u0006M&dWm\u001d\t\u0003iUj\u0011!H\u0005\u0003mu\u0011QAR5mKN\fQc]2sK\u0016t7\u000f[8ug\u000e{W\u000e]1sCR|'\u000f\u0005\u0002:y5\t!H\u0003\u0002<;\u0005Y1o\u0019:fK:\u001c\bn\u001c;t\u0013\ti$HA\u000bTGJ,WM\\:i_R\u001c8i\\7qCJ\fGo\u001c:\u00021M\u001c'/Z3og\"|Go\u001d#jM\u001a<UM\\3sCR|'\u000f\u0005\u0002:\u0001&\u0011\u0011I\u000f\u0002\u0019'\u000e\u0014X-\u001a8tQ>$8\u000fR5gM\u001e+g.\u001a:bi>\u0014\u0018\u0001E:de\u0016,gn\u001d5piN\u001c\u0016M^3s!\tID)\u0003\u0002Fu\t\u00012k\u0019:fK:\u001c\bn\u001c;t'\u00064XM]\u0001\bG>t7o\u001c7f!\tA5*D\u0001J\u0015\tQU$\u0001\u0002vS&\u0011A*\u0013\u0002\b\u0007>t7o\u001c7f\u0003!\u0011X\r]8si\u0016\u0014\bCA(S\u001b\u0005\u0001&BA)\u001e\u0003\u001d\u0011X\r]8siNL!a\u0015)\u0003#\u0015CXmY;uS>t'+\u001a9peR,'/A\bd_:\u001cx\u000e\\3SKB|'\u000f^3s!\tye+\u0003\u0002X!\ny1i\u001c8t_2,'+\u001a9peR,'/A\u0004f]Z4\u0016M]:\u0011\u0005ikV\"A.\u000b\u0005qk\u0012AB:zgR,W.\u0003\u0002_7\n9QI\u001c<WCJ\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0006bE\u000e$WMZ4iS*\u0004\"\u0001\u000e\u0001\t\u000b-R\u0001\u0019\u0001\u0017\t\u000bIR\u0001\u0019A\u001a\t\u000b]R\u0001\u0019\u0001\u001d\t\u000byR\u0001\u0019A \t\u000b\tS\u0001\u0019A\"\t\u000b\u0019S\u0001\u0019A$\t\u000b5S\u0001\u0019\u0001(\t\u000bQS\u0001\u0019A+\t\u000baS\u0001\u0019A-\u0002!\r|gNZ5hkJ,\u0017\t\u001a2QCRDGCA7q!\t1c.\u0003\u0002pO\t!QK\\5u\u0011\u0015\t8\u00021\u0001s\u0003\u001d\tGM\u0019)bi\"\u00042a]A\u0004\u001d\r!\u0018\u0011\u0001\b\u0003kzt!A^?\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>$\u0003\u0019a$o\\8u}%\t!%\u0003\u0002!C%\u0011adH\u0005\u0003\u007fv\ta\u0001Z8nC&t\u0017\u0002BA\u0002\u0003\u000b\tQ!\\8eK2T!a`\u000f\n\t\u0005%\u00111\u0002\u0002\u0007\r>dG-\u001a:\u000b\t\u0005\r\u0011QA\u0001\u0014I><h\u000e\\8bIN\u001b'/Z3og\"|Go\u001d\u000b\u0006[\u0006E\u00111\u0004\u0005\b\u0003'a\u0001\u0019AA\u000b\u0003\u0015\t\u0007\u000f]%e!\r\u0019\u0018qC\u0005\u0005\u00033\tYAA\u0003BaBLE\rC\u0004\u0002\u001e1\u0001\r!a\b\u0002\u0015MDw\u000e\u001e$pY\u0012,'\u000f\u0005\u0003\u0002\"\u0005\rRBAA\u0003\u0013\u0011\t)#!\u0002\u0003\u0015MCw\u000e\u001e$pY\u0012,'/A\tsK\u000e|'\u000fZ*de\u0016,gn\u001d5piN$R!\\A\u0016\u0003[Aq!a\u0005\u000e\u0001\u0004\t)\u0002C\u0004\u0002\u001e5\u0001\r!a\b\u0002#Y,'/\u001b4z'\u000e\u0014X-\u001a8tQ>$8\u000f\u0006\b\u00024\u0005e\u00121HA\u001f\u0003#\nY&!\u001a\u0011\t\u0005\u0005\u0012QG\u0005\u0005\u0003o\t)A\u0001\u000fTGJ,WM\\:i_R\u001c8i\\7qCJL7/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005Ma\u00021\u0001\u0002\u0016!9\u0011Q\u0004\bA\u0002\u0005}\u0001bBA \u001d\u0001\u0007\u0011\u0011I\u0001\faJ|'.Z2u\u001d\u0006lW\r\u0005\u0003\u0002D\u0005-c\u0002BA#\u0003\u000f\u0002\"\u0001_\u0014\n\u0007\u0005%s%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\nyE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013:\u0003bBA*\u001d\u0001\u0007\u0011QK\u0001\u0017g\"|W\u000f\u001c3Qe&tGOQ1tKZ\"TI\u001d:peB\u0019a%a\u0016\n\u0007\u0005esEA\u0004C_>dW-\u00198\t\u000f\u0005uc\u00021\u0001\u0002`\u0005IAo\u001c7fe\u0006t7-\u001a\t\u0004M\u0005\u0005\u0014bAA2O\t1Ai\\;cY\u0016Dq!a\u001a\u000f\u0001\u0004\t)&A\u000ftQ><xJ\u001c7z\r\u0006LG.\u001b8h)\u0016\u001cHo]%o%\u0016\u0004xN\u001d;t\u0003E\u0011X-\\8wKN\u001b'/Z3og\"|Go\u001d\u000b\u0004[\u00065\u0004bBA\n\u001f\u0001\u0007\u0011QC\u00011[>4XmQ8na>\u001cXmU2sK\u0016t7\u000f[8ugR{'+Z4vY\u0006\u00148k\u0019:fK:\u001c\bn\u001c;t\r>dG-\u001a:\u0015\u00075\f\u0019\bC\u0004\u0002\u001eA\u0001\r!a\b\u00021I,7m\u001c:e%\u0016<W\u000f\\1s'\u000e\u0014X-\u001a8tQ>$8\u000f\u0006\u0003\u0002z\u0005\u0015\u0005#\u0002\u0014\u0002|\u0005}\u0014bAA?O\t1q\n\u001d;j_:\u00042a]AA\u0013\u0011\t\u0019)a\u0003\u0003!M\u001b'/Z3og\"|Go]*vSR,\u0007bBA\u000f#\u0001\u0007\u0011qD\u0001\u0019e\u0016\u001cwN\u001d3D_6\u0004xn]3TGJ,WM\\:i_R\u001cH\u0003BA=\u0003\u0017Cq!!\b\u0013\u0001\u0004\ty\"\u0001\tdY\u0016\f'oU2sK\u0016t7\u000f[8ugR\u0019Q.!%\t\u000f\u0005M1\u00031\u0001\u0002\u0016\u0005iam\u001c:FC\u000eDG)\u001a<jG\u0016,B!a&\u0002(R\u0019Q.!'\t\u000f\u0005mE\u00031\u0001\u0002\u001e\u0006\ta\rE\u0004'\u0003?\u000b\t%a)\n\u0007\u0005\u0005vEA\u0005Gk:\u001cG/[8ocA!\u0011QUAT\u0019\u0001!q!!+\u0015\u0005\u0004\tYKA\u0001U#\u0011\ti+a-\u0011\u0007\u0019\ny+C\u0002\u00022\u001e\u0012qAT8uQ&tw\rE\u0002'\u0003kK1!a.(\u0005\r\te._\u0001\bI\u00164\u0018nY3t)\t\ti\f\u0005\u0004\u0002@\u0006%\u0017\u0011\t\b\u0005\u0003\u0003\f)MD\u0002y\u0003\u0007L\u0011\u0001K\u0005\u0004\u0003\u000f<\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\fiM\u0001\u0003MSN$(bAAdO\u0005)3M]3bi\u0016\u001c6M]3f]NDw\u000e^:G_2$WM]%g\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0005\u0003+\n\u0019\u000eC\u0004\u0002VZ\u0001\r!!\u0006\u0002#M\u001c'/Z3og\"|Go\u001d$pY\u0012,'/A\bqk2d7k\u0019:fK:\u001c\bn\u001c;t)\u0015i\u00171\\Ao\u0011\u001d\t\u0019b\u0006a\u0001\u0003+Aq!!\b\u0018\u0001\u0004\ty\"A\fsK\u0006$7k\u0019:fK:\u001c\bn\u001c;t\u001b\u0016$\u0018\rZ1uCR!\u0011\u0011PAr\u0011\u001d\ti\u0002\u0007a\u0001\u0003?\taD]3bI\u000e{W\u000e]8tKN\u001b'/Z3og\"|Go]'fi\u0006$\u0017\r^1\u0015\t\u0005e\u0014\u0011\u001e\u0005\b\u0003;I\u0002\u0019AA\u0010\u0003\u0019\u0012X-\\8wKB\u0013xN[3diR+W\u000e]8sC2\u001c6M]3f]NDw\u000e^:G_2$WM\u001d\u000b\u0004[\u0006=\bbBA\u000f5\u0001\u0007\u0011qD\u0001\u001aKb$(/Y2u!&\u001cG/\u001e:fg\u001a\u0013x.\u001c\"v]\u0012dW\rF\u0002n\u0003kDq!!6\u001c\u0001\u0004\t\t\u0005")
public class Shot {
    private final Adb adb;
    private final Files files;
    private final ScreenshotsComparator screenshotsComparator;
    private final ScreenshotsDiffGenerator screenshotsDiffGenerator;
    private final ScreenshotsSaver screenshotsSaver;
    private final Console console;
    private final ExecutionReporter reporter;
    private final ConsoleReporter consoleReporter;
    private final EnvVars envVars;

    public void configureAdbPath(String adbPath) {
        Adb$.MODULE$.adbBinaryPath_$eq(adbPath);
    }

    public void downloadScreenshots(String appId, ShotFolder shotFolder) {
        this.console.show("\u2b07\ufe0f  Pulling screenshots from your connected devices!");
        this.pullScreenshots(appId, shotFolder);
    }

    public void recordScreenshots(String appId, ShotFolder shotFolder) {
        this.console.show("\ud83d\udcbe  Saving screenshots.");
        this.moveComposeScreenshotsToRegularScreenshotsFolder(shotFolder);
        Option<Seq<Screenshot>> composeScreenshotSuite = this.recordComposeScreenshots(shotFolder);
        Option<Seq<Screenshot>> regularScreenshotSuite = this.recordRegularScreenshots(shotFolder);
        if (regularScreenshotSuite.isEmpty() && composeScreenshotSuite.isEmpty()) {
            this.console.showWarning("\ud83e\udd14 We couldn't find any screenshot. Did you configure Shot properly and added your tests to your project? https://github.com/Karumi/Shot/#getting-started");
        } else {
            Seq screenshots = (Seq)((TraversableLike)regularScreenshotSuite.get()).$plus$plus((GenTraversableOnce)composeScreenshotSuite.get(), Seq$.MODULE$.canBuildFrom());
            this.console.show(new StringBuilder(39).append("\ud83d\ude03  Screenshots recorded and saved at: ").append(shotFolder.screenshotsFolder()).toString());
            this.reporter.generateRecordReport(appId, (Seq<Screenshot>)screenshots, shotFolder);
            this.console.show(new StringBuilder(56).append("\ud83e\udd13  You can review the execution report here: ").append(shotFolder.reportFolder()).append("index.html").toString());
            this.removeProjectTemporalScreenshotsFolder(shotFolder);
        }
    }

    public ScreenshotsComparisionResult verifyScreenshots(String appId, ShotFolder shotFolder, String projectName, boolean shouldPrintBase64Error, double tolerance, boolean showOnlyFailingTestsInReports) {
        ScreenshotsComparisionResult screenshotsComparisionResult;
        this.console.show("\ud83d\udd0e  Comparing screenshots with previous ones.");
        this.moveComposeScreenshotsToRegularScreenshotsFolder(shotFolder);
        Option<Seq<Screenshot>> regularScreenshots = this.readScreenshotsMetadata(shotFolder);
        Option<Seq<Screenshot>> composeScreenshots = this.readComposeScreenshotsMetadata(shotFolder);
        if (regularScreenshots.isEmpty() && composeScreenshots.isEmpty()) {
            this.console.showWarning("\ud83e\udd14 We couldn't find any screenshot. Did you configure Shot properly and added your tests to your project? https://github.com/Karumi/Shot/#getting-started");
            screenshotsComparisionResult = new ScreenshotsComparisionResult(ScreenshotsComparisionResult$.MODULE$.apply$default$1(), ScreenshotsComparisionResult$.MODULE$.apply$default$2());
        } else {
            Seq screenshots = (Seq)((TraversableLike)regularScreenshots.get()).$plus$plus((GenTraversableOnce)composeScreenshots.get(), Seq$.MODULE$.canBuildFrom());
            String newScreenshotsVerificationReportFolder = new StringBuilder(7).append(shotFolder.verificationReportFolder()).append("images/").toString();
            this.screenshotsSaver.saveTemporalScreenshots((Seq<Screenshot>)screenshots, projectName, newScreenshotsVerificationReportFolder, shotFolder);
            ScreenshotsComparisionResult comparison = this.screenshotsComparator.compare((Seq<Screenshot>)screenshots, tolerance);
            ScreenshotsComparisionResult updatedComparison = this.screenshotsDiffGenerator.generateDiffs(comparison, newScreenshotsVerificationReportFolder, shouldPrintBase64Error);
            if (showOnlyFailingTestsInReports) {
                String verificationReferenceImagesFolder = new StringBuilder(7).append(shotFolder.verificationReportFolder()).append("images/").toString();
                this.screenshotsSaver.removeNonFailingReferenceImages(verificationReferenceImagesFolder, comparison);
                this.screenshotsSaver.copyOnlyFailingRecordedScreenshotsToTheReportFolder(new StringBuilder(16).append(shotFolder.verificationReportFolder()).append("images/recorded/").toString(), updatedComparison);
            } else {
                this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.verificationReportFolder()).append("images/recorded/").toString());
            }
            if (updatedComparison.hasErrors()) {
                this.consoleReporter.showErrors(updatedComparison, newScreenshotsVerificationReportFolder);
                this.console.showError("\ud83e\udd14 Do you a need a hand with your automated tests or your Android app?");
                this.console.showError("   We'll be happy to help! Send us an email to hello@karumi.com\n");
            } else {
                this.console.showSuccess("\u2705  Yeah!!! Your tests are passing.");
            }
            this.removeProjectTemporalScreenshotsFolder(shotFolder);
            this.reporter.generateVerificationReport(appId, comparison, shotFolder, showOnlyFailingTestsInReports);
            this.console.show(new StringBuilder(56).append("\ud83e\udd13  You can review the execution report here: ").append(shotFolder.verificationReportFolder()).append("index.html").toString());
            screenshotsComparisionResult = comparison;
        }
        return screenshotsComparisionResult;
    }

    public void removeScreenshots(String appId) {
        this.clearScreenshots(appId);
    }

    private void moveComposeScreenshotsToRegularScreenshotsFolder(ShotFolder shotFolder) {
        String composeFolder = shotFolder.pulledComposeScreenshotsFolder();
        this.files.listFilesInFolder(composeFolder).forEach(file -> {
            String rawFilePath = file.getAbsolutePath();
            String newFilePath = rawFilePath.replace(shotFolder.pulledComposeScreenshotsFolder(), shotFolder.pulledScreenshotsFolder());
            $this.files.rename(rawFilePath, newFilePath);
        });
    }

    private Option<Seq<Screenshot>> recordRegularScreenshots(ShotFolder shotFolder) {
        return this.readScreenshotsMetadata(shotFolder).map((Function1 & Serializable & scala.Serializable)screenshots -> {
            $this.screenshotsSaver.saveRecordedScreenshots(shotFolder.screenshotsFolder(), (Seq<Screenshot>)screenshots);
            $this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.recordingReportFolder()).append("images/recorded/").toString());
            return screenshots;
        });
    }

    private Option<Seq<Screenshot>> recordComposeScreenshots(ShotFolder shotFolder) {
        return this.readComposeScreenshotsMetadata(shotFolder).map((Function1 & Serializable & scala.Serializable)screenshots -> {
            $this.screenshotsSaver.saveRecordedScreenshots(shotFolder.screenshotsFolder(), (Seq<Screenshot>)screenshots);
            $this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.recordingReportFolder()).append("images/recorded/").toString());
            return screenshots;
        });
    }

    private void clearScreenshots(String appId) {
        this.forEachDevice((Function1 & Serializable & scala.Serializable)device -> {
            this.adb.clearScreenshots(device, appId);
            return BoxedUnit.UNIT;
        });
    }

    private <T> void forEachDevice(Function1<String, T> f) {
        this.devices().foreach(f);
    }

    private List<String> devices() {
        Some some;
        String device;
        .colon.colon allDevices = this.adb.devices();
        Option<String> specifiedDevice = this.envVars.androidSerial();
        Option<String> option = specifiedDevice;
        .colon.colon colon2 = option instanceof Some && allDevices.contains((Object)(device = (String)(some = (Some)option).value())) ? new .colon.colon((Object)device, (List)Nil$.MODULE$) : allDevices;
        return colon2;
    }

    private boolean createScreenshotsFolderIfDoesNotExist(String screenshotsFolder) {
        File folder = new File(screenshotsFolder);
        return folder.mkdirs();
    }

    private void pullScreenshots(String appId, ShotFolder shotFolder) {
        this.forEachDevice((Function1 & Serializable & scala.Serializable)device -> {
            Shot.$anonfun$pullScreenshots$1(this, shotFolder, appId, device);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<Screenshot>> readScreenshotsMetadata(ShotFolder shotFolder) {
        None$ none$;
        String screenshotsFolder = shotFolder.pulledScreenshotsFolder();
        File folder = new File(screenshotsFolder);
        if (folder.exists()) {
            File[] filesInScreenshotFolder = folder.listFiles();
            File[] metadataFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesInScreenshotFolder)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$readScreenshotsMetadata$1(file)));
            Screenshot[] screenshotSuite = (Screenshot[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataFiles)).flatMap((Function1 & Serializable & scala.Serializable)metadataFilePath -> {
                String metadataFileContent = $this.files.read(metadataFilePath.getAbsolutePath());
                return ScreenshotsSuiteXmlParser$.MODULE$.parseScreenshots(metadataFileContent, shotFolder.screenshotsFolder(), shotFolder.pulledScreenshotsFolder(), shotFolder.screenshotsTemporalBuildPath());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Screenshot.class)));
            List suite = ((ParIterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])screenshotSuite)).par().map((Function1 & Serializable & scala.Serializable)screenshot -> {
                String viewHierarchyFileName = new StringBuilder(0).append(shotFolder.pulledScreenshotsFolder()).append(screenshot.viewHierarchy()).toString();
                String viewHierarchyContent = $this.files.read(viewHierarchyFileName);
                return ScreenshotsSuiteXmlParser$.MODULE$.parseScreenshotSize((Screenshot)screenshot, viewHierarchyContent);
            }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toList();
            none$ = new Some((Object)suite);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Seq<Screenshot>> readComposeScreenshotsMetadata(ShotFolder shotFolder) {
        None$ none$;
        String screenshotsFolder = shotFolder.pulledScreenshotsFolder();
        File folder = new File(screenshotsFolder);
        if (folder.exists()) {
            File[] filesInScreenshotFolder = folder.listFiles();
            File[] metadataFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesInScreenshotFolder)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$readComposeScreenshotsMetadata$1(file)));
            Screenshot[] screenshotSuite = (Screenshot[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataFiles)).flatMap((Function1 & Serializable & scala.Serializable)metadataFilePath -> {
                String metadataFileContent = $this.files.read(metadataFilePath.getAbsolutePath());
                return ScreenshotsComposeSuiteJsonParser$.MODULE$.parseScreenshots(metadataFileContent, shotFolder.screenshotsFolder(), shotFolder.pulledScreenshotsFolder(), shotFolder.screenshotsTemporalBuildPath());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Screenshot.class)));
            List suite = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])screenshotSuite)).map((Function1 & Serializable & scala.Serializable)screenshot -> {
                Dimension dimension;
                Dimension x$1 = dimension = $this.screenshotsSaver.getScreenshotDimension(shotFolder, (Screenshot)screenshot);
                String x$2 = screenshot.copy$default$1();
                String x$3 = screenshot.copy$default$2();
                String x$4 = screenshot.copy$default$3();
                String x$5 = screenshot.copy$default$4();
                String x$6 = screenshot.copy$default$5();
                Dimension x$7 = screenshot.copy$default$6();
                String x$8 = screenshot.copy$default$7();
                Seq<String> x$9 = screenshot.copy$default$8();
                Seq<String> x$10 = screenshot.copy$default$9();
                Seq<String> x$11 = screenshot.copy$default$10();
                return screenshot.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Screenshot.class))))).toList();
            none$ = new Some((Object)suite);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void removeProjectTemporalScreenshotsFolder(ShotFolder shotFolder) {
        FileUtils.deleteDirectory((File)new File(shotFolder.pulledScreenshotsFolder()));
        FileUtils.deleteDirectory((File)new File(shotFolder.pulledComposeScreenshotsFolder()));
    }

    private void extractPicturesFromBundle(String screenshotsFolder) {
        block0: {
            String bundleFile = new StringBuilder(21).append(screenshotsFolder).append("screenshot_bundle.zip").toString();
            if (!java.nio.file.Files.exists(Paths.get(bundleFile, new String[0]), new LinkOption[0])) break block0;
            TinyZip.unzip((String)bundleFile, (String)screenshotsFolder);
        }
    }

    public static final /* synthetic */ void $anonfun$pullScreenshots$1(Shot $this, ShotFolder shotFolder$4, String appId$2, String device) {
        String screenshotsFolder = shotFolder$4.screenshotsFolder();
        $this.createScreenshotsFolderIfDoesNotExist(screenshotsFolder);
        $this.removeProjectTemporalScreenshotsFolder(shotFolder$4);
        $this.adb.pullScreenshots(device, screenshotsFolder, appId$2);
        $this.extractPicturesFromBundle(shotFolder$4.pulledScreenshotsFolder());
        $this.files.rename(shotFolder$4.metadataFile(), new StringBuilder(1).append(shotFolder$4.metadataFile()).append("_").append(device).toString());
        $this.files.rename(shotFolder$4.composeMetadataFile(), new StringBuilder(1).append(shotFolder$4.composeMetadataFile()).append("_").append(device).toString());
    }

    public static final /* synthetic */ boolean $anonfun$readScreenshotsMetadata$1(File file) {
        return file.getAbsolutePath().contains("metadata.xml");
    }

    public static final /* synthetic */ boolean $anonfun$readComposeScreenshotsMetadata$1(File file) {
        return file.getAbsolutePath().contains("metadata.json");
    }

    public Shot(Adb adb, Files files, ScreenshotsComparator screenshotsComparator, ScreenshotsDiffGenerator screenshotsDiffGenerator, ScreenshotsSaver screenshotsSaver, Console console, ExecutionReporter reporter, ConsoleReporter consoleReporter, EnvVars envVars) {
        this.adb = adb;
        this.files = files;
        this.screenshotsComparator = screenshotsComparator;
        this.screenshotsDiffGenerator = screenshotsDiffGenerator;
        this.screenshotsSaver = screenshotsSaver;
        this.console = console;
        this.reporter = reporter;
        this.consoleReporter = consoleReporter;
        this.envVars = envVars;
    }
}

