/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisonError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.ui.Console;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0002\u0004\u0001\u001f!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003=\u0001\u0011%QHA\bD_:\u001cx\u000e\\3SKB|'\u000f^3s\u0015\t9\u0001\"A\u0004sKB|'\u000f^:\u000b\u0005%Q\u0011\u0001B:i_RT!a\u0003\u0007\u0002\r-\f'/^7j\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\u000691m\u001c8t_2,\u0007C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\t\u0003\t)\u0018.\u0003\u0002\u001d3\t91i\u001c8t_2,\u0017A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\r!)aC\u0001a\u0001/\u0005Q1\u000f[8x\u000bJ\u0014xN]:\u0015\u0007\u0011:s\u0006\u0005\u0002\u0012K%\u0011aE\u0005\u0002\u0005+:LG\u000fC\u0003)\u0007\u0001\u0007\u0011&A\u0006d_6\u0004\u0018M]5tS>t\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\t\u0003\u0019!w.\\1j]&\u0011af\u000b\u0002\u001d'\u000e\u0014X-\u001a8tQ>$8oQ8na\u0006\u0014\u0018n]5p]J+7/\u001e7u\u0011\u0015\u00014\u00011\u00012\u00031yW\u000f\u001e9vi\u001a{G\u000eZ3s!\t\u0011\u0014H\u0004\u00024oA\u0011AGE\u0007\u0002k)\u0011aGD\u0001\u0007yI|w\u000e\u001e \n\u0005a\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\n\u0002\u001dMDwn\u001e\"bg\u00164D\u0007R5gMR\u0019AEP\"\t\u000b}\"\u0001\u0019\u0001!\u0002\u0015M\u001c'/Z3og\"|G\u000f\u0005\u0002+\u0003&\u0011!i\u000b\u0002\u000b'\u000e\u0014X-\u001a8tQ>$\b\"\u0002#\u0005\u0001\u0004)\u0015A\u00032bg\u00164D\u0007R5gMB\u0019\u0011CR\u0019\n\u0005\u001d\u0013\"AB(qi&|g\u000e")
public class ConsoleReporter {
    private final Console console;

    public void showErrors(ScreenshotsComparisionResult comparision, String outputFolder) {
        this.console.showError("\u274c  Hummmm...the following screenshot tests are broken:\n");
        comparision.errors().foreach((Function1 & java.io.Serializable & Serializable)error -> {
            ConsoleReporter.$anonfun$showErrors$1(this, error);
            return BoxedUnit.UNIT;
        });
    }

    private void showBase64Diff(Screenshot screenshot, Option<String> base64Diff) {
        Option<String> option = base64Diff;
        if (option instanceof Some) {
            Some some = (Some)option;
            String diff = (String)some.value();
            this.console.showError("            \ud83e\udd16  The option printBase64 is enabled. In order to see the generated diff image for this failing test, run the following command in your terminal:");
            this.console.showError(new StringBuilder(36).append("            > echo '").append(diff).append("' | base64 -D > ").append(screenshot.fileName()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$showErrors$1(ConsoleReporter $this, ScreenshotComparisonError error) {
        ScreenshotComparisonError screenshotComparisonError = error;
        if (screenshotComparisonError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisonError;
            Screenshot screenshot = screenshotNotFound.screenshot();
            $this.console.showError(new StringBuilder(47).append("   \ud83d\udd0e  Recorded screenshot not found for test: ").append(screenshot.name()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (screenshotComparisonError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisonError;
            Screenshot screenshot = differentScreenshots.screenshot();
            Option<String> base64Diff = differentScreenshots.base64Diff();
            $this.console.showError(new StringBuilder(54).append("   \ud83e\udd14  The application UI has been modified for test: ").append(screenshot.name()).toString());
            $this.console.showError(new StringBuilder(59).append("            \ud83d\udcbe  You can find the original screenshot here: ").append(screenshot.recordedScreenshotPath()).toString());
            $this.console.showError(new StringBuilder(63).append("            \ud83c\udd95  You can find the new recorded screenshot here: ").append(screenshot.temporalScreenshotPath()).toString());
            $this.showBase64Diff(screenshot, base64Diff);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (screenshotComparisonError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisonError;
            Screenshot screenshot = differentImageDimensions.screenshot();
            Dimension originalDimension = differentImageDimensions.originalDimension();
            Dimension newDimension = differentImageDimensions.newDimension();
            $this.console.showError(new StringBuilder(62).append("   \ud83d\udcf1  The size of the screenshot taken has changed for test: ").append(screenshot.name()).toString());
            $this.console.showError(new StringBuilder(92).append("            \ud83d\udcbe  Original screenshot dimension: ").append(originalDimension).append(". You can find the original screenshot here: ").append(screenshot.recordedScreenshotPath()).toString());
            $this.console.showError(new StringBuilder(100).append("            \ud83c\udd95  New recorded screenshot dimension: ").append(newDimension).append(". You can find the new recorded screenshot here: ").append(screenshot.temporalScreenshotPath()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.console.showError("   \ud83d\ude1e  Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.console.lineBreak();
    }

    public ConsoleReporter(Console console) {
        this.console = console;
    }
}

