/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisonError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.templates.RecordIndexTemplate$;
import com.karumi.shot.templates.VerificationIndexTemplate$;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\b\u0011\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\u0002\u0015BQA\u0013\u0001\u0005\u0002-Cq\u0001\u0017\u0001\u0012\u0002\u0013\u0005\u0011\fC\u0003e\u0001\u0011%Q\rC\u0003s\u0001\u0011%1\u000fC\u0003y\u0001\u0011%\u0011\u0010C\u0003}\u0001\u0011%Q\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\t\tR\t_3dkRLwN\u001c*fa>\u0014H/\u001a:\u000b\u0005E\u0011\u0012a\u0002:fa>\u0014Ho\u001d\u0006\u0003'Q\tAa\u001d5pi*\u0011QCF\u0001\u0007W\u0006\u0014X/\\5\u000b\u0003]\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t\u0001#\u0001\u000bhK:,'/\u0019;f%\u0016\u001cwN\u001d3SKB|'\u000f\u001e\u000b\u0005M%zD\t\u0005\u0002\u001cO%\u0011\u0001\u0006\b\u0002\u0005+:LG\u000fC\u0003+\u0005\u0001\u00071&A\u0003baBLE\r\u0005\u0002-y9\u0011Q&\u000f\b\u0003]]r!a\f\u001c\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a\u0019\u0003\u0019a$o\\8u}%\tq#\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003qI\ta\u0001Z8nC&t\u0017B\u0001\u001e<\u0003\u0015iw\u000eZ3m\u0015\tA$#\u0003\u0002>}\t)\u0011\t\u001d9JI*\u0011!h\u000f\u0005\u0006\u0001\n\u0001\r!Q\u0001\fg\u000e\u0014X-\u001a8tQ>$8\u000f\u0005\u0002-\u0005&\u00111I\u0010\u0002\u0011'\u000e\u0014X-\u001a8tQ>$8oU;ji\u0016DQ!\u0012\u0002A\u0002\u0019\u000b!b\u001d5pi\u001a{G\u000eZ3s!\t9\u0005*D\u0001<\u0013\tI5H\u0001\u0006TQ>$hi\u001c7eKJ\f!dZ3oKJ\fG/\u001a,fe&4\u0017nY1uS>t'+\u001a9peR$RA\n'N%NCQAK\u0002A\u0002-BQAT\u0002A\u0002=\u000b1bY8na\u0006\u0014\u0018n]5p]B\u0011q\tU\u0005\u0003#n\u0012AdU2sK\u0016t7\u000f[8ug\u000e{W\u000e]1sSNLwN\u001c*fgVdG\u000fC\u0003F\u0007\u0001\u0007a\tC\u0004U\u0007A\u0005\t\u0019A+\u0002;MDwn^(oYf4\u0015-\u001b7j]\u001e$Vm\u001d;t\u0013:\u0014V\r]8siN\u0004\"a\u0007,\n\u0005]c\"a\u0002\"p_2,\u0017M\\\u0001%O\u0016tWM]1uKZ+'/\u001b4jG\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\t!L\u000b\u0002V7.\nA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Cr\t!\"\u00198o_R\fG/[8o\u0013\t\u0019gLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1b\u001e:ji\u0016\u0014V\r]8siR\u0019aE\u001a9\t\u000b\u001d,\u0001\u0019\u00015\u0002\u0019\u0019LG.Z\"p]R,g\u000e^:\u0011\u0005%lgB\u00016l!\t\tD$\u0003\u0002m9\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\taG\u0004C\u0003r\u000b\u0001\u0007\u0001.\u0001\u0007sKB|'\u000f\u001e$pY\u0012,'/A\fsKN,GOV3sS\u001aL7-\u0019;j_:\u0014V\r]8siR\u0011Ao\u001e\t\u00037UL!A\u001e\u000f\u0003\r\u0005s\u0017PV1m\u0011\u0015)e\u00011\u0001G\u0003Y\u0001x\u000e];mCR,'+Z2pe\u0012$V-\u001c9mCR,Gc\u00015{w\")!f\u0002a\u0001W!)\u0001i\u0002a\u0001\u0003\u0006qr-\u001a8fe\u0006$XMU3d_J$7+^7nCJLH+\u00192mK\n{G-\u001f\u000b\u0003QzDQ\u0001\u0011\u0005A\u0002\u0005\u000bA\u0004]8qk2\fG/\u001a,fe&4\u0017nY1uS>tG+Z7qY\u0006$X\rF\u0004i\u0003\u0007\t)!a\u0002\t\u000b)J\u0001\u0019A\u0016\t\u000b9K\u0001\u0019A(\t\u000bQK\u0001\u0019A+\u00029\u001d,GoU8si\u0016$')\u001f*fgVdGoU2sK\u0016t7\u000f[8ugR!\u0011QBA\u0019!\u0019\ty!!\u0006\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0012AC2pY2,7\r^5p]&!\u0011qCA\t\u0005\r\u0019V-\u001d\t\b7\u0005m\u0011qDA\u0013\u0013\r\ti\u0002\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u001d\u000b\t#C\u0002\u0002$m\u0012!bU2sK\u0016t7\u000f[8u!\u0015Y\u0012qEA\u0016\u0013\r\tI\u0003\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u001d\u000bi#C\u0002\u00020m\u0012\u0011dU2sK\u0016t7\u000f[8u\u0007>l\u0007/\u0019:jg>tWI\u001d:pe\"1\u00111\u0007\u0006A\u0002=\u000b!bY8na\u0006\u0014\u0018n]8o\u0003\u0011:WM\\3sCR,g+\u001a:jM&\u001c\u0017\r^5p]N+X.\\1ssR\u000b'\r\\3C_\u0012LH#\u00025\u0002:\u0005m\u0002\"\u0002(\f\u0001\u0004y\u0005\"\u0002+\f\u0001\u0004)\u0016\u0001H4f]\u0016\u0014\u0018\r^3TGJ,WM\\:i_R\u001cH+\u00192mK\n{G-\u001f\u000b\u0006Q\u0006\u0005\u00131\t\u0005\u0006\u001d2\u0001\ra\u0014\u0005\u0006)2\u0001\r!V\u0001\nM&tG-\u0012:s_J$b!!\n\u0002J\u00055\u0003bBA&\u001b\u0001\u0007\u0011qD\u0001\u000bg\u000e\u0014X-\u001a8tQ>$\bbBA(\u001b\u0001\u0007\u0011\u0011K\u0001\u0007KJ\u0014xN]:\u0011\u00071\n\u0019&C\u0002\u0002Vy\u00121dU2sK\u0016t7\u000f[8u\u0007>l\u0007/\u0019:jg&|g.\u0012:s_J\u001c\u0018!F4f]\u0016\u0014\u0018\r^3SK\u0006\u001cxN\\'fgN\fw-\u001a\u000b\u0004Q\u0006m\u0003bBA/\u001d\u0001\u0007\u0011QE\u0001\u0006KJ\u0014xN\u001d")
public class ExecutionReporter {
    public void generateRecordReport(String appId, Seq<Screenshot> screenshots, ShotFolder shotFolder) {
        String reportFileContents = this.populateRecordTemplate(appId, screenshots);
        this.resetVerificationReport(shotFolder);
        String reportFolder = shotFolder.recordingReportFolder();
        this.writeReport(reportFileContents, reportFolder);
    }

    public void generateVerificationReport(String appId, ScreenshotsComparisionResult comparision, ShotFolder shotFolder, boolean showOnlyFailingTestsInReports) {
        String reportFileContents = this.populateVerificationTemplate(appId, comparision, showOnlyFailingTestsInReports);
        this.resetVerificationReport(shotFolder);
        String reportFolder = shotFolder.verificationReportFolder();
        this.writeReport(reportFileContents, reportFolder);
    }

    public boolean generateVerificationReport$default$4() {
        return false;
    }

    private void writeReport(String fileContents, String reportFolder) {
        File indexFile = new File(new StringBuilder(10).append(reportFolder).append("index.html").toString());
        new File(reportFolder).mkdirs();
        FileWriter writer = new FileWriter(indexFile);
        writer.write(fileContents);
        writer.close();
    }

    private Object resetVerificationReport(ShotFolder shotFolder) {
        File file = new File(new StringBuilder(10).append(shotFolder.reportFolder()).append("index.html").toString());
        return file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
    }

    private String populateRecordTemplate(String appId, Seq<Screenshot> screenshots) {
        String title = new StringBuilder(16).append("Record results: ").append(appId).toString();
        int numberOfTests = screenshots.size();
        String summaryResults = new StringBuilder(27).append(numberOfTests).append(" screenshot tests recorded.").toString();
        String summaryTableBody = this.generateRecordSummaryTableBody(screenshots);
        return RecordIndexTemplate$.MODULE$.recordIndexTemplate(title, summaryResults, summaryTableBody);
    }

    private String generateRecordSummaryTableBody(Seq<Screenshot> screenshots) {
        return ((TraversableOnce)screenshots.map((Function1 & Serializable & scala.Serializable)screenshot -> {
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
            int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
            return new StringBuilder(103).append("<tr>").append("<th> <p>Test class: ").append(testClass).append("</p>").append("<p>Test name: ").append(testName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("</tr>").toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String populateVerificationTemplate(String appId, ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        String title = new StringBuilder(22).append("Verification results: ").append(appId).toString();
        Seq<Screenshot> screenshots = comparision.screenshots();
        int numberOfTests = screenshots.size();
        int failedNumber = comparision.errors().size();
        int successNumber = numberOfTests - failedNumber;
        String summaryResults = new StringBuilder(48).append(numberOfTests).append(" screenshot tests executed. ").append(successNumber).append(" passed and ").append(failedNumber).append(" failed.").toString();
        String summaryTableBody = this.generateVerificationSummaryTableBody(comparision, showOnlyFailingTestsInReports);
        String screenshotsTableBody = this.generateScreenshotsTableBody(comparision, showOnlyFailingTestsInReports);
        return VerificationIndexTemplate$.MODULE$.verificationIndexTemplate(title, summaryResults, summaryTableBody, screenshotsTableBody);
    }

    private Seq<Tuple2<Screenshot, Option<ScreenshotComparisonError>>> getSortedByResultScreenshots(ScreenshotsComparisionResult comparison) {
        return (Seq)((SeqLike)comparison.screenshots().map((Function1 & Serializable & scala.Serializable)screenshot -> {
            Option<ScreenshotComparisonError> error = this.findError((Screenshot)screenshot, comparison.errors());
            return new Tuple2(screenshot, error);
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$getSortedByResultScreenshots$2(x$1)), (Ordering)Ordering.Boolean$.MODULE$);
    }

    private String generateVerificationSummaryTableBody(ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        return ((TraversableOnce)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Screenshot screenshot = (Screenshot)tuple2._1();
            Option error = (Option)tuple2._2();
            boolean isFailedTest = error.isDefined();
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String result = isFailedTest ? "\u274c" : "\u2705";
            String reason = this.generateReasonMessage((Option<ScreenshotComparisonError>)error);
            String color = isFailedTest ? "red-text" : "green-text";
            String id = screenshot.name().replace(".", "");
            String string = showOnlyFailingTestsInReports && isFailedTest || !showOnlyFailingTestsInReports ? new StringBuilder(123).append("<tr>").append("<th><a href='#").append(id).append("'>").append(result).append("</a></th>").append("<th><a href='#").append(id).append("'><p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p></a></th>").append("<th>").append(reason).append("</th>").append("</tr>").toString() : "";
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String generateScreenshotsTableBody(ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        return ((TraversableOnce)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Screenshot screenshot = (Screenshot)tuple2._1();
            Option error = (Option)tuple2._2();
            boolean isFailedTest = error.isDefined();
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
            String newScreenshot = new StringBuilder(13).append("./images/").append(screenshot.name()).append(".png").toString();
            String diff = error.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$generateScreenshotsTableBody$2(x$2))) ? screenshot.getDiffScreenshotPath("./images/") : "";
            String color = isFailedTest ? "red-text" : "green-text";
            int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
            String id = screenshot.name().replace(".", "");
            String string = showOnlyFailingTestsInReports && isFailedTest || !showOnlyFailingTestsInReports ? new StringBuilder(221).append("<tr>").append("<th id='").append(id).append("'> <p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("<th> <a href='").append(newScreenshot).append("'><img width='").append(width).append("' src='").append(newScreenshot).append("'/></a></th>").append("<th> <a href='").append(diff).append("'><img width='").append(width).append("' src='").append(diff).append("'/></a></th>").append("</tr>").toString() : "";
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Option<ScreenshotComparisonError> findError(Screenshot screenshot, Seq<ScreenshotComparisonError> errors) {
        return errors.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$findError$1(screenshot, x0$1)));
    }

    private String generateReasonMessage(Option<ScreenshotComparisonError> error) {
        return (String)error.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScreenshotComparisonError screenshotComparisonError = x0$1;
            String string = screenshotComparisonError instanceof ScreenshotNotFound ? "<p class='red-text'>\ud83d\udd0e  Recorded screenshot not found.</p>" : (screenshotComparisonError instanceof DifferentScreenshots ? "<p class='red-text'>\ud83e\udd14  The application UI has been modified.</p>" : (screenshotComparisonError instanceof DifferentImageDimensions ? "<p class='red-text'>\ud83d\udcf1  The size of the screenshot taken has changed.</p>" : "<p class='red-text'>\ud83d\ude1e  Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.</p>"));
            return string;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$getSortedByResultScreenshots$2(Tuple2 x$1) {
        return ((Option)x$1._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateScreenshotsTableBody$2(ScreenshotComparisonError x$2) {
        return x$2 instanceof DifferentScreenshots;
    }

    public static final /* synthetic */ boolean $anonfun$findError$1(Screenshot screenshot$1, ScreenshotComparisonError x0$1) {
        boolean bl;
        ScreenshotComparisonError screenshotComparisonError = x0$1;
        if (screenshotComparisonError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisonError;
            Screenshot error = screenshotNotFound.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot2 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot2) : screenshot2 != null);
        } else if (screenshotComparisonError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisonError;
            Screenshot error = differentImageDimensions.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot3 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot3) : screenshot3 != null);
        } else if (screenshotComparisonError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisonError;
            Screenshot error = differentScreenshots.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot4 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot4) : screenshot4 != null);
        } else {
            bl = false;
        }
        return bl;
    }
}

