/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.Config$;
import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisionError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\t\u0012\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\u0006a\u0001!\t!\r\u0005\u0006C\u0002!\tA\u0019\u0005\u0006[\u0002!IA\u001c\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\u0012\u0011#\u0012=fGV$\u0018n\u001c8SKB|'\u000f^3s\u0015\t\u00112#A\u0004sKB|'\u000f^:\u000b\u0005Q)\u0012\u0001B:i_RT!AF\f\u0002\r-\f'/^7j\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011!E\u0001\u0011MJ,W-T1sW\u0016\u00148i\u001c8gS\u001e,\u0012a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\n\u0001\u0002^3na2\fG/\u001a\u0006\u0002Y\u0005QaM]3f[\u0006\u00148.\u001a:\n\u00059J#!D\"p]\u001aLw-\u001e:bi&|g.A\tge\u0016,W*\u0019:lKJ\u001cuN\u001c4jO\u0002\nAcZ3oKJ\fG/\u001a*fG>\u0014HMU3q_J$HC\u0002\u001a6\u0017B+v\f\u0005\u0002\u001dg%\u0011A'\b\u0002\u0005+:LG\u000fC\u00037\t\u0001\u0007q'A\u0003baBLE\r\u0005\u00029\u0011:\u0011\u0011(\u0012\b\u0003u\rs!a\u000f\"\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA \u001a\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003\tN\ta\u0001Z8nC&t\u0017B\u0001$H\u0003\u0015iw\u000eZ3m\u0015\t!5#\u0003\u0002J\u0015\n)\u0011\t\u001d9JI*\u0011ai\u0012\u0005\u0006\u0019\u0012\u0001\r!T\u0001\fg\u000e\u0014X-\u001a8tQ>$8\u000f\u0005\u00029\u001d&\u0011qJ\u0013\u0002\u0011'\u000e\u0014X-\u001a8tQ>$8oU;ji\u0016DQ!\u0015\u0003A\u0002I\u000b1BY;jY\u00124u\u000e\u001c3feB\u0011\u0001hU\u0005\u0003)*\u0013aAR8mI\u0016\u0014\b\"\u0002,\u0005\u0001\u00049\u0016A\u00024mCZ|'\u000f\u0005\u0002Y9:\u0011\u0011L\u0017\t\u0003{uI!aW\u000f\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037vAQ\u0001\u0019\u0003A\u0002]\u000b\u0011BY;jY\u0012$\u0016\u0010]3\u00025\u001d,g.\u001a:bi\u00164VM]5gS\u000e\fG/[8o%\u0016\u0004xN\u001d;\u0015\rI\u001aGM[6m\u0011\u00151T\u00011\u00018\u0011\u0015)W\u00011\u0001g\u0003-\u0019w.\u001c9be&\u001c\u0018n\u001c8\u0011\u0005\u001dDW\"A$\n\u0005%<%\u0001H*de\u0016,gn\u001d5piN\u001cu.\u001c9be&\u001c\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006#\u0016\u0001\rA\u0015\u0005\u0006-\u0016\u0001\ra\u0016\u0005\u0006A\u0016\u0001\raV\u0001\foJLG/\u001a*fa>\u0014H\u000fF\u00033_BTh\u0010C\u0003R\r\u0001\u0007!\u000bC\u0003r\r\u0001\u0007!/A\u0003j]B,H\u000f\u0005\u0003tq^;V\"\u0001;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\n\u0019Q*\u00199\t\u000b)2\u0001\u0019A>\u0011\u0005!b\u0018BA?*\u0005!!V-\u001c9mCR,\u0007\"B@\u0007\u0001\u00049\u0016\u0001\u0004:fa>\u0014HOR8mI\u0016\u0014\u0018a\u0006:fg\u0016$h+\u001a:jM&\u001c\u0017\r^5p]J+\u0007o\u001c:u)\u0019\t)!a\u0003\u0002\u000eA\u0019A$a\u0002\n\u0007\u0005%QD\u0001\u0004B]f4\u0016\r\u001c\u0005\u0006-\u001e\u0001\ra\u0016\u0005\u0006A\u001e\u0001\raV\u0001\u001dO\u0016tWM]1uKJ+7m\u001c:e)\u0016l\u0007\u000f\\1uKZ\u000bG.^3t)\u0015\u0011\u00181CA\u000b\u0011\u00151\u0004\u00021\u00018\u0011\u0015a\u0005\u00021\u0001N\u0003y9WM\\3sCR,'+Z2pe\u0012\u001cV/\\7bef$\u0016M\u00197f\u0005>$\u0017\u0010F\u0002X\u00037AQ\u0001T\u0005A\u00025\u000b!eZ3oKJ\fG/\u001a,fe&4\u0017nY1uS>tG+Z7qY\u0006$XMV1mk\u0016\u001cH#\u0002:\u0002\"\u0005\r\u0002\"\u0002\u001c\u000b\u0001\u00049\u0004\"B3\u000b\u0001\u00041\u0017\u0001H4fiN{'\u000f^3e\u0005f\u0014Vm];miN\u001b'/Z3og\"|Go\u001d\u000b\u0005\u0003S\ti\u0005\u0005\u0004\u0002,\u0005E\u0012QG\u0007\u0003\u0003[Q1!a\f\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\tiCA\u0002TKF\u0004r\u0001HA\u001c\u0003w\t\t%C\u0002\u0002:u\u0011a\u0001V;qY\u0016\u0014\u0004cA4\u0002>%\u0019\u0011qH$\u0003\u0015M\u001b'/Z3og\"|G\u000fE\u0003\u001d\u0003\u0007\n9%C\u0002\u0002Fu\u0011aa\u00149uS>t\u0007cA4\u0002J%\u0019\u00111J$\u00035M\u001b'/Z3og\"|GoQ8na\u0006\u0014\u0018n]5p]\u0016\u0013(o\u001c:\t\r\u0005=3\u00021\u0001g\u0003)\u0019w.\u001c9be&\u001cxN\\\u0001%O\u0016tWM]1uKZ+'/\u001b4jG\u0006$\u0018n\u001c8Tk6l\u0017M]=UC\ndWMQ8esR\u0019q+!\u0016\t\u000b\u0015d\u0001\u0019\u00014\u00029\u001d,g.\u001a:bi\u0016\u001c6M]3f]NDw\u000e^:UC\ndWMQ8esR\u0019q+a\u0017\t\u000b\u0015l\u0001\u0019\u00014\u0002\u0013\u0019Lg\u000eZ#se>\u0014HCBA!\u0003C\n)\u0007C\u0004\u0002d9\u0001\r!a\u000f\u0002\u0015M\u001c'/Z3og\"|G\u000fC\u0004\u0002h9\u0001\r!!\u001b\u0002\r\u0015\u0014(o\u001c:t!\rA\u00141N\u0005\u0004\u0003[R%aG*de\u0016,gn\u001d5pi\u000e{W\u000e]1sSNLwN\\#se>\u00148/A\u000bhK:,'/\u0019;f%\u0016\f7o\u001c8NKN\u001c\u0018mZ3\u0015\u0007]\u000b\u0019\bC\u0004\u0002v=\u0001\r!!\u0011\u0002\u000b\u0015\u0014(o\u001c:")
public class ExecutionReporter {
    private final Configuration freeMarkerConfig;

    private Configuration freeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void generateRecordReport(String appId, Seq<Screenshot> screenshots, String buildFolder, String flavor, String buildType) {
        java.util.Map<String, String> input = this.generateRecordTemplateValues(appId, screenshots);
        Template template = this.freeMarkerConfig().getTemplate("recordIndex.ftl");
        this.resetVerificationReport(flavor, buildType);
        String reportFolder = new StringBuilder(1).append(buildFolder).append(Config$.MODULE$.recordingReportFolder(flavor, buildType)).append("/").toString();
        this.writeReport(buildFolder, input, template, reportFolder);
    }

    public void generateVerificationReport(String appId, ScreenshotsComparisionResult comparision, String buildFolder, String flavor, String buildType) {
        java.util.Map<String, String> input = this.generateVerificationTemplateValues(appId, comparision);
        Template template = this.freeMarkerConfig().getTemplate("verificationIndex.ftl");
        this.resetVerificationReport(flavor, buildType);
        String reportFolder = new StringBuilder(1).append(buildFolder).append(Config$.MODULE$.verificationReportFolder(flavor, buildType)).append("/").toString();
        this.writeReport(buildFolder, input, template, reportFolder);
    }

    private void writeReport(String buildFolder, java.util.Map<String, String> input, Template template, String reportFolder) {
        File indexFile = new File(new StringBuilder(10).append(reportFolder).append("index.html").toString());
        new File(reportFolder).mkdirs();
        FileWriter writer = new FileWriter(indexFile);
        template.process(input, (Writer)writer);
        writer.close();
    }

    private Object resetVerificationReport(String flavor, String buildType) {
        File file = new File(new StringBuilder(11).append(Config$.MODULE$.verificationReportFolder(flavor, buildType)).append("/index.html").toString());
        return file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
    }

    private java.util.Map<String, String> generateRecordTemplateValues(String appId, Seq<Screenshot> screenshots) {
        String title = new StringBuilder(16).append("Record results: ").append(appId).toString();
        int numberOfTests = screenshots.size();
        String summaryResults = new StringBuilder(27).append(numberOfTests).append(" screenshot tests recorded.").toString();
        String summaryTableBody = this.generateRecordSummaryTableBody(screenshots);
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)title), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"summaryResult"), (Object)summaryResults), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"summaryTableBody"), (Object)summaryTableBody)}))).asJava();
    }

    private String generateRecordSummaryTableBody(Seq<Screenshot> screenshots) {
        return ((TraversableOnce)screenshots.map((Function1 & Serializable & scala.Serializable)screenshot -> {
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
            int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
            return new StringBuilder(103).append("<tr>").append("<th> <p>Test class: ").append(testClass).append("</p>").append("<p>Test name: ").append(testName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("</tr>").toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private java.util.Map<String, String> generateVerificationTemplateValues(String appId, ScreenshotsComparisionResult comparision) {
        String title = new StringBuilder(22).append("Verification results: ").append(appId).toString();
        Seq<Screenshot> screenshots = comparision.screenshots();
        int numberOfTests = screenshots.size();
        int failedNumber = comparision.errors().size();
        int successNumber = numberOfTests - failedNumber;
        String summaryResults = new StringBuilder(48).append(numberOfTests).append(" screenshot tests executed. ").append(successNumber).append(" passed and ").append(failedNumber).append(" failed.").toString();
        String summaryTableBody = this.generateVerificationSummaryTableBody(comparision);
        String screenshotsTableBody = this.generateScreenshotsTableBody(comparision);
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)title), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"summaryResult"), (Object)summaryResults), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"summaryTableBody"), (Object)summaryTableBody), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"screenshotsTableBody"), (Object)screenshotsTableBody)}))).asJava();
    }

    private Seq<Tuple2<Screenshot, Option<ScreenshotComparisionError>>> getSortedByResultScreenshots(ScreenshotsComparisionResult comparison) {
        return (Seq)((SeqLike)comparison.screenshots().map((Function1 & Serializable & scala.Serializable)screenshot -> {
            Option<ScreenshotComparisionError> error = this.findError((Screenshot)screenshot, comparison.errors());
            return new Tuple2(screenshot, error);
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$getSortedByResultScreenshots$2(x$1)), (Ordering)Ordering.Boolean$.MODULE$);
    }

    private String generateVerificationSummaryTableBody(ScreenshotsComparisionResult comparision) {
        return ((TraversableOnce)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Screenshot screenshot = (Screenshot)tuple2._1();
            Option error = (Option)tuple2._2();
            boolean isFailedTest = error.isDefined();
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String result = isFailedTest ? "\u274c" : "\u2705";
            String reason = this.generateReasonMessage((Option<ScreenshotComparisionError>)error);
            String color = isFailedTest ? "red-text" : "green-text";
            String id = screenshot.name().replace(".", "");
            String string = new StringBuilder(122).append("<tr>").append("<th><a href='#").append(id).append("'>").append(result).append("</></th>").append("<th><a href='#").append(id).append("'><p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p></a></th>").append("<th>").append(reason).append("</th>").append("</tr>").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String generateScreenshotsTableBody(ScreenshotsComparisionResult comparision) {
        return ((TraversableOnce)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Screenshot screenshot = (Screenshot)tuple2._1();
            Option error = (Option)tuple2._2();
            boolean isFailedTest = error.isDefined();
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
            String newScreenshot = new StringBuilder(13).append("./images/").append(screenshot.name()).append(".png").toString();
            String diff = error.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$generateScreenshotsTableBody$2(x$2))) ? screenshot.getDiffScreenshotPath("./images/") : "";
            String color = isFailedTest ? "red-text" : "green-text";
            int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
            String id = screenshot.name().replace(".", "");
            String string = new StringBuilder(221).append("<tr>").append("<th id='").append(id).append("'> <p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("<th> <a href='").append(newScreenshot).append("'><img width='").append(width).append("' src='").append(newScreenshot).append("'/></a></th>").append("<th> <a href='").append(diff).append("'><img width='").append(width).append("' src='").append(diff).append("'/></a></th>").append("</tr>").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Option<ScreenshotComparisionError> findError(Screenshot screenshot, Seq<ScreenshotComparisionError> errors) {
        return errors.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionReporter.$anonfun$findError$1(screenshot, x0$1)));
    }

    private String generateReasonMessage(Option<ScreenshotComparisionError> error) {
        return (String)error.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScreenshotComparisionError screenshotComparisionError = x0$1;
            String string = screenshotComparisionError instanceof ScreenshotNotFound ? "<p class='red-text'>\ud83d\udd0e  Recorded screenshot not found.</p>" : (screenshotComparisionError instanceof DifferentScreenshots ? "<p class='red-text'>\ud83e\udd14  The application UI has been modified.</p>" : (screenshotComparisionError instanceof DifferentImageDimensions ? "<p class='red-text'>\ud83d\udcf1  The size of the screenshot taken has changed.</p>" : "<p class='red-text'>\ud83d\ude1e  Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.</p>"));
            return string;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$getSortedByResultScreenshots$2(Tuple2 x$1) {
        return ((Option)x$1._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateScreenshotsTableBody$2(ScreenshotComparisionError x$2) {
        return x$2 instanceof DifferentScreenshots;
    }

    public static final /* synthetic */ boolean $anonfun$findError$1(Screenshot screenshot$1, ScreenshotComparisionError x0$1) {
        boolean bl;
        ScreenshotComparisionError screenshotComparisionError = x0$1;
        if (screenshotComparisionError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisionError;
            Screenshot error = screenshotNotFound.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot2 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot2) : screenshot2 != null);
        } else if (screenshotComparisionError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisionError;
            Screenshot error = differentImageDimensions.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot3 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot3) : screenshot3 != null);
        } else if (screenshotComparisionError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisionError;
            Screenshot error = differentScreenshots.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot4 = error;
            bl = !(screenshot != null ? !((Object)screenshot).equals(screenshot4) : screenshot4 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutionReporter() {
        void var1_1;
        Configuration config = new Configuration(Configuration.VERSION_2_3_23);
        config.setClassForTemplateLoading(this.getClass(), "/templates/");
        config.setDefaultEncoding("UTF-8");
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freeMarkerConfig = var1_1;
    }
}

