/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.screenshots;

import com.karumi.shot.domain.Config$;
import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.DifferentScreenshots$;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisionError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.screenshots.ScreenshotComposer$;
import com.sksamuel.scrimage.Image;
import com.sksamuel.scrimage.Image$;
import com.sksamuel.scrimage.Pixel;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054AAB\u0004\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\b\u0001C\u0005y!)\u0011\n\u0001C\u0005\u0015\")A\f\u0001C\u0005;\n)2k\u0019:fK:\u001c\bn\u001c;t\u0007>l\u0007/\u0019:bi>\u0014(B\u0001\u0005\n\u0003-\u00198M]3f]NDw\u000e^:\u000b\u0005)Y\u0011\u0001B:i_RT!\u0001D\u0007\u0002\r-\f'/^7j\u0015\u0005q\u0011aA2p[\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\bG>l\u0007/\u0019:f)\ri2E\u000e\t\u0003=\u0005j\u0011a\b\u0006\u0003A%\ta\u0001Z8nC&t\u0017B\u0001\u0012 \u0005q\u00196M]3f]NDw\u000e^:D_6\u0004\u0018M]5tS>t'+Z:vYRDQ\u0001\u0003\u0002A\u0002\u0011\u0002\"!J\u001a\u000f\u0005\u0019\ndBA\u00141\u001d\tAsF\u0004\u0002*]9\u0011!&L\u0007\u0002W)\u0011AfD\u0001\u0007yI|w\u000e\u001e \n\u00039I!\u0001D\u0007\n\u0005)Y\u0011B\u0001\u0011\n\u0013\t\u0011t$A\u0003n_\u0012,G.\u0003\u00025k\t\u00012k\u0019:fK:\u001c\bn\u001c;t'VLG/\u001a\u0006\u0003e}AQa\u000e\u0002A\u0002a\n\u0011\u0002^8mKJ\fgnY3\u0011\u0005II\u0014B\u0001\u001e\u0014\u0005\u0019!u.\u001e2mK\u0006\t2m\\7qCJ,7k\u0019:fK:\u001c\bn\u001c;\u0015\u0007u\u001a\u0005\nE\u0002\u0013}\u0001K!aP\n\u0003\r=\u0003H/[8o!\tq\u0012)\u0003\u0002C?\tQ2k\u0019:fK:\u001c\bn\u001c;D_6\u0004\u0018M]5tS>tWI\u001d:pe\")Ai\u0001a\u0001\u000b\u0006Q1o\u0019:fK:\u001c\bn\u001c;\u0011\u0005y1\u0015BA$ \u0005)\u00196M]3f]NDw\u000e\u001e\u0005\u0006o\r\u0001\r\u0001O\u0001\u0013S6\fw-Z:Be\u0016$\u0015N\u001a4fe\u0016tG\u000fF\u0003L\u001d>K6\f\u0005\u0002\u0013\u0019&\u0011Qj\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015!E\u00011\u0001F\u0011\u0015\u0001F\u00011\u0001R\u00035yG\u000eZ*de\u0016,gn\u001d5piB\u0011!kV\u0007\u0002'*\u0011A+V\u0001\tg\u000e\u0014\u0018.\\1hK*\u0011a+D\u0001\tg.\u001c\u0018-\\;fY&\u0011\u0001l\u0015\u0002\u0006\u00136\fw-\u001a\u0005\u00065\u0012\u0001\r!U\u0001\u000e]\u0016<8k\u0019:fK:\u001c\bn\u001c;\t\u000b]\"\u0001\u0019\u0001\u001d\u0002%!\fg/Z*b[\u0016$\u0015.\\3og&|gn\u001d\u000b\u0004\u0017z{\u0006\"\u0002.\u0006\u0001\u0004\t\u0006\"\u00021\u0006\u0001\u0004\t\u0016A\u0005:fG>\u0014H-\u001a3TGJ,WM\\:i_R\u0004")
public class ScreenshotsComparator {
    public ScreenshotsComparisionResult compare(Seq<Screenshot> screenshots, double tolerance) {
        List errors = ((ParIterableLike)((ParIterableLike)screenshots.par()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(this.compareScreenshot((Screenshot)x$1, tolerance)), (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).toList();
        return new ScreenshotsComparisionResult((Seq<ScreenshotComparisionError>)errors, screenshots);
    }

    private Option<ScreenshotComparisionError> compareScreenshot(Screenshot screenshot, double tolerance) {
        Object object;
        File recordedScreenshotFile = new File(screenshot.recordedScreenshotPath());
        if (!recordedScreenshotFile.exists()) {
            object = new Some((Object)new ScreenshotNotFound(screenshot));
        } else {
            Image oldScreenshot = Image$.MODULE$.fromFile(recordedScreenshotFile);
            Image newScreenshot = ScreenshotComposer$.MODULE$.composeNewScreenshot(screenshot);
            if (!this.haveSameDimensions(newScreenshot, oldScreenshot)) {
                Dimension originalDimension = new Dimension(oldScreenshot.width(), oldScreenshot.height());
                Dimension newDimension = new Dimension(newScreenshot.width(), newScreenshot.height());
                object = new Some((Object)new DifferentImageDimensions(screenshot, originalDimension, newDimension));
            } else {
                object = this.imagesAreDifferent(screenshot, oldScreenshot, newScreenshot, tolerance) ? new Some((Object)new DifferentScreenshots(screenshot, DifferentScreenshots$.MODULE$.apply$default$2())) : None$.MODULE$;
            }
        }
        return object;
    }

    private boolean imagesAreDifferent(Screenshot screenshot, Image oldScreenshot, Image newScreenshot, double tolerance) {
        boolean bl;
        Image image = oldScreenshot;
        Image image2 = newScreenshot;
        if (!(image != null ? !image.equals(image2) : image2 != null)) {
            bl = false;
        } else {
            boolean imagesAreConsideredEquals;
            Pixel[] oldScreenshotPixels = oldScreenshot.pixels();
            Pixel[] newScreenshotPixels = newScreenshot.pixels();
            int differentPixels = ((Pixel[])Predef$.MODULE$.genericArrayOps((Object)oldScreenshotPixels).diff((GenSeq)Predef$.MODULE$.genericWrapArray((Object)newScreenshotPixels))).length;
            double percentageOfDifferentPixels = (double)differentPixels / (double)oldScreenshotPixels.length;
            double percentageOutOf100 = percentageOfDifferentPixels * 100.0;
            boolean imagesAreDifferent = percentageOutOf100 >= tolerance;
            boolean bl2 = imagesAreConsideredEquals = !imagesAreDifferent;
            if (imagesAreConsideredEquals && tolerance != Config$.MODULE$.defaultTolerance()) {
                String screenshotName = screenshot.name();
                Predef$.MODULE$.println((Object)new StringBuilder(205).append("\u001b[33m").append("\u26a0\ufe0f   Shot warning: There are some pixels changed in the screenshot named ").append(screenshotName).append(", but we consider the comparison correct because tolerance is configured to ").append(tolerance).append(" % and the percentage of different pixels is ").append(percentageOutOf100).append(" %").append("\u001b[0m").toString());
            }
            bl = imagesAreDifferent;
        }
        return bl;
    }

    private boolean haveSameDimensions(Image newScreenshot, Image recordedScreenshot) {
        return newScreenshot.width() == recordedScreenshot.width() && newScreenshot.height() == recordedScreenshot.height();
    }
}

