/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.screenshots;

import com.karumi.shot.domain.Config$;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.screenshots.ScreenshotComposer$;
import com.sksamuel.scrimage.Image;
import com.sksamuel.scrimage.Image$;
import com.sksamuel.scrimage.nio.ImageWriter;
import com.sksamuel.scrimage.nio.ImageWriter$;
import java.io.File;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4AAC\u0006\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)!\n\u0001C\u0001\u0017\")\u0011\u000b\u0001C\u0001%\")\u0001\f\u0001C\u00013\")a\r\u0001C\u0005O\")1\u000e\u0001C\u0005Y\")a\u000e\u0001C\u0005_\")!\u000f\u0001C\u0005g\n\u00012k\u0019:fK:\u001c\bn\u001c;t'\u00064XM\u001d\u0006\u0003\u00195\t1b]2sK\u0016t7\u000f[8ug*\u0011abD\u0001\u0005g\"|GO\u0003\u0002\u0011#\u000511.\u0019:v[&T\u0011AE\u0001\u0004G>l7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\f\u0003]\u0019\u0018M^3SK\u000e|'\u000fZ3e'\u000e\u0014X-\u001a8tQ>$8\u000fF\u0003\"Ii\"e\t\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0005+:LG\u000fC\u0003&\u0005\u0001\u0007a%A\u0007qe>TWm\u0019;G_2$WM\u001d\t\u0003O]r!\u0001\u000b\u001b\u000f\u0005%\u0012dB\u0001\u00162\u001d\tY\u0003G\u0004\u0002-_5\tQF\u0003\u0002/'\u00051AH]8pizJ\u0011AE\u0005\u0003!EI!AD\b\n\u0005Mj\u0011A\u00023p[\u0006Lg.\u0003\u00026m\u0005)Qn\u001c3fY*\u00111'D\u0005\u0003qe\u0012aAR8mI\u0016\u0014(BA\u001b7\u0011\u0015Y$\u00011\u0001=\u0003\u00191G.\u0019<peB\u0011Q(\u0011\b\u0003}}\u0002\"\u0001L\f\n\u0005\u0001;\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\f\t\u000b\u0015\u0013\u0001\u0019\u0001\u001f\u0002\u0013\t,\u0018\u000e\u001c3UsB,\u0007\"\u0002\u0007\u0003\u0001\u00049\u0005CA\u0014I\u0013\tI\u0015H\u0001\tTGJ,WM\\:i_R\u001c8+^5uK\u000692/\u0019<f)\u0016l\u0007o\u001c:bYN\u001b'/Z3og\"|Go\u001d\u000b\u0005C1ku\nC\u0003\r\u0007\u0001\u0007q\tC\u0003O\u0007\u0001\u0007A(A\u0006qe>TWm\u0019;OC6,\u0007\"\u0002)\u0004\u0001\u0004a\u0014\u0001\u0004:fa>\u0014HOR8mI\u0016\u0014\u0018\u0001K2paf\u0014VmY8sI\u0016$7k\u0019:fK:\u001c\bn\u001c;t)>$\u0006.\u001a*fa>\u0014HOR8mI\u0016\u0014H#B\u0011T)V3\u0006\"B\u0013\u0005\u0001\u00041\u0003\"B\u001e\u0005\u0001\u0004a\u0004\"B#\u0005\u0001\u0004a\u0004\"B,\u0005\u0001\u00041\u0013!\u00043fgRLg.\u001f$pY\u0012,'/\u0001\fhKR\u001c6M]3f]NDw\u000e\u001e#j[\u0016t7/[8o)\u0015Qfl\u00181b!\tYF,D\u00017\u0013\tifGA\u0005ES6,gn]5p]\")Q%\u0002a\u0001y!)1(\u0002a\u0001y!)Q)\u0002a\u0001y!)!-\u0002a\u0001G\u0006Q1o\u0019:fK:\u001c\bn\u001c;\u0011\u0005m#\u0017BA37\u0005)\u00196M]3f]NDw\u000e^\u0001\u0015I\u0016dW\r^3PY\u0012\u001c6M]3f]NDw\u000e^:\u0015\t\u0005B\u0017N\u001b\u0005\u0006K\u0019\u0001\rA\n\u0005\u0006w\u0019\u0001\r\u0001\u0010\u0005\u0006\u000b\u001a\u0001\r\u0001P\u0001\u001dI\u0016dW\r^3PY\u0012$V-\u001c9pe\u0006d7k\u0019:fK:\u001c\bn\u001c;t)\t\tS\u000eC\u0003O\u000f\u0001\u0007A(\u0001\u0007eK2,G/\u001a$pY\u0012,'\u000f\u0006\u0002\"a\")\u0011\u000f\u0003a\u0001y\u0005!\u0001/\u0019;i\u0003=\u0019\u0018M^3TGJ,WM\\:i_R\u001cHcA\u0011uk\")A\"\u0003a\u0001\u000f\")a/\u0003a\u0001M\u00051am\u001c7eKJ\u0004")
public class ScreenshotsSaver {
    public void saveRecordedScreenshots(String projectFolder, String flavor, String buildType, Seq<Screenshot> screenshots) {
        this.deleteOldScreenshots(projectFolder, flavor, buildType);
        this.saveScreenshots(screenshots, new StringBuilder(0).append(projectFolder).append(Config$.MODULE$.screenshotsFolderName(flavor, buildType)).toString());
    }

    public void saveTemporalScreenshots(Seq<Screenshot> screenshots, String projectName, String reportFolder) {
        this.deleteOldTemporalScreenshots(projectName);
        this.saveScreenshots(screenshots, new StringBuilder(1).append(Config$.MODULE$.screenshotsTemporalRootPath()).append(projectName).append("/").toString());
        this.deleteFolder(reportFolder);
        this.saveScreenshots(screenshots, reportFolder);
    }

    public void copyRecordedScreenshotsToTheReportFolder(String projectFolder, String flavor, String buildType, String destinyFolder) {
        String recordedScreenshotsFolder = new StringBuilder(0).append(projectFolder).append(Config$.MODULE$.screenshotsFolderName(flavor, buildType)).toString();
        FileUtils.copyDirectory((File)new File(recordedScreenshotsFolder), (File)new File(destinyFolder));
        this.deleteFolder(destinyFolder);
    }

    public Dimension getScreenshotDimension(String projectFolder, String flavor, String buildType, Screenshot screenshot) {
        String screenshotPath = new StringBuilder(4).append(projectFolder).append(Config$.MODULE$.pulledScreenshotsFolder(flavor, buildType)).append(screenshot.name()).append(".png").toString();
        Image image = Image$.MODULE$.fromFile(new File(screenshotPath));
        return new Dimension(image.width(), image.height());
    }

    private void deleteOldScreenshots(String projectFolder, String flavor, String buildType) {
        this.deleteFolder(new StringBuilder(0).append(projectFolder).append(Config$.MODULE$.screenshotsFolderName(flavor, buildType)).toString());
    }

    private void deleteOldTemporalScreenshots(String projectName) {
        this.deleteFolder(new StringBuilder(1).append(Config$.MODULE$.screenshotsTemporalRootPath()).append(projectName).append("/").toString());
    }

    private void deleteFolder(String path) {
        block0: {
            File folder = new File(path);
            if (!folder.exists()) break block0;
            folder.delete();
        }
    }

    private void saveScreenshots(Seq<Screenshot> screenshots, String folder) {
        File screenshotsFolder = new File(folder);
        Object object = !screenshotsFolder.exists() ? BoxesRunTime.boxToBoolean((boolean)screenshotsFolder.mkdirs()) : BoxedUnit.UNIT;
        ((ParIterableLike)screenshots.par()).foreach((Function1 & java.io.Serializable & Serializable)screenshot -> {
            File outputFile = new File(new StringBuilder(0).append(folder).append(screenshot.fileName()).toString());
            Object object = !outputFile.exists() ? BoxesRunTime.boxToBoolean((boolean)outputFile.createNewFile()) : BoxedUnit.UNIT;
            Image image = ScreenshotComposer$.MODULE$.composeNewScreenshot((Screenshot)screenshot);
            return image.output(outputFile, (ImageWriter)ImageWriter$.MODULE$.default());
        });
    }
}

