/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.karumi.shot.Files;
import com.karumi.shot.android.Adb;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ScreenshotsComparisionResult$;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.json.ScreenshotsComposeSuiteJsonParser$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.system.EnvVars;
import com.karumi.shot.ui.Console;
import com.karumi.shot.xml.ScreenshotsSuiteJsonParser$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.tinyzip.TinyZip;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u000f\u001e\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")1\u000e\u0001C\u0001Y\")q\u000f\u0001C\u0001q\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002j\u0002!I!a;\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA~\u0001\u0011%\u0011Q \u0002\u0005'\"|GO\u0003\u0002\u001f?\u0005!1\u000f[8u\u0015\t\u0001\u0013%\u0001\u0004lCJ,X.\u001b\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0007\u0005$'\r\u0005\u0002.a5\taF\u0003\u00020;\u00059\u0011M\u001c3s_&$\u0017BA\u0019/\u0005\r\tEMY\u0001\u0006M&dWm\u001d\t\u0003iUj\u0011!H\u0005\u0003mu\u0011QAR5mKN\fQc]2sK\u0016t7\u000f[8ug\u000e{W\u000e]1sCR|'\u000f\u0005\u0002:y5\t!H\u0003\u0002<;\u0005Y1o\u0019:fK:\u001c\bn\u001c;t\u0013\ti$HA\u000bTGJ,WM\\:i_R\u001c8i\\7qCJ\fGo\u001c:\u00021M\u001c'/Z3og\"|Go\u001d#jM\u001a<UM\\3sCR|'\u000f\u0005\u0002:\u0001&\u0011\u0011I\u000f\u0002\u0019'\u000e\u0014X-\u001a8tQ>$8\u000fR5gM\u001e+g.\u001a:bi>\u0014\u0018\u0001E:de\u0016,gn\u001d5piN\u001c\u0016M^3s!\tID)\u0003\u0002Fu\t\u00012k\u0019:fK:\u001c\bn\u001c;t'\u00064XM]\u0001\bG>t7o\u001c7f!\tA5*D\u0001J\u0015\tQU$\u0001\u0002vS&\u0011A*\u0013\u0002\b\u0007>t7o\u001c7f\u0003%\u0011X\r]8si\u0016\u00148\u000fE\u0002P/js!\u0001U+\u000f\u0005E#V\"\u0001*\u000b\u0005M\u001b\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\t1v%A\u0004qC\u000e\\\u0017mZ3\n\u0005aK&\u0001\u0002'jgRT!AV\u0014\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0012a\u0002:fa>\u0014Ho]\u0005\u0003?r\u0013\u0011#\u0012=fGV$\u0018n\u001c8SKB|'\u000f^3s\u0003=\u0019wN\\:pY\u0016\u0014V\r]8si\u0016\u0014\bCA.c\u0013\t\u0019GLA\bD_:\u001cx\u000e\\3SKB|'\u000f^3s\u0003\u001d)gN\u001e,beN\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u000f\u0002\rML8\u000f^3n\u0013\tQwMA\u0004F]Z4\u0016M]:\u0002\rqJg.\u001b;?))ign\u001c9reN$XO\u001e\t\u0003i\u0001AQa\u000b\u0006A\u00021BQA\r\u0006A\u0002MBQa\u000e\u0006A\u0002aBQA\u0010\u0006A\u0002}BQA\u0011\u0006A\u0002\rCQA\u0012\u0006A\u0002\u001dCQ!\u0014\u0006A\u00029CQ\u0001\u0019\u0006A\u0002\u0005DQ\u0001\u001a\u0006A\u0002\u0015\f1\u0003Z8x]2|\u0017\rZ*de\u0016,gn\u001d5piN$b!\u001f?\u0002 \u0005-\u0002C\u0001\u0014{\u0013\tYxE\u0001\u0003V]&$\b\"B?\f\u0001\u0004q\u0018!B1qa&#\u0007cA@\u0002\u001a9!\u0011\u0011AA\n\u001d\u0011\t\u0019!a\u0004\u000f\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tYAD\u0002R\u0003\u0013I\u0011AI\u0005\u0003A\u0005J!AH\u0010\n\u0007\u0005EQ$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003+\t9\"A\u0003n_\u0012,GNC\u0002\u0002\u0012uIA!a\u0007\u0002\u001e\t)\u0011\t\u001d9JI*!\u0011QCA\f\u0011\u001d\t\tc\u0003a\u0001\u0003G\t!b\u001d5pi\u001a{G\u000eZ3s!\u0011\t)#a\n\u000e\u0005\u0005]\u0011\u0002BA\u0015\u0003/\u0011!b\u00155pi\u001a{G\u000eZ3s\u0011\u001d\tic\u0003a\u0001\u0003_\tAb\u001c:dQ\u0016\u001cHO]1uK\u0012\u00042AJA\u0019\u0013\r\t\u0019d\n\u0002\b\u0005>|G.Z1o\u0003E\u0011XmY8sIN\u001b'/Z3og\"|Go\u001d\u000b\bs\u0006e\u00121HA\u001f\u0011\u0015iH\u00021\u0001\u007f\u0011\u001d\t\t\u0003\u0004a\u0001\u0003GAq!!\f\r\u0001\u0004\ty#A\twKJLg-_*de\u0016,gn\u001d5piN$\u0002#a\u0011\u0002J\u0005-\u0013QJA1\u0003K\ny'a\u001d\u0011\t\u0005\u0015\u0012QI\u0005\u0005\u0003\u000f\n9B\u0001\u000fTGJ,WM\\:i_R\u001c8i\\7qCJL7/[8o%\u0016\u001cX\u000f\u001c;\t\u000bul\u0001\u0019\u0001@\t\u000f\u0005\u0005R\u00021\u0001\u0002$!9\u0011qJ\u0007A\u0002\u0005E\u0013a\u00039s_*,7\r\u001e(b[\u0016\u0004B!a\u0015\u0002\\9!\u0011QKA,!\t\tv%C\u0002\u0002Z\u001d\na\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003?\u0012aa\u0015;sS:<'bAA-O!9\u00111M\u0007A\u0002\u0005=\u0012AF:i_VdG\r\u0015:j]R\u0014\u0015m]37i\u0015\u0013(o\u001c:\t\u000f\u0005\u001dT\u00021\u0001\u0002j\u0005IAo\u001c7fe\u0006t7-\u001a\t\u0004M\u0005-\u0014bAA7O\t1Ai\\;cY\u0016Dq!!\u001d\u000e\u0001\u0004\ty#A\u000ftQ><xJ\u001c7z\r\u0006LG.\u001b8h)\u0016\u001cHo]%o%\u0016\u0004xN\u001d;t\u0011\u001d\ti#\u0004a\u0001\u0003_\t\u0011C]3n_Z,7k\u0019:fK:\u001c\bn\u001c;t)\u0015I\u0018\u0011PA>\u0011\u0015ih\u00021\u0001\u007f\u0011\u001d\tiC\u0004a\u0001\u0003_\t\u0001'\\8wK\u000e{W\u000e]8tKN\u001b'/Z3og\"|Go\u001d+p%\u0016<W\u000f\\1s'\u000e\u0014X-\u001a8tQ>$8OR8mI\u0016\u0014H#B=\u0002\u0002\u0006\r\u0005bBA\u0011\u001f\u0001\u0007\u00111\u0005\u0005\b\u0003[y\u0001\u0019AA\u0018\u0003a\u0011XmY8sIJ+w-\u001e7beN\u001b'/Z3og\"|Go\u001d\u000b\u0005\u0003\u0013\u000b)\nE\u0003'\u0003\u0017\u000by)C\u0002\u0002\u000e\u001e\u0012aa\u00149uS>t\u0007cA@\u0002\u0012&!\u00111SA\u000f\u0005A\u00196M]3f]NDw\u000e^:Tk&$X\rC\u0004\u0002\"A\u0001\r!a\t\u00021I,7m\u001c:e\u0007>l\u0007o\\:f'\u000e\u0014X-\u001a8tQ>$8\u000f\u0006\u0003\u0002\n\u0006m\u0005bBA\u0011#\u0001\u0007\u00111E\u0001\u0011G2,\u0017M]*de\u0016,gn\u001d5piN$R!_AQ\u0003GCQ! \nA\u0002yDq!!\f\u0013\u0001\u0004\ty#A\u0007g_J,\u0015m\u00195EKZL7-Z\u000b\u0005\u0003S\u000bI\fF\u0002z\u0003WCq!!,\u0014\u0001\u0004\ty+A\u0001g!\u001d1\u0013\u0011WA)\u0003kK1!a-(\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u00028\u0006eF\u0002\u0001\u0003\b\u0003w\u001b\"\u0019AA_\u0005\u0005!\u0016\u0003BA`\u0003\u000b\u00042AJAa\u0013\r\t\u0019m\n\u0002\b\u001d>$\b.\u001b8h!\r1\u0013qY\u0005\u0004\u0003\u0013<#aA!os\u00069A-\u001a<jG\u0016\u001cHCAAh!\u0011yu+!\u0015\u0002K\r\u0014X-\u0019;f'\u000e\u0014X-\u001a8tQ>$8OR8mI\u0016\u0014\u0018J\u001a#pKNtu\u000e^#ySN$H\u0003BA\u0018\u0003+Da!a6\u0016\u0001\u0004q\u0018!E:de\u0016,gn\u001d5piN4u\u000e\u001c3fe\u0006y\u0001/\u001e7m'\u000e\u0014X-\u001a8tQ>$8\u000fF\u0004z\u0003;\fy.!9\t\u000bu4\u0002\u0019\u0001@\t\u000f\u0005\u0005b\u00031\u0001\u0002$!9\u0011Q\u0006\fA\u0002\u0005=\u0012a\u0006:fC\u0012\u001c6M]3f]NDw\u000e^:NKR\fG-\u0019;b)\u0011\tI)a:\t\u000f\u0005\u0005r\u00031\u0001\u0002$\u0005q\"/Z1e\u0007>l\u0007o\\:f'\u000e\u0014X-\u001a8tQ>$8/T3uC\u0012\fG/\u0019\u000b\u0005\u0003\u0013\u000bi\u000fC\u0004\u0002\"a\u0001\r!a\t\u0002MI,Wn\u001c<f!J|'.Z2u)\u0016l\u0007o\u001c:bYN\u001b'/Z3og\"|Go\u001d$pY\u0012,'\u000fF\u0002z\u0003gDq!!\t\u001a\u0001\u0004\t\u0019#A\rfqR\u0014\u0018m\u0019;QS\u000e$XO]3t\rJ|WNQ;oI2,GcA=\u0002z\"9\u0011q\u001b\u000eA\u0002\u0005E\u0013aE:bM\u0016$U\r\\3uK\u0012K'/Z2u_JLHcA=\u0002\u0000\"9!\u0011A\u000eA\u0002\t\r\u0011\u0001\u00024jY\u0016\u0004BA!\u0002\u0003\u00105\u0011!q\u0001\u0006\u0005\u0005\u0013\u0011Y!\u0001\u0002j_*\u0011!QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0012\t\u001d!\u0001\u0002$jY\u0016\u0004")
public class Shot {
    private final Adb adb;
    private final Files files;
    private final ScreenshotsComparator screenshotsComparator;
    private final ScreenshotsDiffGenerator screenshotsDiffGenerator;
    private final ScreenshotsSaver screenshotsSaver;
    private final Console console;
    private final List<ExecutionReporter> reporters;
    private final ConsoleReporter consoleReporter;
    private final EnvVars envVars;

    public void downloadScreenshots(String appId, ShotFolder shotFolder, boolean orchestrated) {
        this.console.show("\u2b07\ufe0f  Pulling screenshots from your connected devices!");
        this.pullScreenshots(appId, shotFolder, orchestrated);
    }

    public void recordScreenshots(String appId, ShotFolder shotFolder, boolean orchestrated) {
        this.console.show("\ud83d\udcbe  Saving screenshots.");
        this.moveComposeScreenshotsToRegularScreenshotsFolder(shotFolder, orchestrated);
        Option<Seq<Screenshot>> composeScreenshotSuite = this.recordComposeScreenshots(shotFolder);
        Option<Seq<Screenshot>> regularScreenshotSuite = this.recordRegularScreenshots(shotFolder);
        if (regularScreenshotSuite.isEmpty() && composeScreenshotSuite.isEmpty()) {
            this.console.showWarning("\ud83e\udd14 We couldn't find any screenshot. Did you configure Shot properly and added your tests to your project? https://github.com/pedrovgs/Shot/#getting-started");
            return;
        }
        Seq screenshots = (Seq)((IterableOps)regularScreenshotSuite.get()).$plus$plus((IterableOnce)composeScreenshotSuite.get());
        this.console.show(new StringBuilder(39).append("\ud83d\ude03  Screenshots recorded and saved at: ").append(shotFolder.screenshotsFolder()).toString());
        this.reporters.foreach((Function1 & Serializable)reporter -> {
            reporter.generateRecordReport(appId, (Seq<Screenshot>)screenshots, shotFolder);
            return BoxedUnit.UNIT;
        });
        this.console.show(new StringBuilder(56).append("\ud83e\udd13  You can review the execution report here: ").append(shotFolder.reportFolder()).append("index.html").toString());
        this.removeProjectTemporalScreenshotsFolder(shotFolder);
    }

    public ScreenshotsComparisionResult verifyScreenshots(String appId, ShotFolder shotFolder, String projectName, boolean shouldPrintBase64Error, double tolerance, boolean showOnlyFailingTestsInReports, boolean orchestrated) {
        this.console.show("\ud83d\udd0e  Comparing screenshots with previous ones.");
        this.moveComposeScreenshotsToRegularScreenshotsFolder(shotFolder, orchestrated);
        Option<Seq<Screenshot>> regularScreenshots = this.readScreenshotsMetadata(shotFolder);
        Option<Seq<Screenshot>> composeScreenshots = this.readComposeScreenshotsMetadata(shotFolder);
        if (regularScreenshots.isEmpty() && composeScreenshots.isEmpty()) {
            this.console.showWarning("\ud83e\udd14 We couldn't find any screenshot. Did you configure Shot properly and added your tests to your project? https://github.com/pedrovgs/Shot/#getting-started");
            return new ScreenshotsComparisionResult(ScreenshotsComparisionResult$.MODULE$.apply$default$1(), ScreenshotsComparisionResult$.MODULE$.apply$default$2());
        }
        Seq screenshots = (Seq)((IterableOps)regularScreenshots.get()).$plus$plus((IterableOnce)composeScreenshots.get());
        String newScreenshotsVerificationReportFolder = new StringBuilder(7).append(shotFolder.verificationReportFolder()).append("images/").toString();
        this.screenshotsSaver.saveTemporalScreenshots((Seq<Screenshot>)screenshots, projectName, newScreenshotsVerificationReportFolder, shotFolder);
        ScreenshotsComparisionResult comparison = this.screenshotsComparator.compare((Seq<Screenshot>)screenshots, tolerance);
        ScreenshotsComparisionResult updatedComparison = this.screenshotsDiffGenerator.generateDiffs(comparison, newScreenshotsVerificationReportFolder, shouldPrintBase64Error);
        if (showOnlyFailingTestsInReports) {
            String verificationReferenceImagesFolder = new StringBuilder(7).append(shotFolder.verificationReportFolder()).append("images/").toString();
            this.screenshotsSaver.removeNonFailingReferenceImages(verificationReferenceImagesFolder, comparison);
            this.screenshotsSaver.copyOnlyFailingRecordedScreenshotsToTheReportFolder(new StringBuilder(16).append(shotFolder.verificationReportFolder()).append("images/recorded/").toString(), updatedComparison);
        } else {
            this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.verificationReportFolder()).append("images/recorded/").toString());
        }
        if (updatedComparison.hasErrors()) {
            this.consoleReporter.showErrors(updatedComparison, newScreenshotsVerificationReportFolder);
            this.console.showError("\ud83e\udd14 Do you a need a hand with your automated tests or your Android app?");
            this.console.showError("   Maye I can help you! https://github.com/sponsors/pedrovgs\n");
        } else {
            this.console.showSuccess("\u2705  Yeah!!! Your tests are passing.");
        }
        this.reporters.foreach((Function1 & Serializable)reporter -> {
            reporter.generateVerificationReport(appId, comparison, shotFolder, showOnlyFailingTestsInReports);
            return BoxedUnit.UNIT;
        });
        this.console.show(new StringBuilder(56).append("\ud83e\udd13  You can review the execution report here: ").append(shotFolder.verificationReportFolder()).append("index.html").toString());
        this.removeProjectTemporalScreenshotsFolder(shotFolder);
        return comparison;
    }

    public void removeScreenshots(String appId, boolean orchestrated) {
        this.clearScreenshots(appId, orchestrated);
    }

    private void moveComposeScreenshotsToRegularScreenshotsFolder(ShotFolder shotFolder, boolean orchestrated) {
        String composeFolder = shotFolder.pulledComposeScreenshotsFolder();
        Stream.Empty$ fileList = Stream.Empty$.MODULE$;
        if (orchestrated) {
            String orchestratedComposeFolder = shotFolder.pulledComposeOrchestratedScreenshotsFolder();
            fileList = (Iterable)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(this.files.listFilesInFolder(composeFolder)).$plus$plus((IterableOnce)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(this.files.listFilesInFolder(orchestratedComposeFolder)));
        } else {
            fileList = ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(this.files.listFilesInFolder(composeFolder));
        }
        ImplicitConversions$.MODULE$.collection$u0020asJava((Iterable)fileList).forEach(file -> {
            String rawFilePath = file.getAbsolutePath();
            String newFilePath = new StringBuilder(0).append(shotFolder.pulledScreenshotsFolder()).append(file.getName()).toString();
            $this.files.rename(rawFilePath, newFilePath);
        });
    }

    private Option<Seq<Screenshot>> recordRegularScreenshots(ShotFolder shotFolder) {
        return this.readScreenshotsMetadata(shotFolder).map((Function1 & Serializable)screenshots -> {
            $this.screenshotsSaver.saveRecordedScreenshots(shotFolder.screenshotsFolder(), (Seq<Screenshot>)screenshots);
            $this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.recordingReportFolder()).append("images/recorded/").toString());
            return screenshots;
        });
    }

    private Option<Seq<Screenshot>> recordComposeScreenshots(ShotFolder shotFolder) {
        return this.readComposeScreenshotsMetadata(shotFolder).map((Function1 & Serializable)screenshots -> {
            $this.screenshotsSaver.saveRecordedScreenshots(shotFolder.screenshotsFolder(), (Seq<Screenshot>)screenshots);
            $this.screenshotsSaver.copyRecordedScreenshotsToTheReportFolder(shotFolder.screenshotsFolder(), new StringBuilder(16).append(shotFolder.recordingReportFolder()).append("images/recorded/").toString());
            return screenshots;
        });
    }

    private void clearScreenshots(String appId, boolean orchestrated) {
        this.forEachDevice((Function1 & Serializable)device -> {
            this.adb.clearScreenshots(device, appId, orchestrated);
            return BoxedUnit.UNIT;
        });
    }

    private <T> void forEachDevice(Function1<String, T> f) {
        this.devices().foreach(f);
    }

    private List<String> devices() {
        Some some;
        String device;
        List<String> allDevices = this.adb.devices();
        Option<String> specifiedDevice = this.envVars.androidSerial();
        Option<String> option = specifiedDevice;
        if (option instanceof Some && allDevices.contains((Object)(device = (String)(some = (Some)option).value()))) {
            return new .colon.colon((Object)device, (List)Nil$.MODULE$);
        }
        return allDevices;
    }

    private boolean createScreenshotsFolderIfDoesNotExist(String screenshotsFolder) {
        File folder = new File(screenshotsFolder);
        return folder.mkdirs();
    }

    private void pullScreenshots(String appId, ShotFolder shotFolder, boolean orchestrated) {
        this.forEachDevice((Function1 & Serializable)device -> {
            Shot.$anonfun$pullScreenshots$1(this, shotFolder, appId, orchestrated, device);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<Screenshot>> readScreenshotsMetadata(ShotFolder shotFolder) {
        String screenshotsFolder = shotFolder.pulledScreenshotsFolder();
        File folder = new File(screenshotsFolder);
        if (folder.exists()) {
            File[] filesInScreenshotFolder = folder.listFiles();
            File[] metadataFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])filesInScreenshotFolder), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$readScreenshotsMetadata$1(file)));
            Screenshot[] screenshotSuite = (Screenshot[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)metadataFilePath -> {
                String metadataFileContent = $this.files.read(metadataFilePath.getAbsolutePath());
                return ScreenshotsSuiteJsonParser$.MODULE$.parseScreenshots(metadataFileContent, shotFolder.screenshotsFolder(), shotFolder.pulledScreenshotsFolder(), shotFolder.screenshotsTemporalBuildPath());
            }, ClassTag$.MODULE$.apply(Screenshot.class));
            List suite = CollectionConverters.ArrayIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.ArrayIsParallelizable((Object)screenshotSuite)).map((Function1 & Serializable)screenshot -> {
                String viewHierarchyFileName = new StringBuilder(0).append(shotFolder.pulledScreenshotsFolder()).append(screenshot.viewHierarchy()).toString();
                String viewHierarchyContent = $this.files.read(viewHierarchyFileName);
                return ScreenshotsSuiteJsonParser$.MODULE$.parseScreenshotSize((Screenshot)screenshot, viewHierarchyContent);
            }).toList();
            return new Some((Object)suite);
        }
        return None$.MODULE$;
    }

    private Option<Seq<Screenshot>> readComposeScreenshotsMetadata(ShotFolder shotFolder) {
        String screenshotsFolder = shotFolder.pulledScreenshotsFolder();
        File folder = new File(screenshotsFolder);
        if (folder.exists()) {
            File[] filesInScreenshotFolder = folder.listFiles();
            File[] metadataFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])filesInScreenshotFolder), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$readComposeScreenshotsMetadata$1(shotFolder, file)));
            Screenshot[] screenshotSuite = (Screenshot[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)metadataFilePath -> {
                String metadataFileContent = $this.files.read(metadataFilePath.getAbsolutePath());
                return ScreenshotsComposeSuiteJsonParser$.MODULE$.parseScreenshotSuite(metadataFileContent, shotFolder.screenshotsFolder(), shotFolder.pulledScreenshotsFolder(), shotFolder.screenshotsTemporalBuildPath());
            }, ClassTag$.MODULE$.apply(Screenshot.class));
            List suite = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])screenshotSuite), (Function1 & Serializable)screenshot -> {
                Dimension dimension;
                Dimension x$1 = dimension = $this.screenshotsSaver.getScreenshotDimension(shotFolder, (Screenshot)screenshot);
                String x$2 = screenshot.copy$default$1();
                String x$3 = screenshot.copy$default$2();
                String x$4 = screenshot.copy$default$3();
                String x$5 = screenshot.copy$default$4();
                String x$6 = screenshot.copy$default$5();
                Dimension x$7 = screenshot.copy$default$6();
                String x$8 = screenshot.copy$default$7();
                Seq<String> x$9 = screenshot.copy$default$8();
                Seq<String> x$10 = screenshot.copy$default$9();
                Seq<String> x$11 = screenshot.copy$default$10();
                return screenshot.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1);
            }, ClassTag$.MODULE$.apply(Screenshot.class))).toList();
            return new Some((Object)suite);
        }
        return None$.MODULE$;
    }

    private void removeProjectTemporalScreenshotsFolder(ShotFolder shotFolder) {
        this.safeDeleteDirectory(new File(shotFolder.pulledScreenshotsFolder()));
        this.safeDeleteDirectory(new File(shotFolder.pulledComposeScreenshotsFolder()));
        this.safeDeleteDirectory(new File(shotFolder.pulledComposeOrchestratedScreenshotsFolder()));
    }

    private void extractPicturesFromBundle(String screenshotsFolder) {
        String bundleFile = new StringBuilder(21).append(screenshotsFolder).append("screenshot_bundle.zip").toString();
        if (java.nio.file.Files.exists(Paths.get(bundleFile, new String[0]), new LinkOption[0])) {
            TinyZip.unzip((String)bundleFile, (String)screenshotsFolder);
            return;
        }
    }

    private void safeDeleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("\u001b[33m").append("Failed to delete directory: ").append(e).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$pullScreenshots$2(ShotFolder shotFolder$6, File file) {
        return file.getAbsolutePath().contains(shotFolder$6.metadataFileName());
    }

    public static final /* synthetic */ void $anonfun$pullScreenshots$3(Shot $this, ShotFolder shotFolder$6, String device$1, File file) {
        String filePath = new StringBuilder(0).append(shotFolder$6.pulledScreenshotsFolder()).append(file.getName()).toString();
        $this.files.rename(filePath, new StringBuilder(1).append(filePath).append("_").append(device$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$pullScreenshots$4(ShotFolder shotFolder$6, File file) {
        return file.getAbsolutePath().contains(shotFolder$6.composeMetadataFileName());
    }

    public static final /* synthetic */ void $anonfun$pullScreenshots$5(Shot $this, ShotFolder shotFolder$6, String device$1, File file) {
        String filePath = new StringBuilder(0).append(shotFolder$6.pulledComposeOrchestratedScreenshotsFolder()).append(file.getName()).toString();
        $this.files.rename(filePath, new StringBuilder(1).append(filePath).append("_").append(device$1).toString());
    }

    public static final /* synthetic */ void $anonfun$pullScreenshots$1(Shot $this, ShotFolder shotFolder$6, String appId$4, boolean orchestrated$2, String device) {
        String screenshotsFolder = shotFolder$6.screenshotsFolder();
        $this.createScreenshotsFolderIfDoesNotExist(screenshotsFolder);
        $this.adb.pullScreenshots(device, screenshotsFolder, appId$4, orchestrated$2);
        $this.extractPicturesFromBundle(shotFolder$6.pulledScreenshotsFolder());
        ((IterableOnceOps)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable($this.files.listFilesInFolder(shotFolder$6.pulledScreenshotsFolder())).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$pullScreenshots$2(shotFolder$6, file)))).foreach((Function1 & Serializable)file -> {
            Shot.$anonfun$pullScreenshots$3($this, shotFolder$6, device, file);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable($this.files.listFilesInFolder(shotFolder$6.pulledComposeOrchestratedScreenshotsFolder())).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Shot.$anonfun$pullScreenshots$4(shotFolder$6, file)))).foreach((Function1 & Serializable)file -> {
            Shot.$anonfun$pullScreenshots$5($this, shotFolder$6, device, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$readScreenshotsMetadata$1(File file) {
        return file.getAbsolutePath().contains("metadata.json");
    }

    public static final /* synthetic */ boolean $anonfun$readComposeScreenshotsMetadata$1(ShotFolder shotFolder$8, File file) {
        return file.getAbsolutePath().contains(shotFolder$8.composeMetadataFileName());
    }

    public Shot(Adb adb, Files files, ScreenshotsComparator screenshotsComparator, ScreenshotsDiffGenerator screenshotsDiffGenerator, ScreenshotsSaver screenshotsSaver, Console console, List<ExecutionReporter> reporters, ConsoleReporter consoleReporter, EnvVars envVars) {
        this.adb = adb;
        this.files = files;
        this.screenshotsComparator = screenshotsComparator;
        this.screenshotsDiffGenerator = screenshotsDiffGenerator;
        this.screenshotsSaver = screenshotsSaver;
        this.console = console;
        this.reporters = reporters;
        this.consoleReporter = consoleReporter;
        this.envVars = envVars;
    }
}

