/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisonError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.templates.RecordIndexTemplate$;
import com.karumi.shot.templates.VerificationIndexTemplate$;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\b\u0011\u0001eAQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005\u0002!BQ!\u0014\u0001\u0005\n9CQa\u0017\u0001\u0005\nqCQ!\u0019\u0001\u0005\n\tDQ!\u001a\u0001\u0005\n\u0019DQ\u0001\u001b\u0001\u0005\u0002%DqA\u001e\u0001\u0012\u0002\u0013\u0005q\u000fC\u0004\u0002\u0006\u0001!I!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t\t\u0007\u0001C\u0005\u0003G\u0012Q\u0003\u0013;nY\u0016CXmY;uS>t'+\u001a9peR,'O\u0003\u0002\u0012%\u00059!/\u001a9peR\u001c(BA\n\u0015\u0003\u0011\u0019\bn\u001c;\u000b\u0005U1\u0012AB6beVl\u0017NC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\t\n\u0005\r\u0002\"!E#yK\u000e,H/[8o%\u0016\u0004xN\u001d;fe\u00061A(\u001b8jiz\"\u0012A\n\t\u0003C\u0001\tAcZ3oKJ\fG/\u001a*fG>\u0014HMU3q_J$H\u0003B\u0015-\u0005\u001e\u0003\"a\u0007\u0016\n\u0005-b\"\u0001B+oSRDQ!\f\u0002A\u00029\nQ!\u00199q\u0013\u0012\u0004\"aL \u000f\u0005AbdBA\u0019;\u001d\t\u0011\u0014H\u0004\u00024q9\u0011AgN\u0007\u0002k)\u0011a\u0007G\u0001\u0007yI|w\u000e\u001e \n\u0003]I!!\u0006\f\n\u0005M!\u0012BA\u001e\u0013\u0003\u0019!w.\\1j]&\u0011QHP\u0001\u0006[>$W\r\u001c\u0006\u0003wII!\u0001Q!\u0003\u000b\u0005\u0003\b/\u00133\u000b\u0005ur\u0004\"B\"\u0003\u0001\u0004!\u0015aC:de\u0016,gn\u001d5piN\u0004\"aL#\n\u0005\u0019\u000b%\u0001E*de\u0016,gn\u001d5piN\u001cV/\u001b;f\u0011\u0015A%\u00011\u0001J\u0003)\u0019\bn\u001c;G_2$WM\u001d\t\u0003\u0015.k\u0011AP\u0005\u0003\u0019z\u0012!b\u00155pi\u001a{G\u000eZ3s\u0003-9(/\u001b;f%\u0016\u0004xN\u001d;\u0015\u0007%z\u0015\fC\u0003Q\u0007\u0001\u0007\u0011+\u0001\u0007gS2,7i\u001c8uK:$8\u000f\u0005\u0002S-:\u00111\u000b\u0016\t\u0003iqI!!\u0016\u000f\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+rAQAW\u0002A\u0002E\u000bAB]3q_J$hi\u001c7eKJ\fqC]3tKR4VM]5gS\u000e\fG/[8o%\u0016\u0004xN\u001d;\u0015\u0005u\u0003\u0007CA\u000e_\u0013\tyFD\u0001\u0004B]f4\u0016\r\u001c\u0005\u0006\u0011\u0012\u0001\r!S\u0001\u0017a>\u0004X\u000f\\1uKJ+7m\u001c:e)\u0016l\u0007\u000f\\1uKR\u0019\u0011k\u00193\t\u000b5*\u0001\u0019\u0001\u0018\t\u000b\r+\u0001\u0019\u0001#\u0002=\u001d,g.\u001a:bi\u0016\u0014VmY8sIN+X.\\1ssR\u000b'\r\\3C_\u0012LHCA)h\u0011\u0015\u0019e\u00011\u0001E\u0003i9WM\\3sCR,g+\u001a:jM&\u001c\u0017\r^5p]J+\u0007o\u001c:u)\u0015I#n\u001b9r\u0011\u0015is\u00011\u0001/\u0011\u0015aw\u00011\u0001n\u0003-\u0019w.\u001c9be&\u001c\u0018n\u001c8\u0011\u0005)s\u0017BA8?\u0005q\u00196M]3f]NDw\u000e^:D_6\u0004\u0018M]5tS>t'+Z:vYRDQ\u0001S\u0004A\u0002%CqA]\u0004\u0011\u0002\u0003\u00071/A\u000ftQ><xJ\u001c7z\r\u0006LG.\u001b8h)\u0016\u001cHo]%o%\u0016\u0004xN\u001d;t!\tYB/\u0003\u0002v9\t9!i\\8mK\u0006t\u0017\u0001J4f]\u0016\u0014\u0018\r^3WKJLg-[2bi&|gNU3q_J$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003aT#a]=,\u0003i\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003%)hn\u00195fG.,GM\u0003\u0002\u00009\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\rAPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0004]8qk2\fG/\u001a,fe&4\u0017nY1uS>tG+Z7qY\u0006$X\rF\u0004R\u0003\u0013\tY!!\u0004\t\u000b5J\u0001\u0019\u0001\u0018\t\u000b1L\u0001\u0019A7\t\u000bIL\u0001\u0019A:\u00029\u001d,GoU8si\u0016$')\u001f*fgVdGoU2sK\u0016t7\u000f[8ugR!\u00111CA\u001e!\u0019\t)\"a\b\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005j[6,H/\u00192mK*\u0019\u0011Q\u0004\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005]!aA*fcB91$!\n\u0002*\u0005=\u0012bAA\u00149\t1A+\u001e9mKJ\u00022ASA\u0016\u0013\r\tiC\u0010\u0002\u000b'\u000e\u0014X-\u001a8tQ>$\b#B\u000e\u00022\u0005U\u0012bAA\u001a9\t1q\n\u001d;j_:\u00042ASA\u001c\u0013\r\tID\u0010\u0002\u001a'\u000e\u0014X-\u001a8tQ>$8i\\7qCJL7o\u001c8FeJ|'\u000f\u0003\u0004\u0002>)\u0001\r!\\\u0001\u000bG>l\u0007/\u0019:jg>t\u0017\u0001J4f]\u0016\u0014\u0018\r^3WKJLg-[2bi&|gnU;n[\u0006\u0014\u0018\u0010V1cY\u0016\u0014u\u000eZ=\u0015\u000bE\u000b\u0019%!\u0012\t\u000b1\\\u0001\u0019A7\t\u000bI\\\u0001\u0019A:\u00029\u001d,g.\u001a:bi\u0016\u001c6M]3f]NDw\u000e^:UC\ndWMQ8esR)\u0011+a\u0013\u0002N!)A\u000e\u0004a\u0001[\")!\u000f\u0004a\u0001g\u0006Ia-\u001b8e\u000bJ\u0014xN\u001d\u000b\u0007\u0003_\t\u0019&a\u0016\t\u000f\u0005US\u00021\u0001\u0002*\u0005Q1o\u0019:fK:\u001c\bn\u001c;\t\u000f\u0005eS\u00021\u0001\u0002\\\u00051QM\u001d:peN\u00042aLA/\u0013\r\ty&\u0011\u0002\u001c'\u000e\u0014X-\u001a8tQ>$8i\\7qCJL7/[8o\u000bJ\u0014xN]:\u0002+\u001d,g.\u001a:bi\u0016\u0014V-Y:p]6+7o]1hKR\u0019\u0011+!\u001a\t\u000f\u0005\u001dd\u00021\u0001\u00020\u0005)QM\u001d:pe\u0002")
public class HtmlExecutionReporter
implements ExecutionReporter {
    @Override
    public void generateRecordReport(String appId, Seq<Screenshot> screenshots, ShotFolder shotFolder) {
        String reportFileContents = this.populateRecordTemplate(appId, screenshots);
        this.resetVerificationReport(shotFolder);
        String reportFolder = shotFolder.recordingReportFolder();
        this.writeReport(reportFileContents, reportFolder);
    }

    private void writeReport(String fileContents, String reportFolder) {
        File indexFile = new File(new StringBuilder(10).append(reportFolder).append("index.html").toString());
        new File(reportFolder).mkdirs();
        FileWriter writer = new FileWriter(indexFile);
        writer.write(fileContents);
        writer.close();
    }

    private Object resetVerificationReport(ShotFolder shotFolder) {
        File file = new File(new StringBuilder(10).append(shotFolder.reportFolder()).append("index.html").toString());
        if (file.exists()) {
            return BoxesRunTime.boxToBoolean((boolean)file.delete());
        }
        return BoxedUnit.UNIT;
    }

    private String populateRecordTemplate(String appId, Seq<Screenshot> screenshots) {
        String title = new StringBuilder(16).append("Record results: ").append(appId).toString();
        int numberOfTests = screenshots.size();
        String summaryResults = new StringBuilder(27).append(numberOfTests).append(" screenshot tests recorded.").toString();
        String summaryTableBody = this.generateRecordSummaryTableBody(screenshots);
        return RecordIndexTemplate$.MODULE$.recordIndexTemplate(title, summaryResults, summaryTableBody);
    }

    private String generateRecordSummaryTableBody(Seq<Screenshot> screenshots) {
        return ((IterableOnceOps)screenshots.map((Function1 & Serializable)screenshot -> {
            String testClass = screenshot.testClass();
            String testName = screenshot.testName();
            String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
            int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
            String screenshotName = screenshot.name();
            return new StringBuilder(127).append("<tr>").append("<th> <p>Test class: ").append(testClass).append("</p>").append("<p>Test name: ").append(testName).append("</p>").append("<p>Screenshot name: ").append(screenshotName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("</tr>").toString();
        })).mkString("\n");
    }

    @Override
    public void generateVerificationReport(String appId, ScreenshotsComparisionResult comparision, ShotFolder shotFolder, boolean showOnlyFailingTestsInReports) {
        String reportFileContents = this.populateVerificationTemplate(appId, comparision, showOnlyFailingTestsInReports);
        this.resetVerificationReport(shotFolder);
        String reportFolder = shotFolder.verificationReportFolder();
        this.writeReport(reportFileContents, reportFolder);
    }

    @Override
    public boolean generateVerificationReport$default$4() {
        return false;
    }

    private String populateVerificationTemplate(String appId, ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        String title = new StringBuilder(22).append("Verification results: ").append(appId).toString();
        Seq<Screenshot> screenshots = comparision.screenshots();
        int numberOfTests = screenshots.size();
        int failedNumber = comparision.errors().size();
        int successNumber = numberOfTests - failedNumber;
        String summaryResults = new StringBuilder(48).append(numberOfTests).append(" screenshot tests executed. ").append(successNumber).append(" passed and ").append(failedNumber).append(" failed.").toString();
        String summaryTableBody = this.generateVerificationSummaryTableBody(comparision, showOnlyFailingTestsInReports);
        String screenshotsTableBody = this.generateScreenshotsTableBody(comparision, showOnlyFailingTestsInReports);
        return VerificationIndexTemplate$.MODULE$.verificationIndexTemplate(title, summaryResults, summaryTableBody, screenshotsTableBody);
    }

    private Seq<Tuple2<Screenshot, Option<ScreenshotComparisonError>>> getSortedByResultScreenshots(ScreenshotsComparisionResult comparison) {
        return (Seq)((SeqOps)comparison.screenshots().map((Function1 & Serializable)screenshot -> {
            Option<ScreenshotComparisonError> error = this.findError((Screenshot)screenshot, comparison.errors());
            return new Tuple2(screenshot, error);
        })).sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HtmlExecutionReporter.$anonfun$getSortedByResultScreenshots$2(x$1)), (Ordering)Ordering.Boolean$.MODULE$);
    }

    private String generateVerificationSummaryTableBody(ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        return ((IterableOnceOps)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Screenshot screenshot = (Screenshot)tuple2._1();
                Option error = (Option)tuple2._2();
                boolean isFailedTest = error.isDefined();
                String testClass = screenshot.testClass();
                String testName = screenshot.testName();
                String result = isFailedTest ? "\u274c" : "\u2705";
                String reason = this.generateReasonMessage((Option<ScreenshotComparisonError>)error);
                String color = isFailedTest ? "red-text" : "green-text";
                String id = screenshot.name().replace(".", "");
                String screenshotName = screenshot.name();
                if (showOnlyFailingTestsInReports && isFailedTest || !showOnlyFailingTestsInReports) {
                    return new StringBuilder(161).append("<tr>").append("<th><a href='#").append(id).append("'>").append(result).append("</a></th>").append("<th><a href='#").append(id).append("'><p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p></a></th>").append("<p class='").append(color).append("'>Screenshot name: ").append(screenshotName).append("</p></th>").append("<th>").append(reason).append("</th>").append("</tr>").toString();
                }
                return "";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
    }

    private String generateScreenshotsTableBody(ScreenshotsComparisionResult comparision, boolean showOnlyFailingTestsInReports) {
        return ((IterableOnceOps)this.getSortedByResultScreenshots(comparision).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Screenshot screenshot = (Screenshot)tuple2._1();
                Option error = (Option)tuple2._2();
                boolean isFailedTest = error.isDefined();
                String testClass = screenshot.testClass();
                String testName = screenshot.testName();
                String originalScreenshot = new StringBuilder(22).append("./images/recorded/").append(screenshot.name()).append(".png").toString();
                String newScreenshot = new StringBuilder(13).append("./images/").append(screenshot.name()).append(".png").toString();
                String diff = error.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HtmlExecutionReporter.$anonfun$generateScreenshotsTableBody$2(x$2))) ? screenshot.getDiffScreenshotPath("./images/") : "";
                String color = isFailedTest ? "red-text" : "green-text";
                int width = (int)((double)screenshot.screenshotDimension().width() * 0.2);
                String id = screenshot.name().replace(".", "");
                String screenshotName = screenshot.name();
                if (showOnlyFailingTestsInReports && isFailedTest || !showOnlyFailingTestsInReports) {
                    return new StringBuilder(254).append("<tr>").append("<th id='").append(id).append("'> <p class='").append(color).append("'>Test class: ").append(testClass).append("</p>").append("<p class='").append(color).append("'>Test name: ").append(testName).append("</p>").append("<p class='").append(color).append("'>Screenshot name: ").append(screenshotName).append("</p></th>").append("<th> <a href='").append(originalScreenshot).append("'><img width='").append(width).append("' src='").append(originalScreenshot).append("'/></a></th>").append("<th> <a href='").append(newScreenshot).append("'><img width='").append(width).append("' src='").append(newScreenshot).append("'/></a></th>").append("<th> <a href='").append(diff).append("'><img width='").append(width).append("' src='").append(diff).append("'/></a></th>").append("</tr>").toString();
                }
                return "";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
    }

    private Option<ScreenshotComparisonError> findError(Screenshot screenshot, Seq<ScreenshotComparisonError> errors) {
        return errors.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HtmlExecutionReporter.$anonfun$findError$1(screenshot, x0$1)));
    }

    private String generateReasonMessage(Option<ScreenshotComparisonError> error) {
        return (String)error.map((Function1 & Serializable)x0$1 -> {
            ScreenshotComparisonError screenshotComparisonError = x0$1;
            if (screenshotComparisonError instanceof ScreenshotNotFound) {
                return "<p class='red-text'>\ud83d\udd0e  Recorded screenshot not found.</p>";
            }
            if (screenshotComparisonError instanceof DifferentScreenshots) {
                return "<p class='red-text'>\ud83e\udd14  The application UI has been modified.</p>";
            }
            if (screenshotComparisonError instanceof DifferentImageDimensions) {
                return "<p class='red-text'>\ud83d\udcf1  The size of the screenshot taken has changed.</p>";
            }
            return "<p class='red-text'>\ud83d\ude1e  Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.</p>";
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$getSortedByResultScreenshots$2(Tuple2 x$1) {
        return ((Option)x$1._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateScreenshotsTableBody$2(ScreenshotComparisonError x$2) {
        return x$2 instanceof DifferentScreenshots;
    }

    public static final /* synthetic */ boolean $anonfun$findError$1(Screenshot screenshot$1, ScreenshotComparisonError x0$1) {
        ScreenshotComparisonError screenshotComparisonError = x0$1;
        if (screenshotComparisonError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisonError;
            Screenshot error = screenshotNotFound.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot2 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot2) : screenshot2 != null);
        }
        if (screenshotComparisonError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisonError;
            Screenshot error = differentImageDimensions.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot3 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot3) : screenshot3 != null);
        }
        if (screenshotComparisonError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisonError;
            Screenshot error = differentScreenshots.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot4 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot4) : screenshot4 != null);
        }
        return false;
    }
}

