/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.reports;

import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisonError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.reports.ExecutionReporter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\u0007\u000e\u0001YAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005\u0002\u0015BQA\u0013\u0001\u0005\u0002-Cq\u0001\u0017\u0001\u0012\u0002\u0013\u0005\u0011\fC\u0003e\u0001\u0011%Q\rC\u0003s\u0001\u0011%1\u000fC\u0003y\u0001\u0011%\u0011\u0010C\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\u0006\u0001!I!a\u0002\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\"A\u0006&v]&$X\t_3dkRLwN\u001c*fa>\u0014H/\u001a:\u000b\u00059y\u0011a\u0002:fa>\u0014Ho\u001d\u0006\u0003!E\tAa\u001d5pi*\u0011!cE\u0001\u0007W\u0006\u0014X/\\5\u000b\u0003Q\t1aY8n\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u001b%\u0011\u0001%\u0004\u0002\u0012\u000bb,7-\u001e;j_:\u0014V\r]8si\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001$!\tq\u0002!\u0001\u000bhK:,'/\u0019;f%\u0016\u001cwN\u001d3SKB|'\u000f\u001e\u000b\u0005M%zD\t\u0005\u0002\u0019O%\u0011\u0001&\u0007\u0002\u0005+:LG\u000fC\u0003+\u0005\u0001\u00071&A\u0003baBLE\r\u0005\u0002-y9\u0011Q&\u000f\b\u0003]]r!a\f\u001c\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a\u0016\u0003\u0019a$o\\8u}%\tA#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003q=\ta\u0001Z8nC&t\u0017B\u0001\u001e<\u0003\u0015iw\u000eZ3m\u0015\tAt\"\u0003\u0002>}\t)\u0011\t\u001d9JI*\u0011!h\u000f\u0005\u0006\u0001\n\u0001\r!Q\u0001\fg\u000e\u0014X-\u001a8tQ>$8\u000f\u0005\u0002-\u0005&\u00111I\u0010\u0002\u0011'\u000e\u0014X-\u001a8tQ>$8oU;ji\u0016DQ!\u0012\u0002A\u0002\u0019\u000b!b\u001d5pi\u001a{G\u000eZ3s!\t9\u0005*D\u0001<\u0013\tI5H\u0001\u0006TQ>$hi\u001c7eKJ\f!dZ3oKJ\fG/\u001a,fe&4\u0017nY1uS>t'+\u001a9peR$RA\n'N%NCQAK\u0002A\u0002-BQAT\u0002A\u0002=\u000b1bY8na\u0006\u0014\u0018n]5p]B\u0011q\tU\u0005\u0003#n\u0012AdU2sK\u0016t7\u000f[8ug\u000e{W\u000e]1sSNLwN\u001c*fgVdG\u000fC\u0003F\u0007\u0001\u0007a\tC\u0004U\u0007A\u0005\t\u0019A+\u0002;MDwn^(oYf4\u0015-\u001b7j]\u001e$Vm\u001d;t\u0013:\u0014V\r]8siN\u0004\"\u0001\u0007,\n\u0005]K\"a\u0002\"p_2,\u0017M\\\u0001%O\u0016tWM]1uKZ+'/\u001b4jG\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\t!L\u000b\u0002V7.\nA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Cf\t!\"\u00198o_R\fG/[8o\u0013\t\u0019gLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1b\u001e:ji\u0016\u0014V\r]8siR\u0019aE\u001a9\t\u000b\u001d,\u0001\u0019\u00015\u0002\u0019\u0019LG.Z\"p]R,g\u000e^:\u0011\u0005%lgB\u00016l!\t\t\u0014$\u0003\u0002m3\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta\u0017\u0004C\u0003r\u000b\u0001\u0007\u0001.\u0001\u0007sKB|'\u000f\u001e$pY\u0012,'/A\fsKN,GOV3sS\u001aL7-\u0019;j_:\u0014V\r]8siR\u0011Ao\u001e\t\u00031UL!A^\r\u0003\r\u0005s\u0017PV1m\u0011\u0015)e\u00011\u0001G\u0003q\u0001x\u000e];mCR,g+\u001a:jM&\u001c\u0017\r^5p]R+W\u000e\u001d7bi\u0016$2\u0001\u001b>|\u0011\u0015Qs\u00011\u0001,\u0011\u0015qu\u00011\u0001P\u0003\u0019\u0011X\r]8siR!\u0001N`A\u0001\u0011\u0015y\b\u00021\u0001i\u0003\u0015!\u0018\u000e\u001e7f\u0011\u0019\t\u0019\u0001\u0003a\u0001Q\u0006YA/Z:u%\u0016\u001cX\u000f\u001c;t\u0003\u0011:WM\\3sCR,g+\u001a:jM&\u001c\u0017\r^5p]N+X.\\1ssR\u000b'\r\\3C_\u0012LHc\u00015\u0002\n!1\u00111B\u0005A\u0002=\u000b\u0011cY8na\u0006\u0014\u0018n]5p]J+7/\u001e7u\u0003%1\u0017N\u001c3FeJ|'\u000f\u0006\u0004\u0002\u0012\u0005u\u0011q\u0005\t\u00061\u0005M\u0011qC\u0005\u0004\u0003+I\"AB(qi&|g\u000eE\u0002H\u00033I1!a\u0007<\u0005e\u00196M]3f]NDw\u000e^\"p[B\f'/[:p]\u0016\u0013(o\u001c:\t\u000f\u0005}!\u00021\u0001\u0002\"\u0005Q1o\u0019:fK:\u001c\bn\u001c;\u0011\u0007\u001d\u000b\u0019#C\u0002\u0002&m\u0012!bU2sK\u0016t7\u000f[8u\u0011\u001d\tIC\u0003a\u0001\u0003W\ta!\u001a:s_J\u001c\bc\u0001\u0017\u0002.%\u0019\u0011q\u0006 \u00037M\u001b'/Z3og\"|GoQ8na\u0006\u0014\u0018n]5p]\u0016\u0013(o\u001c:t\u0003U9WM\\3sCR,'+Z1t_:lUm]:bO\u0016$2\u0001[A\u001b\u0011\u001d\t9d\u0003a\u0001\u0003#\tQ!\u001a:s_J\u0004")
public class JunitExecutionReporter
implements ExecutionReporter {
    @Override
    public void generateRecordReport(String appId, Seq<Screenshot> screenshots, ShotFolder shotFolder) {
    }

    @Override
    public void generateVerificationReport(String appId, ScreenshotsComparisionResult comparision, ShotFolder shotFolder, boolean showOnlyFailingTestsInReports) {
        String reportFileContents = this.populateVerificationTemplate(appId, comparision);
        this.resetVerificationReport(shotFolder);
        String reportFolder = shotFolder.verificationReportFolder();
        this.writeReport(reportFileContents, reportFolder);
    }

    @Override
    public boolean generateVerificationReport$default$4() {
        return false;
    }

    private void writeReport(String fileContents, String reportFolder) {
        File indexFile = new File(new StringBuilder(13).append(reportFolder).append("TEST-Shot.xml").toString());
        new File(reportFolder).mkdirs();
        FileWriter writer = new FileWriter(indexFile);
        writer.write(fileContents);
        writer.close();
    }

    private Object resetVerificationReport(ShotFolder shotFolder) {
        File file = new File(new StringBuilder(13).append(shotFolder.reportFolder()).append("TEST-Shot.xml").toString());
        if (file.exists()) {
            return BoxesRunTime.boxToBoolean((boolean)file.delete());
        }
        return BoxedUnit.UNIT;
    }

    private String populateVerificationTemplate(String appId, ScreenshotsComparisionResult comparision) {
        String title = new StringBuilder(20).append("Screenshot results: ").append(appId).toString();
        String summaryTableBody = this.generateVerificationSummaryTableBody(comparision);
        return this.report(title, summaryTableBody);
    }

    private String report(String title, String testResults) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n        |<testsuites name=\"").append(title).append("\">\n        |  ").append(testResults).append("\n        |</testsuites>").toString()));
    }

    private String generateVerificationSummaryTableBody(ScreenshotsComparisionResult comparisionResult) {
        Map groupedScreenshots = comparisionResult.screenshots().groupBy((Function1 & Serializable)screenshot -> screenshot.testClass());
        return ((IterableOnceOps)groupedScreenshots.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String testSuite = (String)tuple2._1();
                Seq screenshots = (Seq)tuple2._2();
                if (testSuite != null) {
                    String string = testSuite;
                    if (screenshots != null) {
                        Seq seq = screenshots;
                        String tests = ((IterableOnceOps)seq.map((Function1 & Serializable)screenshot -> {
                            Option<ScreenshotComparisonError> error = this.findError((Screenshot)screenshot, comparisionResult.errors());
                            boolean isFailedTest = error.isDefined();
                            String testClass = screenshot.testClass();
                            String testName = screenshot.fileName();
                            String reason = this.generateReasonMessage(error);
                            String failureString = isFailedTest ? new StringBuilder(22).append("<failure message=\"").append(reason).append("\" />").toString() : "";
                            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(82).append("<testcase name=\"").append(testName).append("\" classname=\"").append(testClass).append("\">\n                 |  ").append(failureString).append("\n                 |</testcase>").toString()));
                        })).mkString("\n");
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(72).append("<testsuite name=\"").append(string).append("\">\n           |  ").append(tests).append("\n           |</testsuite>\n           |").toString()));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
    }

    private Option<ScreenshotComparisonError> findError(Screenshot screenshot, Seq<ScreenshotComparisonError> errors) {
        return errors.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JunitExecutionReporter.$anonfun$findError$1(screenshot, x0$1)));
    }

    private String generateReasonMessage(Option<ScreenshotComparisonError> error) {
        return (String)error.map((Function1 & Serializable)x0$1 -> {
            ScreenshotComparisonError screenshotComparisonError = x0$1;
            if (screenshotComparisonError instanceof ScreenshotNotFound) {
                return "Recorded screenshot not found.";
            }
            if (screenshotComparisonError instanceof DifferentScreenshots) {
                return "The application UI has been modified.";
            }
            if (screenshotComparisonError instanceof DifferentImageDimensions) {
                return "The size of the screenshot taken has changed.";
            }
            return "Ups! Something went wrong while comparing your screenshots but we couldn't identify the cause. If you think you've found a bug, please open an issue at https://github.com/karumi/shot.";
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$findError$1(Screenshot screenshot$1, ScreenshotComparisonError x0$1) {
        ScreenshotComparisonError screenshotComparisonError = x0$1;
        if (screenshotComparisonError instanceof ScreenshotNotFound) {
            ScreenshotNotFound screenshotNotFound = (ScreenshotNotFound)screenshotComparisonError;
            Screenshot error = screenshotNotFound.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot2 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot2) : screenshot2 != null);
        }
        if (screenshotComparisonError instanceof DifferentImageDimensions) {
            DifferentImageDimensions differentImageDimensions = (DifferentImageDimensions)screenshotComparisonError;
            Screenshot error = differentImageDimensions.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot3 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot3) : screenshot3 != null);
        }
        if (screenshotComparisonError instanceof DifferentScreenshots) {
            DifferentScreenshots differentScreenshots = (DifferentScreenshots)screenshotComparisonError;
            Screenshot error = differentScreenshots.screenshot();
            Screenshot screenshot = screenshot$1;
            Screenshot screenshot4 = error;
            return !(screenshot != null ? !((Object)screenshot).equals(screenshot4) : screenshot4 != null);
        }
        return false;
    }
}

