/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.screenshots;

import com.karumi.shot.domain.Config$;
import com.karumi.shot.domain.DifferentImageDimensions;
import com.karumi.shot.domain.DifferentScreenshots;
import com.karumi.shot.domain.DifferentScreenshots$;
import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotComparisonError;
import com.karumi.shot.domain.ScreenshotNotFound;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.screenshots.ScreenshotComposer$;
import com.sksamuel.scrimage.ImmutableImage;
import com.sksamuel.scrimage.pixels.Pixel;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00054AAB\u0004\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\b\u0001C\u0005y!)\u0011\n\u0001C\u0005\u0015\")A\f\u0001C\u0005;\n)2k\u0019:fK:\u001c\bn\u001c;t\u0007>l\u0007/\u0019:bi>\u0014(B\u0001\u0005\n\u0003-\u00198M]3f]NDw\u000e^:\u000b\u0005)Y\u0011\u0001B:i_RT!\u0001D\u0007\u0002\r-\f'/^7j\u0015\u0005q\u0011aA2p[\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\bG>l\u0007/\u0019:f)\ri2E\u000e\t\u0003=\u0005j\u0011a\b\u0006\u0003A%\ta\u0001Z8nC&t\u0017B\u0001\u0012 \u0005q\u00196M]3f]NDw\u000e^:D_6\u0004\u0018M]5tS>t'+Z:vYRDQ\u0001\u0003\u0002A\u0002\u0011\u0002\"!J\u001a\u000f\u0005\u0019\ndBA\u00141\u001d\tAsF\u0004\u0002*]9\u0011!&L\u0007\u0002W)\u0011AfD\u0001\u0007yI|w\u000e\u001e \n\u00039I!\u0001D\u0007\n\u0005)Y\u0011B\u0001\u0011\n\u0013\t\u0011t$A\u0003n_\u0012,G.\u0003\u00025k\t\u00012k\u0019:fK:\u001c\bn\u001c;t'VLG/\u001a\u0006\u0003e}AQa\u000e\u0002A\u0002a\n\u0011\u0002^8mKJ\fgnY3\u0011\u0005II\u0014B\u0001\u001e\u0014\u0005\u0019!u.\u001e2mK\u0006\t2m\\7qCJ,7k\u0019:fK:\u001c\bn\u001c;\u0015\u0007u\u001a\u0005\nE\u0002\u0013}\u0001K!aP\n\u0003\r=\u0003H/[8o!\tq\u0012)\u0003\u0002C?\tI2k\u0019:fK:\u001c\bn\u001c;D_6\u0004\u0018M]5t_:,%O]8s\u0011\u0015!5\u00011\u0001F\u0003)\u00198M]3f]NDw\u000e\u001e\t\u0003=\u0019K!aR\u0010\u0003\u0015M\u001b'/Z3og\"|G\u000fC\u00038\u0007\u0001\u0007\u0001(\u0001\nj[\u0006<Wm]!sK\u0012KgMZ3sK:$H#B&O\u001ff[\u0006C\u0001\nM\u0013\ti5CA\u0004C_>dW-\u00198\t\u000b\u0011#\u0001\u0019A#\t\u000bA#\u0001\u0019A)\u0002\u001b=dGmU2sK\u0016t7\u000f[8u!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0005tGJLW.Y4f\u0015\t1V\"\u0001\u0005tWN\fW.^3m\u0013\tA6K\u0001\bJ[6,H/\u00192mK&k\u0017mZ3\t\u000bi#\u0001\u0019A)\u0002\u001b9,woU2sK\u0016t7\u000f[8u\u0011\u00159D\u00011\u00019\u0003IA\u0017M^3TC6,G)[7f]NLwN\\:\u0015\u0007-sv\fC\u0003[\u000b\u0001\u0007\u0011\u000bC\u0003a\u000b\u0001\u0007\u0011+\u0001\nsK\u000e|'\u000fZ3e'\u000e\u0014X-\u001a8tQ>$\b")
public class ScreenshotsComparator {
    public ScreenshotsComparisionResult compare(Seq<Screenshot> screenshots, double tolerance) {
        List errors = CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.ImmutableSeqIsParallelizable(screenshots)).flatMap((Function1 & Serializable)x$1 -> this.compareScreenshot((Screenshot)x$1, tolerance)).toList();
        return new ScreenshotsComparisionResult((Seq<ScreenshotComparisonError>)errors, screenshots);
    }

    private Option<ScreenshotComparisonError> compareScreenshot(Screenshot screenshot, double tolerance) {
        File recordedScreenshotFile = new File(screenshot.recordedScreenshotPath());
        if (!recordedScreenshotFile.exists()) {
            return new Some((Object)new ScreenshotNotFound(screenshot));
        }
        ImmutableImage oldScreenshot = ImmutableImage.loader().fromFile(recordedScreenshotFile);
        ImmutableImage newScreenshot = ScreenshotComposer$.MODULE$.composeNewScreenshot(screenshot);
        if (!this.haveSameDimensions(newScreenshot, oldScreenshot)) {
            Dimension originalDimension = new Dimension(oldScreenshot.width, oldScreenshot.height);
            Dimension newDimension = new Dimension(newScreenshot.width, newScreenshot.height);
            return new Some((Object)new DifferentImageDimensions(screenshot, originalDimension, newDimension));
        }
        if (this.imagesAreDifferent(screenshot, oldScreenshot, newScreenshot, tolerance)) {
            return new Some((Object)new DifferentScreenshots(screenshot, DifferentScreenshots$.MODULE$.apply$default$2()));
        }
        return None$.MODULE$;
    }

    private boolean imagesAreDifferent(Screenshot screenshot, ImmutableImage oldScreenshot, ImmutableImage newScreenshot, double tolerance) {
        boolean imagesAreDifferent;
        block1: {
            boolean imagesAreConsideredEquals;
            ImmutableImage immutableImage = oldScreenshot;
            ImmutableImage immutableImage2 = newScreenshot;
            if (!(immutableImage != null ? !immutableImage.equals(immutableImage2) : immutableImage2 != null)) {
                return false;
            }
            Pixel[] oldScreenshotPixels = oldScreenshot.pixels();
            Pixel[] newScreenshotPixels = newScreenshot.pixels();
            Tuple2[] differentPixels = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])oldScreenshotPixels), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newScreenshotPixels))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ScreenshotsComparator.$anonfun$imagesAreDifferent$1(x0$1)));
            double percentageOfDifferentPixels = (double)differentPixels.length / (double)oldScreenshotPixels.length;
            double percentageOutOf100 = percentageOfDifferentPixels * 100.0;
            imagesAreDifferent = percentageOutOf100 > tolerance;
            boolean bl = imagesAreConsideredEquals = !imagesAreDifferent;
            if (!imagesAreConsideredEquals || tolerance == Config$.MODULE$.defaultTolerance()) break block1;
            String screenshotName = screenshot.name();
            Predef$.MODULE$.println((Object)new StringBuilder(205).append("\u001b[33m").append("\u26a0\ufe0f   Shot warning: There are some pixels changed in the screenshot named ").append(screenshotName).append(", but we consider the comparison correct because tolerance is configured to ").append(tolerance).append(" % and the percentage of different pixels is ").append(percentageOutOf100).append(" %").append("\u001b[0m").toString());
        }
        return imagesAreDifferent;
    }

    private boolean haveSameDimensions(ImmutableImage newScreenshot, ImmutableImage recordedScreenshot) {
        return newScreenshot.width == recordedScreenshot.width && newScreenshot.height == recordedScreenshot.height;
    }

    public static final /* synthetic */ boolean $anonfun$imagesAreDifferent$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Pixel a = (Pixel)tuple2._1();
            Pixel b = (Pixel)tuple2._2();
            Pixel pixel = a;
            Pixel pixel2 = b;
            return pixel == null ? pixel2 != null : !pixel.equals(pixel2);
        }
        throw new MatchError((Object)tuple2);
    }
}

