/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot.screenshots;

import com.karumi.shot.domain.Dimension;
import com.karumi.shot.domain.Screenshot;
import com.karumi.shot.domain.ScreenshotsComparisionResult;
import com.karumi.shot.domain.ShotFolder;
import com.karumi.shot.screenshots.ScreenshotComposer$;
import com.sksamuel.scrimage.ImmutableImage;
import com.sksamuel.scrimage.nio.ImageWriter;
import com.sksamuel.scrimage.nio.PngWriter;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\u0007\u000e\u0001YAQ!\b\u0001\u0005\u0002yAQ!\t\u0001\u0005\u0002\tBQ\u0001\u0011\u0001\u0005\n\u0005CQ\u0001\u0013\u0001\u0005\n%CQ\u0001\u0016\u0001\u0005\u0002UCQ!\u0019\u0001\u0005\n\tDQ!\u001a\u0001\u0005\u0002\u0019DQA\u001b\u0001\u0005\u0002-DQa\u001d\u0001\u0005\nQDQa\u001f\u0001\u0005\u0002qDq!!\u0001\u0001\t\u0003\t\u0019A\u0001\tTGJ,WM\\:i_R\u001c8+\u0019<fe*\u0011abD\u0001\fg\u000e\u0014X-\u001a8tQ>$8O\u0003\u0002\u0011#\u0005!1\u000f[8u\u0015\t\u00112#\u0001\u0004lCJ,X.\u001b\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005i\u0011aF:bm\u0016\u0014VmY8sI\u0016$7k\u0019:fK:\u001c\bn\u001c;t)\r\u0019c\u0005\u0010\t\u00031\u0011J!!J\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\t\u0001\r\u0001K\u0001\u0003i>\u0004\"!K\u001d\u000f\u0005)2dBA\u00165\u001d\ta3G\u0004\u0002.e9\u0011a&M\u0007\u0002_)\u0011\u0001'F\u0001\u0007yI|w\u000e\u001e \n\u0003QI!AE\n\n\u0005A\t\u0012BA\u001b\u0010\u0003\u0019!w.\\1j]&\u0011q\u0007O\u0001\u0006[>$W\r\u001c\u0006\u0003k=I!AO\u001e\u0003\u0011\u0019KG.\u001a)bi\"T!a\u000e\u001d\t\u000b9\u0011\u0001\u0019A\u001f\u0011\u0005%r\u0014BA <\u0005A\u00196M]3f]NDw\u000e^:Tk&$X-A\btCZ,7k\u0019:fK:\u001c\bn\u001c;t)\r\u0019#i\u0011\u0005\u0006\u001d\r\u0001\r!\u0010\u0005\u0006\t\u000e\u0001\r!R\u0001\u0007M>dG-\u001a:\u0011\u0005%2\u0015BA$<\u0005\u00191u\u000e\u001c3fe\u0006QA-\u001a7fi\u00164\u0015\u000e\\3\u0015\u0005\rR\u0005\"B&\u0005\u0001\u0004a\u0015\u0001\u00029bi\"\u0004\"!T)\u000f\u00059{\u0005C\u0001\u0018\u001a\u0013\t\u0001\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)\u001a\u0003]\u0019\u0018M^3UK6\u0004xN]1m'\u000e\u0014X-\u001a8tQ>$8\u000fF\u0003$-^K6\fC\u0003\u000f\u000b\u0001\u0007Q\bC\u0003Y\u000b\u0001\u0007A*A\u0006qe>TWm\u0019;OC6,\u0007\"\u0002.\u0006\u0001\u0004a\u0015\u0001\u0004:fa>\u0014HOR8mI\u0016\u0014\b\"\u0002/\u0006\u0001\u0004i\u0016AC:i_R4u\u000e\u001c3feB\u0011alX\u0007\u0002q%\u0011\u0001\r\u000f\u0002\u000b'\"|GOR8mI\u0016\u0014\u0018\u0001\b3fY\u0016$Xm\u00147e)\u0016l\u0007o\u001c:bYN\u001b'/Z3og\"|Go\u001d\u000b\u0004G\r$\u0007\"\u0002-\u0007\u0001\u0004a\u0005\"\u0002/\u0007\u0001\u0004i\u0016\u0001K2paf\u0014VmY8sI\u0016$7k\u0019:fK:\u001c\bn\u001c;t)>$\u0006.\u001a*fa>\u0014HOR8mI\u0016\u0014HcA\u0012hS\")\u0001n\u0002a\u0001Q\u0005!aM]8n\u0011\u00159s\u00011\u0001)\u0003M\u001aw\u000e]=P]2Lh)Y5mS:<'+Z2pe\u0012,GmU2sK\u0016t7\u000f[8ugR{G\u000b[3SKB|'\u000f\u001e$pY\u0012,'\u000fF\u0002$Y:DQ!\u001c\u0005A\u0002\u0015\u000bQ\u0002Z3ti&t\u0017PR8mI\u0016\u0014\b\"B8\t\u0001\u0004\u0001\u0018!E:de\u0016,gn\u001d5piN\u0014Vm];miB\u0011a,]\u0005\u0003eb\u0012AdU2sK\u0016t7\u000f[8ug\u000e{W\u000e]1sSNLwN\u001c*fgVdG/\u0001\u0005d_BLh)\u001b7f)\r\u0019SO\u001f\u0005\u0006m&\u0001\ra^\u0001\u000bg\u000e\u0014X-\u001a8tQ>$\bC\u00010y\u0013\tI\bH\u0001\u0006TGJ,WM\\:i_RDQ!\\\u0005A\u0002\u0015\u000bqD]3n_Z,gj\u001c8GC&d\u0017N\\4SK\u001a,'/\u001a8dK&k\u0017mZ3t)\r\u0019Sp \u0005\u0006}*\u0001\r!R\u0001\"m\u0016\u0014\u0018NZ5dCRLwN\u001c*fM\u0016\u0014XM\\2f\u00136\fw-Z:G_2$WM\u001d\u0005\u0006_*\u0001\r\u0001]\u0001\u0017O\u0016$8k\u0019:fK:\u001c\bn\u001c;ES6,gn]5p]R1\u0011QAA\u0006\u0003\u001b\u00012AXA\u0004\u0013\r\tI\u0001\u000f\u0002\n\t&lWM\\:j_:DQ\u0001X\u0006A\u0002uCQA^\u0006A\u0002]\u0004")
public class ScreenshotsSaver {
    public void saveRecordedScreenshots(String to, Seq<Screenshot> screenshots) {
        this.deleteFile(to);
        this.saveScreenshots(screenshots, to);
    }

    private void saveScreenshots(Seq<Screenshot> screenshots, String folder) {
        File screenshotsFolder = new File(folder);
        Object object = !screenshotsFolder.exists() ? BoxesRunTime.boxToBoolean((boolean)screenshotsFolder.mkdirs()) : BoxedUnit.UNIT;
        screenshots.foreach((Function1 & Serializable)screenshot -> {
            File outputFile = new File(new StringBuilder(0).append(folder).append(screenshot.fileName()).toString());
            Object object = !outputFile.exists() ? BoxesRunTime.boxToBoolean((boolean)outputFile.createNewFile()) : BoxedUnit.UNIT;
            ImmutableImage image = ScreenshotComposer$.MODULE$.composeNewScreenshot((Screenshot)screenshot);
            return image.output((ImageWriter)PngWriter.MaxCompression, outputFile);
        });
    }

    private void deleteFile(String path) {
        File folder = new File(path);
        if (folder.exists()) {
            folder.delete();
            return;
        }
    }

    public void saveTemporalScreenshots(Seq<Screenshot> screenshots, String projectName, String reportFolder, ShotFolder shotFolder) {
        this.deleteOldTemporalScreenshots(projectName, shotFolder);
        this.saveScreenshots(screenshots, new StringBuilder(1).append(shotFolder.screenshotsTemporalBuildPath()).append("/").toString());
        this.deleteFile(reportFolder);
        this.saveScreenshots(screenshots, reportFolder);
    }

    private void deleteOldTemporalScreenshots(String projectName, ShotFolder shotFolder) {
        this.deleteFile(new StringBuilder(1).append(shotFolder.screenshotsTemporalBuildPath()).append("/").toString());
    }

    public void copyRecordedScreenshotsToTheReportFolder(String from, String to) {
        FileUtils.copyDirectory((File)new File(from), (File)new File(to));
        this.deleteFile(to);
    }

    public void copyOnlyFailingRecordedScreenshotsToTheReportFolder(String destinyFolder, ScreenshotsComparisionResult screenshotsResult) {
        screenshotsResult.errorScreenshots().foreach((Function1 & Serializable)x$1 -> {
            this.copyFile(x$1, destinyFolder);
            return BoxedUnit.UNIT;
        });
        this.deleteFile(destinyFolder);
    }

    private void copyFile(Screenshot screenshot, String destinyFolder) {
        File existingScreenshot = new File(screenshot.recordedScreenshotPath());
        FileUtils.copyFile((File)existingScreenshot, (File)new File(new StringBuilder(0).append(destinyFolder).append(existingScreenshot.getName()).toString()));
    }

    public void removeNonFailingReferenceImages(String verificationReferenceImagesFolder, ScreenshotsComparisionResult screenshotsResult) {
        screenshotsResult.correctScreenshots().foreach((Function1 & Serializable)screenshot -> {
            this.deleteFile(new StringBuilder(0).append(verificationReferenceImagesFolder).append(screenshot.fileName()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public Dimension getScreenshotDimension(ShotFolder shotFolder, Screenshot screenshot) {
        String screenshotPath = new StringBuilder(4).append(shotFolder.pulledScreenshotsFolder()).append(screenshot.name()).append(".png").toString();
        ImmutableImage image = ImmutableImage.loader().fromFile(new File(screenshotPath));
        return new Dimension(image.width, image.height);
    }
}

