/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.Files;
import com.karumi.shot.Shot;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.android.Adb;
import com.karumi.shot.base64.Base64Encoder;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.tasks.ShotTask;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import scala.Function0;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001%\u0011!b\u00155piBcWoZ5o\u0015\t\u0019A!\u0001\u0003tQ>$(BA\u0003\u0007\u0003\u0019Y\u0017M];nS*\tq!A\u0002d_6\u001c\u0001aE\u0002\u0001\u0015I\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0004'iaR\"\u0001\u000b\u000b\u0005U1\u0012aA1qS*\u0011q\u0003G\u0001\u0007OJ\fG\r\\3\u000b\u0003e\t1a\u001c:h\u0013\tYBC\u0001\u0004QYV<\u0017N\u001c\t\u0003'uI!A\b\u000b\u0003\u000fA\u0013xN[3di\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003\u001d\u0019wN\\:pY\u0016,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U\t\t!!^5\n\u00051J#aB\"p]N|G.\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u0011\r|gn]8mK\u0002B\u0001b\u0001\u0001\t\u0006\u0004%I\u0001M\u000b\u0002cA\u00111EM\u0005\u0003g\t\u0011Aa\u00155pi\")Q\u0007\u0001C!m\u0005)\u0011\r\u001d9msR\u0011q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0005+:LG\u000fC\u0003?i\u0001\u0007A$A\u0004qe>TWm\u0019;\t\u000b\u0001\u0003A\u0011B!\u0002\u0019\r|gNZ5hkJ,\u0017\t\u001a2\u0015\u0005]\u0012\u0005\"\u0002 @\u0001\u0004a\u0002\"\u0002#\u0001\t\u0013)\u0015\u0001C1eIR\u000b7o[:\u0015\u0005]2\u0005\"\u0002 D\u0001\u0004a\u0002\"\u0002%\u0001\t\u0013I\u0015aF1eIR\u000b7o[:U_2K'M]1ss6{G-\u001e7f)\t9$\nC\u0003?\u000f\u0002\u0007A\u0004C\u0003M\u0001\u0011%Q*A\nbI\u0012$\u0016m]6t)>\f\u0005\u000f]'pIVdW\r\u0006\u00028\u001d\")ah\u0013a\u00019!)\u0001\u000b\u0001C\u0005#\u0006\u0001\u0012\r\u001a3UCN\\Gk\u001c,be&\fg\u000e\u001e\u000b\u0005oI\u001b6\fC\u0003?\u001f\u0002\u0007A\u0004C\u0003U\u001f\u0002\u0007Q+\u0001\u0005cCN,G+Y:l!\t1\u0016,D\u0001X\u0015\tA&!A\u0003uCN\\7/\u0003\u0002[/\n!S\t_3dkR,7k\u0019:fK:\u001c\bn\u001c;UKN$8OR8s\u000bZ,'/\u001f$mCZ|'\u000fC\u0003]\u001f\u0002\u0007Q,A\u0004wCJL\u0017M\u001c;\u0011\u0005y+W\"A0\u000b\u0005U\u0001'BA\fb\u0015\t\u00117-A\u0003ck&dGM\u0003\u0002e\r\u00059\u0011M\u001c3s_&$\u0017B\u00014`\u0005-\u0011\u0015m]3WCJL\u0017M\u001c;\t\u000b!\u0004A\u0011B5\u0002A\rDWmY6JM\u0006\u0003\b\u000f\\5dCRLwN\\%e\u0013N\u001cuN\u001c4jOV\u0014X\r\u001a\u000b\u0004o)\\\u0007\"\u0002 h\u0001\u0004a\u0002\"\u00027h\u0001\u0004i\u0017A\u00024mCZ|'\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u0006)Qn\u001c3fY*\u0011!oY\u0001\bEVLG\u000eZ3s\u0013\t!xNA\u0007Qe>$Wo\u0019;GY\u00064xN\u001d\u0005\u0006m\u0002!Ia^\u0001\u000eC\u0012$W\t\u001f;f]NLwN\\:\u0015\u0005]B\b\"\u0002 v\u0001\u0004a\u0002\"\u0002>\u0001\t\u0013Y\u0018aC1eIR\u000b7o[:G_J$\u0012b\u000e?~\u0003'\ti\"!\t\t\u000byJ\b\u0019\u0001\u000f\t\u000b1L\b\u0019\u0001@\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002s5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fA\u0011A\u0002\u001fs_>$h(C\u0002\u0002\fe\na\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006s!9\u0011QC=A\u0002\u0005]\u0011!\u00032vS2$G+\u001f9f!\rq\u0017\u0011D\u0005\u0004\u00037y'!\u0003\"vS2$G+\u001f9f\u0011\u0019\ty\"\u001fa\u0001}\u0006)\u0011\r\u001d9JI\"1A+\u001fa\u0001\u0003G\u00012aEA\u0013\u0013\r\t9\u0003\u0006\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002,\u0001!I!!\f\u00021\u0005$G-\u00118ee>LG\rV3ti\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010F\u00028\u0003_AaAPA\u0015\u0001\u0004a\u0002bBA\u001a\u0001\u0011%\u0011QG\u0001\u0013SN\fe.\u00118ee>LG\rT5ce\u0006\u0014\u0018\u0010\u0006\u0003\u00028\u0005u\u0002c\u0001\u001d\u0002:%\u0019\u00111H\u001d\u0003\u000f\t{w\u000e\\3b]\"1a(!\rA\u0002qAq!!\u0011\u0001\t\u0013\t\u0019%\u0001\njg\u0006s\u0017I\u001c3s_&$\u0007K]8kK\u000e$H\u0003BA\u001c\u0003\u000bBaAPA \u0001\u0004a\u0002bBA%\u0001\u0011%\u00111J\u0001\u001bO\u0016$\u0018I\u001c3s_&$G*\u001b2sCJLX\t\u001f;f]NLwN\u001c\u000b\u0005\u0003\u001b\n)\u0006\u0005\u0003\u0002P\u0005ES\"\u00011\n\u0007\u0005M\u0003M\u0001\tMS\n\u0014\u0018M]=FqR,gn]5p]\"1a(a\u0012A\u0002qAq!!\u0017\u0001\t\u0013\tY&\u0001\fhKR\fe\u000e\u001a:pS\u0012\f\u0005\u000f]#yi\u0016t7/[8o)\u0011\ti&a\u0019\u0011\t\u0005=\u0013qL\u0005\u0004\u0003C\u0002'\u0001D!qa\u0016CH/\u001a8tS>t\u0007B\u0002 \u0002X\u0001\u0007A\u0004")
public class ShotPlugin
implements Plugin<Project> {
    private Shot shot;
    private final Console console = new Console();
    private volatile boolean bitmap$0;

    private Console console() {
        return this.console;
    }

    private Shot shot$lzycompute() {
        ShotPlugin shotPlugin = this;
        synchronized (shotPlugin) {
            if (!this.bitmap$0) {
                this.shot = new Shot(new Adb(), new Files(), new ScreenshotsComparator(), new ScreenshotsDiffGenerator(new Base64Encoder()), new ScreenshotsSaver(), this.console(), new ExecutionReporter(), new ConsoleReporter(this.console()));
                this.bitmap$0 = true;
            }
        }
        return this.shot;
    }

    private Shot shot() {
        return !this.bitmap$0 ? this.shot$lzycompute() : this.shot;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> {
            this.configureAdb((Project)project);
            this.addTasks((Project)project);
        });
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
        this.shot().configureAdbPath(adbPath);
    }

    private void addTasks(Project project) {
        block1: {
            block0: {
                if (!this.isAnAndroidProject(project)) break block0;
                this.addTasksToAppModule(project);
                break block1;
            }
            if (!this.isAnAndroidLibrary(project)) break block1;
            this.addTasksToLibraryModule(project);
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        ExecuteScreenshotTestsForEveryFlavor baseTask = (ExecuteScreenshotTestsForEveryFlavor)project.getTasks().create(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        ExecuteScreenshotTestsForEveryFlavor baseTask = (ExecuteScreenshotTestsForEveryFlavor)project.getTasks().create(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, ExecuteScreenshotTestsForEveryFlavor baseTask, BaseVariant variant) {
        block0: {
            ProductFlavor flavor = variant.getMergedFlavor();
            this.checkIfApplicationIdIsConfigured(project, flavor);
            String completeAppId = flavor.getApplicationId() + Option$.MODULE$.apply((Object)flavor.getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + Option$.MODULE$.apply((Object)variant.getBuildType().getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ".test";
            String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> completeAppId);
            String string = variant.getBuildType().getName();
            String string2 = "release";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.addTasksFor(project, variant.getFlavorName(), variant.getBuildType(), appTestId, (Task)baseTask);
        }
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, String flavor, BuildType buildType, String appId, Task baseTask) {
        BoxedUnit boxedUnit;
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTask = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        ShotTask removeScreenshots = (ShotTask)tasks.create(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType), RemoveScreenshotsTask.class);
        removeScreenshots.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
        removeScreenshots.flavor_$eq(flavor);
        removeScreenshots.buildType_$eq(buildType);
        removeScreenshots.appId_$eq(appId);
        DownloadScreenshotsTask downloadScreenshots = (DownloadScreenshotsTask)tasks.create(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
        downloadScreenshots.flavor_$eq(flavor);
        downloadScreenshots.buildType_$eq(buildType);
        downloadScreenshots.appId_$eq(appId);
        ExecuteScreenshotTests executeScreenshot = (ExecuteScreenshotTests)tasks.create(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
        executeScreenshot.flavor_$eq(flavor);
        executeScreenshot.buildType_$eq(buildType);
        executeScreenshot.appId_$eq(appId);
        if (extension.runInstrumentation()) {
            executeScreenshot.dependsOn(new Object[]{instrumentationTask});
            executeScreenshot.dependsOn(new Object[]{downloadScreenshots});
            executeScreenshot.dependsOn(new Object[]{removeScreenshots});
            downloadScreenshots.mustRunAfter(new Object[]{instrumentationTask});
            boxedUnit = removeScreenshots.mustRunAfter(new Object[]{downloadScreenshots});
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        baseTask.dependsOn(new Object[]{executeScreenshot});
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.getByName(Config$.MODULE$.androidDependencyMode()).extendsFrom(new Configuration[]{shotConfig});
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }
}

