/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.Files;
import com.karumi.shot.Shot;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.android.Adb;
import com.karumi.shot.base64.Base64Encoder;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import scala.Function0;
import scala.Option$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001%\u0011!b\u00155piBcWoZ5o\u0015\t\u0019A!\u0001\u0003tQ>$(BA\u0003\u0007\u0003\u0019Y\u0017M];nS*\tq!A\u0002d_6\u001c\u0001aE\u0002\u0001\u0015I\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0004'iaR\"\u0001\u000b\u000b\u0005U1\u0012aA1qS*\u0011q\u0003G\u0001\u0007OJ\fG\r\\3\u000b\u0003e\t1a\u001c:h\u0013\tYBC\u0001\u0004QYV<\u0017N\u001c\t\u0003'uI!A\b\u000b\u0003\u000fA\u0013xN[3di\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003\u001d\u0019wN\\:pY\u0016,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U\t\t!!^5\n\u00051J#aB\"p]N|G.\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u0011\r|gn]8mK\u0002B\u0001b\u0001\u0001\t\u0006\u0004%I\u0001M\u000b\u0002cA\u00111EM\u0005\u0003g\t\u0011Aa\u00155pi\")Q\u0007\u0001C!m\u0005)\u0011\r\u001d9msR\u0011q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0005+:LG\u000fC\u0003?i\u0001\u0007A$A\u0004qe>TWm\u0019;\t\u000b\u0001\u0003A\u0011B!\u0002\u0019\r|gNZ5hkJ,\u0017\t\u001a2\u0015\u0005]\u0012\u0005\"\u0002 @\u0001\u0004a\u0002\"\u0002#\u0001\t\u0013)\u0015\u0001C1eIR\u000b7o[:\u0015\u0005]2\u0005\"\u0002 D\u0001\u0004a\u0002\"\u0002%\u0001\t\u0013I\u0015aF1eIR\u000b7o[:U_2K'M]1ss6{G-\u001e7f)\t9$\nC\u0003?\u000f\u0002\u0007A\u0004C\u0003M\u0001\u0011%Q*A\nbI\u0012$\u0016m]6t)>\f\u0005\u000f]'pIVdW\r\u0006\u00028\u001d\")ah\u0013a\u00019!)\u0001\u000b\u0001C\u0005#\u0006\u0001\u0012\r\u001a3UCN\\Gk\u001c,be&\fg\u000e\u001e\u000b\u0005oI\u001b\u0006\rC\u0003?\u001f\u0002\u0007A\u0004C\u0003U\u001f\u0002\u0007Q+\u0001\u0005cCN,G+Y:l!\r1\u0016lW\u0007\u0002/*\u0011\u0001\fF\u0001\u0006i\u0006\u001c8n]\u0005\u00035^\u0013A\u0002V1tWB\u0013xN^5eKJ\u0004\"\u0001\u00180\u000e\u0003uS!\u0001\u0017\u0002\n\u0005}k&\u0001J#yK\u000e,H/Z*de\u0016,gn\u001d5piR+7\u000f^:G_J,e/\u001a:z\r2\fgo\u001c:\t\u000b\u0005|\u0005\u0019\u00012\u0002\u000fY\f'/[1oiB\u00111M[\u0007\u0002I*\u0011Q#\u001a\u0006\u0003/\u0019T!a\u001a5\u0002\u000b\t,\u0018\u000e\u001c3\u000b\u0005%4\u0011aB1oIJ|\u0017\u000eZ\u0005\u0003W\u0012\u00141BQ1tKZ\u000b'/[1oi\")Q\u000e\u0001C\u0005]\u0006\u00013\r[3dW&3\u0017\t\u001d9mS\u000e\fG/[8o\u0013\u0012L5oQ8oM&<WO]3e)\r9t\u000e\u001d\u0005\u0006}1\u0004\r\u0001\b\u0005\u0006c2\u0004\rA]\u0001\u0007M2\fgo\u001c:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!B7pI\u0016d'BA<i\u0003\u001d\u0011W/\u001b7eKJL!!\u001f;\u0003\u001bA\u0013x\u000eZ;di\u001ac\u0017M^8s\u0011\u0015Y\b\u0001\"\u0003}\u00035\tG\rZ#yi\u0016t7/[8ogR\u0011q' \u0005\u0006}i\u0004\r\u0001\b\u0005\u0007\u007f\u0002!I!!\u0001\u0002\u0017\u0005$G\rV1tWN4uN\u001d\u000b\fo\u0005\r\u0011QAA\u000f\u0003O\tY\u0003C\u0003?}\u0002\u0007A\u0004\u0003\u0004r}\u0002\u0007\u0011q\u0001\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007s5\u0011\u0011q\u0002\u0006\u0004\u0003#A\u0011A\u0002\u001fs_>$h(C\u0002\u0002\u0016e\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000bs!9\u0011q\u0004@A\u0002\u0005\u0005\u0012!\u00032vS2$G+\u001f9f!\r\u0019\u00181E\u0005\u0004\u0003K!(!\u0003\"vS2$G+\u001f9f\u0011\u001d\tIC a\u0001\u0003\u000f\tQ!\u00199q\u0013\u0012DQ\u0001\u0016@A\u0002UCq!a\f\u0001\t\u0013\t\t$\u0001\rbI\u0012\fe\u000e\u001a:pS\u0012$Vm\u001d;EKB,g\u000eZ3oGf$2aNA\u001a\u0011\u0019q\u0014Q\u0006a\u00019!9\u0011q\u0007\u0001\u0005\n\u0005e\u0012AE5t\u0003:\fe\u000e\u001a:pS\u0012d\u0015N\u0019:bef$B!a\u000f\u0002BA\u0019\u0001(!\u0010\n\u0007\u0005}\u0012HA\u0004C_>dW-\u00198\t\ry\n)\u00041\u0001\u001d\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\n!#[:B]\u0006sGM]8jIB\u0013xN[3diR!\u00111HA%\u0011\u0019q\u00141\ta\u00019!9\u0011Q\n\u0001\u0005\n\u0005=\u0013AG4fi\u0006sGM]8jI2K'M]1ss\u0016CH/\u001a8tS>tG\u0003BA)\u00033\u0002B!a\u0015\u0002V5\tQ-C\u0002\u0002X\u0015\u0014\u0001\u0003T5ce\u0006\u0014\u00180\u0012=uK:\u001c\u0018n\u001c8\t\ry\nY\u00051\u0001\u001d\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\nacZ3u\u0003:$'o\\5e\u0003B\u0004X\t\u001f;f]NLwN\u001c\u000b\u0005\u0003C\n9\u0007\u0005\u0003\u0002T\u0005\r\u0014bAA3K\na\u0011\t\u001d9FqR,gn]5p]\"1a(a\u0017A\u0002q\u0001")
public class ShotPlugin
implements Plugin<Project> {
    private Shot shot;
    private final Console console = new Console();
    private volatile boolean bitmap$0;

    private Console console() {
        return this.console;
    }

    private Shot shot$lzycompute() {
        ShotPlugin shotPlugin = this;
        synchronized (shotPlugin) {
            if (!this.bitmap$0) {
                this.shot = new Shot(new Adb(), new Files(), new ScreenshotsComparator(), new ScreenshotsDiffGenerator(new Base64Encoder()), new ScreenshotsSaver(), this.console(), new ExecutionReporter(), new ConsoleReporter(this.console()));
                this.bitmap$0 = true;
            }
        }
        return this.shot;
    }

    private Shot shot() {
        return !this.bitmap$0 ? this.shot$lzycompute() : this.shot;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> {
            this.configureAdb((Project)project);
            this.addTasks((Project)project);
        });
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
        this.shot().configureAdbPath(adbPath);
    }

    private void addTasks(Project project) {
        block1: {
            block0: {
                if (!this.isAnAndroidProject(project)) break block0;
                this.addTasksToAppModule(project);
                break block1;
            }
            if (!this.isAnAndroidLibrary(project)) break block1;
            this.addTasksToLibraryModule(project);
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask, BaseVariant variant) {
        block0: {
            ProductFlavor flavor = variant.getMergedFlavor();
            this.checkIfApplicationIdIsConfigured(project, flavor);
            String completeAppId = flavor.getApplicationId() + Option$.MODULE$.apply((Object)flavor.getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + Option$.MODULE$.apply((Object)variant.getBuildType().getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ".test";
            String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> completeAppId);
            String string = variant.getBuildType().getName();
            String string2 = "release";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.addTasksFor(project, variant.getFlavorName(), variant.getBuildType(), appTestId, baseTask);
        }
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, String flavor, BuildType buildType, String appId, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask) {
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTask = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        TaskProvider removeScreenshots = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType), RemoveScreenshotsTask.class);
        removeScreenshots.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider downloadScreenshots = tasks.register(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.configure(task -> {
            task.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider executeScreenshot = tasks.register(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.configure(task -> {
            task.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        if (extension.runInstrumentation()) {
            executeScreenshot.configure(task -> {
                task.dependsOn(new Object[]{instrumentationTask});
                task.dependsOn(new Object[]{downloadScreenshots});
                task.dependsOn(new Object[]{removeScreenshots});
            });
            downloadScreenshots.configure(task -> task.mustRunAfter(new Object[]{instrumentationTask}));
            removeScreenshots.configure(task -> task.mustRunAfter(new Object[]{downloadScreenshots}));
        }
        baseTask.configure(task -> task.dependsOn(new Object[]{executeScreenshot}));
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.getByName(Config$.MODULE$.androidDependencyMode()).extendsFrom(new Configuration[]{shotConfig});
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }
}

