/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.Files;
import com.karumi.shot.Shot;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.android.Adb;
import com.karumi.shot.base64.Base64Encoder;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.system.EnvVars;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import scala.Function0;
import scala.Option$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\n\u0015\u0001mAQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0005\t+\u0001A)\u0019!C\u0005}!)!\t\u0001C!\u0007\")A\n\u0001C\u0005\u001b\")q\n\u0001C\u0005!\")!\u000b\u0001C\u0005'\")Q\u000b\u0001C\u0005-\")\u0001\f\u0001C\u00053\")A\u000f\u0001C\u0005k\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0001bBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\tQ1\u000b[8u!2,x-\u001b8\u000b\u0005U1\u0012\u0001B:i_RT!a\u0006\r\u0002\r-\f'/^7j\u0015\u0005I\u0012aA2p[\u000e\u00011c\u0001\u0001\u001dIA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB(cU\u0016\u001cG\u000fE\u0002&Y9j\u0011A\n\u0006\u0003O!\n1!\u00199j\u0015\tI#&\u0001\u0004he\u0006$G.\u001a\u0006\u0002W\u0005\u0019qN]4\n\u000552#A\u0002)mk\u001eLg\u000e\u0005\u0002&_%\u0011\u0001G\n\u0002\b!J|'.Z2u\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\tA#A\u0004d_:\u001cx\u000e\\3\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u000b\u0002\u0005UL\u0017B\u0001\u001f:\u0005\u001d\u0019uN\\:pY\u0016\f\u0001bY8og>dW\rI\u000b\u0002\u007fA\u0011A\u0007Q\u0005\u0003\u0003R\u0011Aa\u00155pi\u0006)\u0011\r\u001d9msR\u0011AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0005+:LG\u000fC\u0003L\u000b\u0001\u0007a&A\u0004qe>TWm\u0019;\u0002\u0019\r|gNZ5hkJ,\u0017\t\u001a2\u0015\u0005\u0011s\u0005\"B&\u0007\u0001\u0004q\u0013\u0001C1eIR\u000b7o[:\u0015\u0005\u0011\u000b\u0006\"B&\b\u0001\u0004q\u0013aF1eIR\u000b7o[:U_2K'M]1ss6{G-\u001e7f)\t!E\u000bC\u0003L\u0011\u0001\u0007a&A\nbI\u0012$\u0016m]6t)>\f\u0005\u000f]'pIVdW\r\u0006\u0002E/\")1*\u0003a\u0001]\u0005\u0001\u0012\r\u001a3UCN\\Gk\u001c,be&\fg\u000e\u001e\u000b\u0005\tj[\u0006\u000eC\u0003L\u0015\u0001\u0007a\u0006C\u0003]\u0015\u0001\u0007Q,\u0001\u0005cCN,G+Y:l!\rq\u0016mY\u0007\u0002?*\u0011\u0001MJ\u0001\u0006i\u0006\u001c8n]\u0005\u0003E~\u0013A\u0002V1tWB\u0013xN^5eKJ\u0004\"\u0001\u001a4\u000e\u0003\u0015T!\u0001\u0019\u000b\n\u0005\u001d,'\u0001J#yK\u000e,H/Z*de\u0016,gn\u001d5piR+7\u000f^:G_J,e/\u001a:z\r2\fgo\u001c:\t\u000b%T\u0001\u0019\u00016\u0002\u000fY\f'/[1oiB\u00111N]\u0007\u0002Y*\u0011q%\u001c\u0006\u0003S9T!a\u001c9\u0002\u000b\t,\u0018\u000e\u001c3\u000b\u0005ED\u0012aB1oIJ|\u0017\u000eZ\u0005\u0003g2\u00141BQ1tKZ\u000b'/[1oi\u0006\u00013\r[3dW&3\u0017\t\u001d9mS\u000e\fG/[8o\u0013\u0012L5oQ8oM&<WO]3e)\r!eo\u001e\u0005\u0006\u0017.\u0001\rA\f\u0005\u0006q.\u0001\r!_\u0001\u0007M2\fgo\u001c:\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!B7pI\u0016d'B\u0001@q\u0003\u001d\u0011W/\u001b7eKJL1!!\u0001|\u00055\u0001&o\u001c3vGR4E.\u0019<pe\u0006i\u0011\r\u001a3FqR,gn]5p]N$2\u0001RA\u0004\u0011\u0015YE\u00021\u0001/\u0003-\tG\r\u001a+bg.\u001chi\u001c:\u0015\u0017\u0011\u000bi!a\u0004\u0002(\u0005E\u0012Q\u0007\u0005\u0006\u00176\u0001\rA\f\u0005\u0007q6\u0001\r!!\u0005\u0011\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\ti\u0002E\u0002\u0002\u0018\u0019k!!!\u0007\u000b\u0007\u0005m!$\u0001\u0004=e>|GOP\u0005\u0004\u0003?1\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0015\"AB*ue&twMC\u0002\u0002 \u0019Cq!!\u000b\u000e\u0001\u0004\tY#A\u0005ck&dG\rV=qKB\u0019!0!\f\n\u0007\u0005=2PA\u0005Ck&dG\rV=qK\"9\u00111G\u0007A\u0002\u0005E\u0011!B1qa&#\u0007\"\u0002/\u000e\u0001\u0004i\u0016\u0001G1eI\u0006sGM]8jIR+7\u000f\u001e#fa\u0016tG-\u001a8dsR\u0019A)a\u000f\t\u000b-s\u0001\u0019\u0001\u0018\u0002%%\u001c\u0018I\\!oIJ|\u0017\u000e\u001a'jEJ\f'/\u001f\u000b\u0005\u0003\u0003\n9\u0005E\u0002F\u0003\u0007J1!!\u0012G\u0005\u001d\u0011un\u001c7fC:DQaS\bA\u00029\n!#[:B]\u0006sGM]8jIB\u0013xN[3diR!\u0011\u0011IA'\u0011\u0015Y\u0005\u00031\u0001/\u0003i9W\r^!oIJ|\u0017\u000e\u001a'jEJ\f'/_#yi\u0016t7/[8o)\u0011\t\u0019&a\u0017\u0011\t\u0005U\u0013qK\u0007\u0002[&\u0019\u0011\u0011L7\u0003!1K'M]1ss\u0016CH/\u001a8tS>t\u0007\"B&\u0012\u0001\u0004q\u0013AF4fi\u0006sGM]8jI\u0006\u0003\b/\u0012=uK:\u001c\u0018n\u001c8\u0015\t\u0005\u0005\u0014q\r\t\u0005\u0003+\n\u0019'C\u0002\u0002f5\u0014A\"\u00119q\u000bb$XM\\:j_:DQa\u0013\nA\u00029\u0002")
public class ShotPlugin
implements Plugin<Project> {
    private Shot shot;
    private final Console console = new Console();
    private volatile boolean bitmap$0;

    private Console console() {
        return this.console;
    }

    private Shot shot$lzycompute() {
        ShotPlugin shotPlugin = this;
        synchronized (shotPlugin) {
            if (!this.bitmap$0) {
                this.shot = new Shot(new Adb(), new Files(), new ScreenshotsComparator(), new ScreenshotsDiffGenerator(new Base64Encoder()), new ScreenshotsSaver(), this.console(), new ExecutionReporter(), new ConsoleReporter(this.console()), new EnvVars());
                this.bitmap$0 = true;
            }
        }
        return this.shot;
    }

    private Shot shot() {
        return !this.bitmap$0 ? this.shot$lzycompute() : this.shot;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> {
            this.configureAdb((Project)project);
            this.addTasks((Project)project);
        });
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
        this.shot().configureAdbPath(adbPath);
    }

    private void addTasks(Project project) {
        block1: {
            block0: {
                if (!this.isAnAndroidProject(project)) break block0;
                this.addTasksToAppModule(project);
                break block1;
            }
            if (!this.isAnAndroidLibrary(project)) break block1;
            this.addTasksToLibraryModule(project);
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask, BaseVariant variant) {
        block0: {
            ProductFlavor flavor = variant.getMergedFlavor();
            this.checkIfApplicationIdIsConfigured(project, flavor);
            String completeAppId = new StringBuilder(5).append(flavor.getApplicationId()).append(Option$.MODULE$.apply((Object)flavor.getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(Option$.MODULE$.apply((Object)variant.getBuildType().getApplicationIdSuffix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(".test").toString();
            String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> completeAppId);
            String string = variant.getBuildType().getName();
            String string2 = "release";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.addTasksFor(project, variant.getFlavorName(), variant.getBuildType(), appTestId, baseTask);
        }
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, String flavor, BuildType buildType, String appId, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask) {
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTask = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        TaskProvider removeScreenshots = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType), RemoveScreenshotsTask.class);
        removeScreenshots.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider downloadScreenshots = tasks.register(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.configure(task -> {
            task.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider executeScreenshot = tasks.register(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.configure(task -> {
            task.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        if (extension.runInstrumentation()) {
            executeScreenshot.configure(task -> {
                task.dependsOn(new Object[]{instrumentationTask});
                task.dependsOn(new Object[]{downloadScreenshots});
                task.dependsOn(new Object[]{removeScreenshots});
            });
            downloadScreenshots.configure(task -> task.mustRunAfter(new Object[]{instrumentationTask}));
            removeScreenshots.configure(task -> task.mustRunAfter(new Object[]{downloadScreenshots}));
        }
        baseTask.configure(task -> task.dependsOn(new Object[]{executeScreenshot}));
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.getByName(Config$.MODULE$.androidDependencyMode()).extendsFrom(new Configuration[]{shotConfig});
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }
}

