/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.Files;
import com.karumi.shot.Shot;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.android.Adb;
import com.karumi.shot.base64.Base64Encoder;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.system.EnvVars;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u000b\u0017\u0001uAQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\t/\u0001A)\u0019!C\u0005\u0001\")A\t\u0001C!\u000b\")a\n\u0001C\u0005\u001f\")\u0011\u000b\u0001C\u0005%\")A\u000b\u0001C\u0005+\")q\u000b\u0001C\u00051\")!\f\u0001C\u00057\")a\u000f\u0001C\u0005o\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0002\u000b'\"|G\u000f\u00157vO&t'BA\f\u0019\u0003\u0011\u0019\bn\u001c;\u000b\u0005eQ\u0012AB6beVl\u0017NC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aD\n\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019y%M[3diB\u0019qE\f\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002,Y\u00051qM]1eY\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018)\u0005\u0019\u0001F.^4j]B\u0011q%M\u0005\u0003e!\u0012q\u0001\u0015:pU\u0016\u001cG/\u0001\u0004=S:LGO\u0010\u000b\u0002kA\u0011a\u0007A\u0007\u0002-\u000591m\u001c8t_2,W#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q2\u0012AA;j\u0013\tq4HA\u0004D_:\u001cx\u000e\\3\u0002\u0011\r|gn]8mK\u0002*\u0012!\u0011\t\u0003m\tK!a\u0011\f\u0003\tMCw\u000e^\u0001\u0006CB\u0004H.\u001f\u000b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013A!\u00168ji\")Q*\u0002a\u0001a\u00059\u0001O]8kK\u000e$\u0018\u0001D2p]\u001aLw-\u001e:f\u0003\u0012\u0014GC\u0001$Q\u0011\u0015ie\u00011\u00011\u0003!\tG\r\u001a+bg.\u001cHC\u0001$T\u0011\u0015iu\u00011\u00011\u0003]\tG\r\u001a+bg.\u001cHk\u001c'jEJ\f'/_'pIVdW\r\u0006\u0002G-\")Q\n\u0003a\u0001a\u0005\u0019\u0012\r\u001a3UCN\\7\u000fV8BaBlu\u000eZ;mKR\u0011a)\u0017\u0005\u0006\u001b&\u0001\r\u0001M\u0001\u0011C\u0012$G+Y:l)>4\u0016M]5b]R$BA\u0012/^U\")QJ\u0003a\u0001a!)aL\u0003a\u0001?\u0006A!-Y:f)\u0006\u001c8\u000eE\u0002aG\u0016l\u0011!\u0019\u0006\u0003E\"\nQ\u0001^1tWNL!\u0001Z1\u0003\u0019Q\u000b7o\u001b)s_ZLG-\u001a:\u0011\u0005\u0019DW\"A4\u000b\u0005\t4\u0012BA5h\u0005\u0011*\u00050Z2vi\u0016\u001c6M]3f]NDw\u000e\u001e+fgR\u001chi\u001c:Fm\u0016\u0014\u0018P\u00127bm>\u0014\b\"B6\u000b\u0001\u0004a\u0017a\u0002<be&\fg\u000e\u001e\t\u0003[Rl\u0011A\u001c\u0006\u0003S=T!a\u000b9\u000b\u0005E\u0014\u0018!\u00022vS2$'BA:\u001b\u0003\u001d\tg\u000e\u001a:pS\u0012L!!\u001e8\u0003\u0017\t\u000b7/\u001a,be&\fg\u000e^\u0001\u0015G>l\u0007o\\:f\u0007>l\u0007\u000f\\3uK\u0006\u0003\b/\u00133\u0015\u000ba\f9!!\u0003\u0011\u0007e\f\tA\u0004\u0002{}B\u00111\u0010S\u0007\u0002y*\u0011Q\u0010H\u0001\u0007yI|w\u000e\u001e \n\u0005}D\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u0000\u0011\")Qj\u0003a\u0001a!)1n\u0003a\u0001Y\u0006\u00013\r[3dW&3\u0017\t\u001d9mS\u000e\fG/[8o\u0013\u0012L5oQ8oM&<WO]3e)\u00151\u0015qBA\t\u0011\u0015iE\u00021\u00011\u0011\u001d\t\u0019\u0002\u0004a\u0001\u0003+\taA\u001a7bm>\u0014\b\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003?\u0011\u0018a\u00022vS2$WM]\u0005\u0005\u0003G\tIBA\u0007Qe>$Wo\u0019;GY\u00064xN]\u0001\u000eC\u0012$W\t\u001f;f]NLwN\\:\u0015\u0007\u0019\u000bI\u0003C\u0003N\u001b\u0001\u0007\u0001'A\u0006bI\u0012$\u0016m]6t\r>\u0014Hc\u0003$\u00020\u0005E\u0012\u0011HA\"\u0003\u000fBQ!\u0014\bA\u0002ABq!a\u0005\u000f\u0001\u0004\t\u0019\u0004\u0005\u0003H\u0003kA\u0018bAA\u001c\u0011\n1q\n\u001d;j_:Dq!a\u000f\u000f\u0001\u0004\ti$A\u0005ck&dG\rV=qKB!\u0011qCA \u0013\u0011\t\t%!\u0007\u0003\u0013\t+\u0018\u000e\u001c3UsB,\u0007BBA#\u001d\u0001\u0007\u00010A\u0003baBLE\rC\u0003_\u001d\u0001\u0007q,\u0001\rbI\u0012\fe\u000e\u001a:pS\u0012$Vm\u001d;EKB,g\u000eZ3oGf$2ARA'\u0011\u0015iu\u00021\u00011\u0003I\u0011XO\\%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0015\r\u0005M\u0013\u0011LA.!\r9\u0015QK\u0005\u0004\u0003/B%a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001bB\u0001\r\u0001\r\u0005\b\u0003;\u0002\u0002\u0019AA0\u0003%)\u0007\u0010^3og&|g\u000eE\u00027\u0003CJ1!a\u0019\u0017\u00055\u0019\u0006n\u001c;FqR,gn]5p]\u0006\u0011\u0012n]!o\u0003:$'o\\5e\u0019&\u0014'/\u0019:z)\u0011\t\u0019&!\u001b\t\u000b5\u000b\u0002\u0019\u0001\u0019\u0002%%\u001c\u0018I\\!oIJ|\u0017\u000e\u001a)s_*,7\r\u001e\u000b\u0005\u0003'\ny\u0007C\u0003N%\u0001\u0007\u0001'\u0001\u000ehKR\fe\u000e\u001a:pS\u0012d\u0015N\u0019:bef,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0002v\u0005u\u0004\u0003BA<\u0003sj\u0011a\\\u0005\u0004\u0003wz'\u0001\u0005'jEJ\f'/_#yi\u0016t7/[8o\u0011\u0015i5\u00031\u00011\u0003Y9W\r^!oIJ|\u0017\u000eZ!qa\u0016CH/\u001a8tS>tG\u0003BAB\u0003\u0013\u0003B!a\u001e\u0002\u0006&\u0019\u0011qQ8\u0003\u0019\u0005\u0003\b/\u0012=uK:\u001c\u0018n\u001c8\t\u000b5#\u0002\u0019\u0001\u0019")
public class ShotPlugin
implements Plugin<Project> {
    private Shot shot;
    private final Console console = new Console();
    private volatile boolean bitmap$0;

    private Console console() {
        return this.console;
    }

    private Shot shot$lzycompute() {
        ShotPlugin shotPlugin = this;
        synchronized (shotPlugin) {
            if (!this.bitmap$0) {
                this.shot = new Shot(new Adb(), new Files(), new ScreenshotsComparator(), new ScreenshotsDiffGenerator(new Base64Encoder()), new ScreenshotsSaver(), this.console(), new ExecutionReporter(), new ConsoleReporter(this.console()), new EnvVars());
                this.bitmap$0 = true;
            }
        }
        return this.shot;
    }

    private Shot shot() {
        return !this.bitmap$0 ? this.shot$lzycompute() : this.shot;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> {
            this.configureAdb((Project)project);
            this.addTasks((Project)project);
        });
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
        this.shot().configureAdbPath(adbPath);
    }

    private void addTasks(Project project) {
        block1: {
            block0: {
                if (!this.isAnAndroidProject(project)) break block0;
                this.addTasksToAppModule(project);
                break block1;
            }
            if (!this.isAnAndroidLibrary(project)) break block1;
            this.addTasksToLibraryModule(project);
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask, BaseVariant variant) {
        ProductFlavor flavor = variant.getMergedFlavor();
        this.checkIfApplicationIdIsConfigured(project, flavor);
        String completeAppId = this.composeCompleteAppId(project, variant);
        String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> completeAppId);
        None$ flavorName = new StringOps(Predef$.MODULE$.augmentString(variant.getFlavorName())).nonEmpty() ? new Some((Object)variant.getFlavorName()) : None$.MODULE$;
        this.addTasksFor(project, (Option<String>)flavorName, variant.getBuildType(), appTestId, baseTask);
    }

    private String composeCompleteAppId(Project project, BaseVariant variant) {
        String string;
        try {
            string = variant.getApplicationId();
        }
        catch (Throwable throwable) {
            this.console().showWarning("Error found trying to get applicationId from library module. We will use the extension applicationId param as a workaround.");
            this.console().showWarning("More information about this AGP7.0.1 bug can be found here: https://github.com/Karumi/Shot/issues/247");
            ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
            String extensionAppIdValue = extension.applicationId();
            this.console().showWarning(new StringBuilder(37).append("Extension applicationId value read = ").append(extensionAppIdValue).toString());
            string = extensionAppIdValue;
        }
        String appId = string;
        return new StringBuilder(5).append(appId).append(".test").toString();
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, Option<String> flavor, BuildType buildType, String appId, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask) {
        TaskProvider taskProvider;
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTaskName = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        try {
            taskProvider = tasks.named(instrumentationTaskName);
        }
        catch (Throwable e) {
            return;
        }
        TaskProvider instrumentationTaskProvider = taskProvider;
        TaskProvider removeScreenshotsAfterExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, false), RemoveScreenshotsTask.class);
        TaskProvider removeScreenshotsBeforeExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, true), RemoveScreenshotsTask.class);
        removeScreenshotsAfterExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        removeScreenshotsBeforeExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider downloadScreenshots = tasks.register(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.configure(task -> {
            task.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        TaskProvider executeScreenshot = tasks.register(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.configure(task -> {
            task.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildType_$eq(buildType);
            task.appId_$eq(appId);
        });
        if (this.runInstrumentation(project, extension)) {
            executeScreenshot.configure(task -> {
                task.dependsOn(new Object[]{instrumentationTaskProvider});
                task.dependsOn(new Object[]{downloadScreenshots});
                task.dependsOn(new Object[]{removeScreenshotsAfterExecution});
            });
            downloadScreenshots.configure(task -> task.mustRunAfter(new Object[]{instrumentationTaskProvider}));
            instrumentationTaskProvider.configure(task -> task.dependsOn(new Object[]{removeScreenshotsBeforeExecution}));
            removeScreenshotsAfterExecution.configure(task -> task.mustRunAfter(new Object[]{downloadScreenshots}));
        }
        baseTask.configure(task -> task.dependsOn(new Object[]{executeScreenshot}));
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.named(Config$.MODULE$.androidDependencyMode()).configure(config -> config.extendsFrom(new Configuration[]{shotConfig}));
    }

    private boolean runInstrumentation(Project project, ShotExtension extension) {
        String property = (String)project.findProperty("runInstrumentation");
        if (property != null) {
            if (Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(property)).toBoolean()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null) == null) {
                throw new ShotException("runInstrumentation value must be true|false", ShotException$.MODULE$.apply$default$2());
            }
            return new StringOps(Predef$.MODULE$.augmentString(property)).toBoolean();
        }
        return extension.runInstrumentation();
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }
}

