/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.Files;
import com.karumi.shot.Shot;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.android.Adb;
import com.karumi.shot.base64.Base64Encoder;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.reports.ConsoleReporter;
import com.karumi.shot.reports.ExecutionReporter;
import com.karumi.shot.screenshots.ScreenshotsComparator;
import com.karumi.shot.screenshots.ScreenshotsDiffGenerator;
import com.karumi.shot.screenshots.ScreenshotsSaver;
import com.karumi.shot.system.EnvVars;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001\u0002\f\u0018\u0001yAQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\t1\u0001A)\u0019!C\u0005\u0003\")Q\t\u0001C!\r\")q\n\u0001C\u0005!\")!\u000b\u0001C\u0005'\")Q\u000b\u0001C\u0005-\")\u0001\f\u0001C\u00053\")1\f\u0001C\u00059\")q\u000f\u0001C\u0005q\"9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0003#\u0003A\u0011BAJ\u0005)\u0019\u0006n\u001c;QYV<\u0017N\u001c\u0006\u00031e\tAa\u001d5pi*\u0011!dG\u0001\u0007W\u0006\u0014X/\\5\u000b\u0003q\t1aY8n\u0007\u0001\u00192\u0001A\u0010(!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012aa\u00142kK\u000e$\bc\u0001\u00150c5\t\u0011F\u0003\u0002+W\u0005\u0019\u0011\r]5\u000b\u00051j\u0013AB4sC\u0012dWMC\u0001/\u0003\ry'oZ\u0005\u0003a%\u0012a\u0001\u00157vO&t\u0007C\u0001\u00153\u0013\t\u0019\u0014FA\u0004Qe>TWm\u0019;\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u00059\u0012aB2p]N|G.Z\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QhF\u0001\u0003k&L!a\u0010\u001f\u0003\u000f\r{gn]8mK\u0006A1m\u001c8t_2,\u0007%F\u0001C!\t94)\u0003\u0002E/\t!1\u000b[8u\u0003\u0015\t\u0007\u000f\u001d7z)\t9U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0003V]&$\b\"\u0002(\u0006\u0001\u0004\t\u0014a\u00029s_*,7\r^\u0001\rG>tg-[4ve\u0016\fEM\u0019\u000b\u0003\u000fFCQA\u0014\u0004A\u0002E\n\u0001\"\u00193e)\u0006\u001c8n\u001d\u000b\u0003\u000fRCQAT\u0004A\u0002E\nq#\u00193e)\u0006\u001c8n\u001d+p\u0019&\u0014'/\u0019:z\u001b>$W\u000f\\3\u0015\u0005\u001d;\u0006\"\u0002(\t\u0001\u0004\t\u0014aE1eIR\u000b7o[:U_\u0006\u0003\b/T8ek2,GCA$[\u0011\u0015q\u0015\u00021\u00012\u0003A\tG\r\u001a+bg.$vNV1sS\u0006tG\u000f\u0006\u0003H;z[\u0007\"\u0002(\u000b\u0001\u0004\t\u0004\"B0\u000b\u0001\u0004\u0001\u0017\u0001\u00032bg\u0016$\u0016m]6\u0011\u0007\u0005$g-D\u0001c\u0015\t\u0019\u0017&A\u0003uCN\\7/\u0003\u0002fE\naA+Y:l!J|g/\u001b3feB\u0011q-[\u0007\u0002Q*\u00111mF\u0005\u0003U\"\u0014A%\u0012=fGV$XmU2sK\u0016t7\u000f[8u)\u0016\u001cHo\u001d$pe\u00163XM]=GY\u00064xN\u001d\u0005\u0006Y*\u0001\r!\\\u0001\bm\u0006\u0014\u0018.\u00198u!\tqW/D\u0001p\u0015\tQ\u0003O\u0003\u0002-c*\u0011!o]\u0001\u0006EVLG\u000e\u001a\u0006\u0003in\tq!\u00198ee>LG-\u0003\u0002w_\nY!)Y:f-\u0006\u0014\u0018.\u00198u\u0003Q\u0019w.\u001c9pg\u0016\u001cu.\u001c9mKR,\u0017\t\u001d9JIR)\u00110!\u0003\u0002\fA\u0019!0a\u0001\u000f\u0005m|\bC\u0001?J\u001b\u0005i(B\u0001@\u001e\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A%\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\t!\u0013\u0005\u0006\u001d.\u0001\r!\r\u0005\u0006Y.\u0001\r!\\\u0001!G\",7m[%g\u0003B\u0004H.[2bi&|g.\u00133Jg\u000e{gNZ5hkJ,G\rF\u0003H\u0003#\t\u0019\u0002C\u0003O\u0019\u0001\u0007\u0011\u0007C\u0004\u0002\u00161\u0001\r!a\u0006\u0002\r\u0019d\u0017M^8s!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tQ!\\8eK2T1!!\tt\u0003\u001d\u0011W/\u001b7eKJLA!!\n\u0002\u001c\ti\u0001K]8ek\u000e$h\t\\1w_J\fQ\"\u00193e\u000bb$XM\\:j_:\u001cHcA$\u0002,!)a*\u0004a\u0001c\u0005Y\u0011\r\u001a3UCN\\7OR8s)59\u0015\u0011GA\u001a\u0003w\t)%!\u0013\u0002T!)aJ\u0004a\u0001c!9\u0011Q\u0003\bA\u0002\u0005U\u0002\u0003\u0002%\u00028eL1!!\u000fJ\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\b\bA\u0002\u0005}\u0012!\u00032vS2$G+\u001f9f!\u0011\tI\"!\u0011\n\t\u0005\r\u00131\u0004\u0002\n\u0005VLG\u000e\u001a+za\u0016Da!a\u0012\u000f\u0001\u0004I\u0018!B1qa&#\u0007bBA&\u001d\u0001\u0007\u0011QJ\u0001\r_J\u001c\u0007.Z:ue\u0006$X\r\u001a\t\u0004\u0011\u0006=\u0013bAA)\u0013\n9!i\\8mK\u0006t\u0007\"B0\u000f\u0001\u0004\u0001\u0017\u0001G1eI\u0006sGM]8jIR+7\u000f\u001e#fa\u0016tG-\u001a8dsR\u0019q)!\u0017\t\u000b9{\u0001\u0019A\u0019\u0002%I,h.\u00138tiJ,X.\u001a8uCRLwN\u001c\u000b\u0007\u0003\u001b\ny&!\u0019\t\u000b9\u0003\u0002\u0019A\u0019\t\u000f\u0005\r\u0004\u00031\u0001\u0002f\u0005IQ\r\u001f;f]NLwN\u001c\t\u0004o\u0005\u001d\u0014bAA5/\ti1\u000b[8u\u000bb$XM\\:j_:\f!#[:B]\u0006sGM]8jI2K'M]1ssR!\u0011QJA8\u0011\u0015q\u0015\u00031\u00012\u0003II7/\u00118B]\u0012\u0014x.\u001b3Qe>TWm\u0019;\u0015\t\u00055\u0013Q\u000f\u0005\u0006\u001dJ\u0001\r!M\u0001\u001bO\u0016$\u0018I\u001c3s_&$G*\u001b2sCJLX\t\u001f;f]NLwN\u001c\u000b\u0005\u0003w\n\u0019\t\u0005\u0003\u0002~\u0005}T\"\u00019\n\u0007\u0005\u0005\u0005O\u0001\tMS\n\u0014\u0018M]=FqR,gn]5p]\")aj\u0005a\u0001c\u00051r-\u001a;B]\u0012\u0014x.\u001b3BaB,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0002\n\u0006=\u0005\u0003BA?\u0003\u0017K1!!$q\u00051\t\u0005\u000f]#yi\u0016t7/[8o\u0011\u0015qE\u00031\u00012\u0003]I7o\u0014:dQ\u0016\u001cHO]1u_J\u001cuN\u001c8fGR,G\r\u0006\u0003\u0002N\u0005U\u0005\"\u0002(\u0016\u0001\u0004\t\u0004")
public class ShotPlugin
implements Plugin<Project> {
    private Shot shot;
    private final Console console = new Console();
    private volatile boolean bitmap$0;

    private Console console() {
        return this.console;
    }

    private Shot shot$lzycompute() {
        ShotPlugin shotPlugin = this;
        synchronized (shotPlugin) {
            if (!this.bitmap$0) {
                this.shot = new Shot(new Adb(), new Files(), new ScreenshotsComparator(), new ScreenshotsDiffGenerator(new Base64Encoder()), new ScreenshotsSaver(), this.console(), new ExecutionReporter(), new ConsoleReporter(this.console()), new EnvVars());
                this.bitmap$0 = true;
            }
        }
        return this.shot;
    }

    private Shot shot() {
        return !this.bitmap$0 ? this.shot$lzycompute() : this.shot;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> {
            this.configureAdb((Project)project);
            this.addTasks((Project)project);
        });
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
        this.shot().configureAdbPath(adbPath);
    }

    private void addTasks(Project project) {
        block1: {
            block0: {
                if (!this.isAnAndroidProject(project)) break block0;
                this.addTasksToAppModule(project);
                break block1;
            }
            if (!this.isAnAndroidLibrary(project)) break block1;
            this.addTasksToLibraryModule(project);
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask, BaseVariant variant) {
        ProductFlavor flavor = variant.getMergedFlavor();
        this.checkIfApplicationIdIsConfigured(project, flavor);
        String completeAppId = this.composeCompleteAppId(project, variant);
        String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> completeAppId);
        None$ flavorName = new StringOps(Predef$.MODULE$.augmentString(variant.getFlavorName())).nonEmpty() ? new Some((Object)variant.getFlavorName()) : None$.MODULE$;
        boolean orchestrated = this.isOrchestratorConnected(project);
        this.addTasksFor(project, (Option<String>)flavorName, variant.getBuildType(), appTestId, orchestrated, baseTask);
    }

    private String composeCompleteAppId(Project project, BaseVariant variant) {
        String string;
        try {
            string = variant.getApplicationId();
        }
        catch (Throwable throwable) {
            this.console().showWarning("Error found trying to get applicationId from library module. We will use the extension applicationId param as a workaround.");
            this.console().showWarning("More information about this AGP7.0.1 bug can be found here: https://github.com/Karumi/Shot/issues/247");
            ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
            String extensionAppIdValue = extension.applicationId();
            this.console().showWarning(new StringBuilder(37).append("Extension applicationId value read = ").append(extensionAppIdValue).toString());
            string = extensionAppIdValue;
        }
        String appId = string;
        return new StringBuilder(5).append(appId).append(".test").toString();
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, Option<String> flavor, BuildType buildType, String appId, boolean orchestrated, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask) {
        TaskProvider taskProvider;
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTaskName = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        try {
            taskProvider = tasks.named(instrumentationTaskName);
        }
        catch (Throwable e) {
            return;
        }
        TaskProvider instrumentationTaskProvider = taskProvider;
        TaskProvider removeScreenshotsAfterExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, false), RemoveScreenshotsTask.class);
        TaskProvider removeScreenshotsBeforeExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, true), RemoveScreenshotsTask.class);
        removeScreenshotsAfterExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
        });
        removeScreenshotsBeforeExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
        });
        TaskProvider downloadScreenshots = tasks.register(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.configure(task -> {
            task.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
        });
        TaskProvider executeScreenshot = tasks.register(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.configure(task -> {
            task.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
        });
        if (this.runInstrumentation(project, extension)) {
            executeScreenshot.configure(task -> {
                task.dependsOn(new Object[]{instrumentationTaskProvider});
                task.dependsOn(new Object[]{downloadScreenshots});
                task.dependsOn(new Object[]{removeScreenshotsAfterExecution});
            });
            downloadScreenshots.configure(task -> task.mustRunAfter(new Object[]{instrumentationTaskProvider}));
            instrumentationTaskProvider.configure(task -> task.dependsOn(new Object[]{removeScreenshotsBeforeExecution}));
            removeScreenshotsAfterExecution.configure(task -> task.mustRunAfter(new Object[]{downloadScreenshots}));
        }
        baseTask.configure(task -> task.dependsOn(new Object[]{executeScreenshot}));
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.named(Config$.MODULE$.androidDependencyMode()).configure(config -> config.extendsFrom(new Configuration[]{shotConfig}));
    }

    private boolean runInstrumentation(Project project, ShotExtension extension) {
        String property = (String)project.findProperty("runInstrumentation");
        if (property != null) {
            if (Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(property)).toBoolean()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null) == null) {
                throw new ShotException("runInstrumentation value must be true|false", ShotException$.MODULE$.apply$default$2());
            }
            return new StringOps(Predef$.MODULE$.augmentString(property)).toBoolean();
        }
        return extension.runInstrumentation();
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }

    private boolean isOrchestratorConnected(Project project) {
        String orchestrator = "ANDROIDX_TEST_ORCHESTRATOR";
        return this.isAnAndroidProject(project) ? this.getAndroidAppExtension(project).getTestOptions().getExecution().equalsIgnoreCase(orchestrator) : (this.isAnAndroidLibrary(project) ? this.getAndroidLibraryExtension(project).getTestOptions().getExecution().equalsIgnoreCase(orchestrator) : false);
    }
}

