/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.shot;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.karumi.shot.AdbPathExtractor;
import com.karumi.shot.ShotExtension;
import com.karumi.shot.ShotExtension$;
import com.karumi.shot.domain.Config$;
import com.karumi.shot.exceptions.ShotException;
import com.karumi.shot.exceptions.ShotException$;
import com.karumi.shot.tasks.DownloadScreenshotsTask;
import com.karumi.shot.tasks.DownloadScreenshotsTask$;
import com.karumi.shot.tasks.ExecuteScreenshotTests;
import com.karumi.shot.tasks.ExecuteScreenshotTests$;
import com.karumi.shot.tasks.ExecuteScreenshotTestsForEveryFlavor;
import com.karumi.shot.tasks.RemoveScreenshotsTask;
import com.karumi.shot.tasks.RemoveScreenshotsTask$;
import com.karumi.shot.ui.Console;
import java.io.Serializable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001\u0002\f\u0018\u0001yAQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u00069\u0002!I!\u0018\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006E\u0002!Ia\u0019\u0005\u0006K\u0002!IA\u001a\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002,\u0001!I!!\f\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\u0010\u0002!I!!%\u0003\u0015MCw\u000e\u001e)mk\u001eLgN\u0003\u0002\u00193\u0005!1\u000f[8u\u0015\tQ2$\u0001\u0004lCJ,X.\u001b\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0014\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001\u00027b]\u001eT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\t1qJ\u00196fGR\u00042\u0001K\u00182\u001b\u0005I#B\u0001\u0016,\u0003\r\t\u0007/\u001b\u0006\u0003Y5\naa\u001a:bI2,'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021S\t1\u0001\u000b\\;hS:\u0004\"\u0001\u000b\u001a\n\u0005MJ#a\u0002)s_*,7\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003]\tqaY8og>dW-F\u0001;!\tYd(D\u0001=\u0015\tit#\u0001\u0002vS&\u0011q\b\u0010\u0002\b\u0007>t7o\u001c7f\u0003!\u0019wN\\:pY\u0016\u0004\u0013!B1qa2LHCA\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0011)f.\u001b;\t\u000b)#\u0001\u0019A\u0019\u0002\u000fA\u0014xN[3di\u0006a1m\u001c8gS\u001e,(/Z!eER\u00111)\u0014\u0005\u0006\u0015\u0016\u0001\r!M\u0001\fM&tG-\u00113c!\u0006$\b\u000e\u0006\u0002Q7B\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"aU#\u000e\u0003QS!!V\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9V)\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,F\u0011\u0015Qe\u00011\u00012\u0003!\tG\r\u001a+bg.\u001cHCA\"_\u0011\u0015Qu\u00011\u00012\u0003]\tG\r\u001a+bg.\u001cHk\u001c'jEJ\f'/_'pIVdW\r\u0006\u0002DC\")!\n\u0003a\u0001c\u0005\u0019\u0012\r\u001a3UCN\\7\u000fV8BaBlu\u000eZ;mKR\u00111\t\u001a\u0005\u0006\u0015&\u0001\r!M\u0001\u0011C\u0012$G+Y:l)>4\u0016M]5b]R$BaQ4ik\")!J\u0003a\u0001c!)\u0011N\u0003a\u0001U\u0006A!-Y:f)\u0006\u001c8\u000eE\u0002l]Bl\u0011\u0001\u001c\u0006\u0003[&\nQ\u0001^1tWNL!a\u001c7\u0003\u0019Q\u000b7o\u001b)s_ZLG-\u001a:\u0011\u0005E\u001cX\"\u0001:\u000b\u00055<\u0012B\u0001;s\u0005\u0011*\u00050Z2vi\u0016\u001c6M]3f]NDw\u000e\u001e+fgR\u001chi\u001c:Fm\u0016\u0014\u0018P\u00127bm>\u0014\b\"\u0002<\u000b\u0001\u00049\u0018a\u0002<be&\fg\u000e\u001e\t\u0003q~l\u0011!\u001f\u0006\u0003UiT!\u0001L>\u000b\u0005ql\u0018!\u00022vS2$'B\u0001@\u001c\u0003\u001d\tg\u000e\u001a:pS\u0012L1!!\u0001z\u0005-\u0011\u0015m]3WCJL\u0017M\u001c;\u0002)\r|W\u000e]8tK\u000e{W\u000e\u001d7fi\u0016\f\u0005\u000f]%e)\u0015\u0001\u0016qAA\u0005\u0011\u0015Q5\u00021\u00012\u0011\u001518\u00021\u0001x\u0003\u0001\u001a\u0007.Z2l\u0013\u001a\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI&\u001b8i\u001c8gS\u001e,(/\u001a3\u0015\u000b\r\u000by!!\u0005\t\u000b)c\u0001\u0019A\u0019\t\u000f\u0005MA\u00021\u0001\u0002\u0016\u00051a\r\\1w_J\u0004B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0003n_\u0012,GNC\u0002\u0002 u\fqAY;jY\u0012,'/\u0003\u0003\u0002$\u0005e!!\u0004)s_\u0012,8\r\u001e$mCZ|'/A\u0007bI\u0012,\u0005\u0010^3og&|gn\u001d\u000b\u0004\u0007\u0006%\u0002\"\u0002&\u000e\u0001\u0004\t\u0014aC1eIR\u000b7o[:G_J$RbQA\u0018\u0003c\tI$a\u0011\u0002H\u0005E\u0003\"\u0002&\u000f\u0001\u0004\t\u0004bBA\n\u001d\u0001\u0007\u00111\u0007\t\u0005\t\u0006U\u0002+C\u0002\u00028\u0015\u0013aa\u00149uS>t\u0007bBA\u001e\u001d\u0001\u0007\u0011QH\u0001\nEVLG\u000e\u001a+za\u0016\u0004B!a\u0006\u0002@%!\u0011\u0011IA\r\u0005%\u0011U/\u001b7e)f\u0004X\r\u0003\u0004\u0002F9\u0001\r\u0001U\u0001\u0006CB\u0004\u0018\n\u001a\u0005\b\u0003\u0013r\u0001\u0019AA&\u00031y'o\u00195fgR\u0014\u0018\r^3e!\r!\u0015QJ\u0005\u0004\u0003\u001f*%a\u0002\"p_2,\u0017M\u001c\u0005\u0006S:\u0001\rA[\u0001\u0019C\u0012$\u0017I\u001c3s_&$G+Z:u\t\u0016\u0004XM\u001c3f]\u000eLHcA\"\u0002X!)!j\u0004a\u0001c\u0005\u0011\"/\u001e8J]N$(/^7f]R\fG/[8o)\u0019\tY%!\u0018\u0002`!)!\n\u0005a\u0001c!9\u0011\u0011\r\tA\u0002\u0005\r\u0014!C3yi\u0016t7/[8o!\r9\u0014QM\u0005\u0004\u0003O:\"!D*i_R,\u0005\u0010^3og&|g.\u0001\njg\u0006s\u0017I\u001c3s_&$G*\u001b2sCJLH\u0003BA&\u0003[BQAS\tA\u0002E\n!#[:B]\u0006sGM]8jIB\u0013xN[3diR!\u00111JA:\u0011\u0015Q%\u00031\u00012\u0003i9W\r^!oIJ|\u0017\u000e\u001a'jEJ\f'/_#yi\u0016t7/[8o)\u0011\tI(!!\u0011\t\u0005m\u0014QP\u0007\u0002u&\u0019\u0011q\u0010>\u0003!1K'M]1ss\u0016CH/\u001a8tS>t\u0007\"\u0002&\u0014\u0001\u0004\t\u0014AF4fi\u0006sGM]8jI\u0006\u0003\b/\u0012=uK:\u001c\u0018n\u001c8\u0015\t\u0005\u001d\u0015Q\u0012\t\u0005\u0003w\nI)C\u0002\u0002\fj\u0014A\"\u00119q\u000bb$XM\\:j_:DQA\u0013\u000bA\u0002E\nq#[:Pe\u000eDWm\u001d;sCR|'oQ8o]\u0016\u001cG/\u001a3\u0015\t\u0005-\u00131\u0013\u0005\u0006\u0015V\u0001\r!\r")
public class ShotPlugin
implements Plugin<Project> {
    private final Console console = new Console();

    private Console console() {
        return this.console;
    }

    public void apply(Project project2) {
        this.addExtensions(project2);
        this.addAndroidTestDependency(project2);
        project2.afterEvaluate(project -> this.addTasks((Project)project));
    }

    private void configureAdb(Project project) {
        String adbPath = AdbPathExtractor.extractPath(project);
    }

    private String findAdbPath(Project project) {
        return AdbPathExtractor.extractPath(project);
    }

    private void addTasks(Project project) {
        if (this.isAnAndroidProject(project)) {
            this.addTasksToAppModule(project);
            return;
        }
        if (this.isAnAndroidLibrary(project)) {
            this.addTasksToLibraryModule(project);
            return;
        }
    }

    private void addTasksToLibraryModule(Project project) {
        LibraryExtension libraryExtension = this.getAndroidLibraryExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        libraryExtension.getLibraryVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTasksToAppModule(Project project) {
        AppExtension appExtension = this.getAndroidAppExtension(project);
        TaskProvider baseTask = project.getTasks().register(Config$.MODULE$.defaultTaskName(), ExecuteScreenshotTestsForEveryFlavor.class);
        appExtension.getApplicationVariants().all(variant -> this.addTaskToVariant(project, (TaskProvider<ExecuteScreenshotTestsForEveryFlavor>)baseTask, (BaseVariant)variant));
    }

    private void addTaskToVariant(Project project, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask, BaseVariant variant) {
        ProductFlavor flavor = variant.getMergedFlavor();
        this.checkIfApplicationIdIsConfigured(project, flavor);
        String completeAppId = this.composeCompleteAppId(project, variant);
        String appTestId = (String)Option$.MODULE$.apply((Object)flavor.getTestApplicationId()).getOrElse((Function0 & Serializable)() -> completeAppId);
        None$ flavorName = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(variant.getFlavorName())) ? new Some((Object)variant.getFlavorName()) : None$.MODULE$;
        boolean orchestrated = this.isOrchestratorConnected(project);
        this.addTasksFor(project, (Option<String>)flavorName, variant.getBuildType(), appTestId, orchestrated, baseTask);
    }

    private String composeCompleteAppId(Project project, BaseVariant variant) {
        String string;
        try {
            string = variant.getApplicationId();
        }
        catch (Throwable throwable) {
            this.console().showWarning("Error found trying to get applicationId from library module. We will use the extension applicationId param as a workaround.");
            this.console().showWarning("More information about this AGP7.0.1 bug can be found here: https://github.com/Karumi/Shot/issues/247");
            ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
            String extensionAppIdValue = extension.applicationId();
            this.console().showWarning(new StringBuilder(37).append("Extension applicationId value read = ").append(extensionAppIdValue).toString());
            string = extensionAppIdValue;
        }
        String appId = string;
        return new StringBuilder(5).append(appId).append(".test").toString();
    }

    private void checkIfApplicationIdIsConfigured(Project project, ProductFlavor flavor) {
        if (this.isAnAndroidLibrary(project) && flavor.getTestApplicationId() == null) {
            throw new ShotException("Your Android library needs to be configured using an testApplicationId in your build.gradle defaultConfig block.", ShotException$.MODULE$.apply$default$2());
        }
    }

    private void addExtensions(Project project) {
        String name = ShotExtension$.MODULE$.name();
        project.getExtensions().add(name, (Object)new ShotExtension());
    }

    private void addTasksFor(Project project, Option<String> flavor, BuildType buildType, String appId, boolean orchestrated, TaskProvider<ExecuteScreenshotTestsForEveryFlavor> baseTask) {
        TaskProvider taskProvider;
        ShotExtension extension = (ShotExtension)project.getExtensions().getByType(ShotExtension.class);
        String instrumentationTaskName = extension.useComposer() ? Config$.MODULE$.composerInstrumentationTestTask(flavor, buildType.getName()) : Config$.MODULE$.defaultInstrumentationTestTask(flavor, buildType.getName());
        TaskContainer tasks = project.getTasks();
        try {
            taskProvider = tasks.named(instrumentationTaskName);
        }
        catch (Throwable e) {
            return;
        }
        TaskProvider instrumentationTaskProvider = taskProvider;
        TaskProvider removeScreenshotsAfterExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, false), RemoveScreenshotsTask.class);
        TaskProvider removeScreenshotsBeforeExecution = tasks.register(RemoveScreenshotsTask$.MODULE$.name(flavor, buildType, true), RemoveScreenshotsTask.class);
        String adbPath = this.findAdbPath(project);
        removeScreenshotsAfterExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
            task.adbPath_$eq(adbPath);
        });
        removeScreenshotsBeforeExecution.configure(task -> {
            task.setDescription(RemoveScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
            task.adbPath_$eq(adbPath);
        });
        TaskProvider downloadScreenshots = tasks.register(DownloadScreenshotsTask$.MODULE$.name(flavor, buildType), DownloadScreenshotsTask.class);
        downloadScreenshots.configure(task -> {
            task.setDescription(DownloadScreenshotsTask$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
            task.adbPath_$eq(adbPath);
        });
        TaskProvider executeScreenshot = tasks.register(ExecuteScreenshotTests$.MODULE$.name(flavor, buildType), ExecuteScreenshotTests.class);
        executeScreenshot.configure(task -> {
            task.setDescription(ExecuteScreenshotTests$.MODULE$.description(flavor, buildType));
            task.flavor_$eq(flavor);
            task.buildTypeName_$eq(buildType.getName());
            task.appId_$eq(appId);
            task.orchestrated_$eq(orchestrated);
            task.projectPath_$eq(project.getProjectDir().getAbsolutePath());
            task.buildPath_$eq(project.getBuildDir().getAbsolutePath());
            task.shotExtension_$eq((ShotExtension)project.getExtensions().findByType(ShotExtension.class));
            task.directorySuffix_$eq((Option<String>)(project.hasProperty("directorySuffix") ? new Some((Object)project.property("directorySuffix").toString()) : None$.MODULE$));
            task.recordScreenshots_$eq(project.hasProperty("record"));
            task.printBase64_$eq(project.hasProperty("printBase64"));
            task.projectName_$eq(project.getName());
            task.adbPath_$eq(adbPath);
        });
        if (this.runInstrumentation(project, extension)) {
            executeScreenshot.configure(task -> {
                task.dependsOn(new Object[]{instrumentationTaskProvider});
                task.dependsOn(new Object[]{downloadScreenshots});
                task.dependsOn(new Object[]{removeScreenshotsAfterExecution});
            });
            downloadScreenshots.configure(task -> task.mustRunAfter(new Object[]{instrumentationTaskProvider}));
            instrumentationTaskProvider.configure(task -> task.dependsOn(new Object[]{removeScreenshotsBeforeExecution}));
            removeScreenshotsAfterExecution.configure(task -> task.mustRunAfter(new Object[]{downloadScreenshots}));
        }
        baseTask.configure(task -> task.dependsOn(new Object[]{executeScreenshot}));
    }

    private void addAndroidTestDependency(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration shotConfig = (Configuration)configs.create(Config$.MODULE$.shotConfiguration());
        shotConfig.defaultDependencies(dependencies -> {
            String dependencyName = Config$.MODULE$.androidDependency();
            Dependency dependencyToAdd = project.getDependencies().create((Object)dependencyName);
            dependencies.add((Object)dependencyToAdd);
        });
        configs.named(Config$.MODULE$.androidDependencyMode()).configure(config -> config.extendsFrom(new Configuration[]{shotConfig}));
    }

    private boolean runInstrumentation(Project project, ShotExtension extension) {
        String property = (String)project.findProperty("runInstrumentation");
        if (property != null) {
            if (Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(property))).getOrElse((Function0 & Serializable)() -> null) == null) {
                throw new ShotException("runInstrumentation value must be true|false", ShotException$.MODULE$.apply$default$2());
            }
            return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(property));
        }
        return extension.runInstrumentation();
    }

    private boolean isAnAndroidLibrary(Project project) {
        boolean bl;
        try {
            this.getAndroidLibraryExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private boolean isAnAndroidProject(Project project) {
        boolean bl;
        try {
            this.getAndroidAppExtension(project);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private LibraryExtension getAndroidLibraryExtension(Project project) {
        return (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
    }

    private AppExtension getAndroidAppExtension(Project project) {
        return (AppExtension)project.getExtensions().getByType(AppExtension.class);
    }

    private boolean isOrchestratorConnected(Project project) {
        String orchestrator = "ANDROIDX_TEST_ORCHESTRATOR";
        if (this.isAnAndroidProject(project)) {
            return this.getAndroidAppExtension(project).getTestOptions().getExecution().equalsIgnoreCase(orchestrator);
        }
        if (this.isAnAndroidLibrary(project)) {
            return this.getAndroidLibraryExtension(project).getTestOptions().getExecution().equalsIgnoreCase(orchestrator);
        }
        return false;
    }
}

