/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary;

import com.karuslabs.elementary.Diagnostics;
import com.karuslabs.elementary.Results;
import com.karuslabs.elementary.file.MemoryFileManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Compiler {
    private static final ClassLoader PLATFORM = ClassLoader.getPlatformClassLoader();
    private static final ClassLoader APPLICATION = ClassLoader.getSystemClassLoader();
    private final JavaCompiler compiler;
    private final List<Processor> processors = new ArrayList<Processor>();
    private final List<String> options = new ArrayList<String>();
    @Nullable Set<File> classpath;

    public static Compiler javac() {
        return new Compiler(ToolProvider.getSystemJavaCompiler());
    }

    Compiler(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    public Results compile(JavaFileObject ... files) {
        return this.compile(List.of(files));
    }

    public Results compile(Iterable<? extends JavaFileObject> files) {
        Diagnostics diagnostics = new Diagnostics();
        MemoryFileManager manager = new MemoryFileManager(this.compiler.getStandardFileManager(diagnostics, Locale.getDefault(), StandardCharsets.UTF_8));
        if (this.classpath != null) {
            this.setLocation(manager, StandardLocation.CLASS_PATH, this.classpath);
        }
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, manager, diagnostics, this.options, null, files);
        task.setProcessors(this.processors);
        Boolean success = task.call();
        return new Results(manager.outputFiles(), manager.generatedSources(), diagnostics, success);
    }

    void setLocation(StandardJavaFileManager manager, StandardLocation location, Iterable<File> paths) {
        try {
            manager.setLocation(location, paths);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Compiler processors(Processor ... processors) {
        Collections.addAll(this.processors, processors);
        return this;
    }

    public Compiler processors(Collection<Processor> processors) {
        this.processors.addAll(processors);
        return this;
    }

    public Compiler options(String ... options) {
        Collections.addAll(this.options, options);
        return this;
    }

    public Compiler options(Collection<String> options) {
        this.options.addAll(options);
        return this;
    }

    public Compiler module(Module module) {
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            return this;
        }
        for (ResolvedModule resolved : layer.configuration().modules()) {
            URI location = resolved.reference().location().orElseThrow(() -> new IllegalStateException("Could not find location for module: " + resolved.name()));
            this.classpath().add(new File(location.getPath()));
        }
        return this;
    }

    public Compiler currentClasspath() {
        return this.classpath(this.getClass().getClassLoader());
    }

    public Compiler classpath(ClassLoader loader) {
        HashSet<String> paths = new HashSet<String>();
        while (loader != null && loader != PLATFORM) {
            if (loader == APPLICATION) {
                Collections.addAll(paths, System.getProperty("java.class.path").split(System.getProperty("path.separator")));
                break;
            }
            if (!(loader instanceof URLClassLoader)) {
                throw new IllegalArgumentException("Given ClassLoader and its parents must be a URLClassLoader");
            }
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!url.getProtocol().equals("file")) {
                    throw new IllegalArgumentException("Given ClassLoader and its parents may not contain classpaths that consist of folders");
                }
                paths.add(url.getPath());
            }
            loader = loader.getParent();
        }
        this.classpath().addAll(paths.stream().map(File::new).collect(Collectors.toSet()));
        return this;
    }

    public Compiler classpath(Collection<File> files) {
        this.classpath().addAll(files);
        return this;
    }

    Set<File> classpath() {
        if (this.classpath == null) {
            this.classpath = new HashSet<File>();
        }
        return this.classpath;
    }
}

