/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.file;

import com.karuslabs.elementary.file.ByteFileObject;
import com.karuslabs.elementary.file.StringFileObject;
import com.karuslabs.elementary.junit.annotations.Classpath;
import com.karuslabs.elementary.junit.annotations.Inline;
import com.karuslabs.elementary.junit.annotations.Introspect;
import com.karuslabs.elementary.junit.annotations.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;

public class FileObjects {
    public static final JavaFileObject DUMMY = FileObjects.ofLines("Dummy", "class Dummy {}");

    public static List<JavaFileObject> scan(Class<?> annotated) {
        List<JavaFileObject> files = FileObjects.scan(annotated);
        Introspect introspect = annotated.getAnnotation(Introspect.class);
        if (introspect != null) {
            Class<?> host = annotated.getNestHost();
            String file = introspect.value().equals("${TRACE_ENCLOSING_CLASS}") ? host.getName() : host.getPackageName() + "." + introspect.value();
            files.add(FileObjects.ofClass(file));
        }
        return files;
    }

    public static List<JavaFileObject> scan(AnnotatedElement annotated) {
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        for (Classpath classpath : (Classpath[])annotated.getAnnotationsByType(Classpath.class)) {
            files.add(FileObjects.ofClass(classpath.value()));
        }
        for (Annotation annotation : (Resource[])annotated.getAnnotationsByType(Resource.class)) {
            files.add(FileObjects.ofResource(annotation.value()));
        }
        for (Annotation annotation : (Inline[])annotated.getAnnotationsByType(Inline.class)) {
            files.add(FileObjects.ofLines(annotation.name(), annotation.source()));
        }
        return files;
    }

    public static JavaFileObject ofLines(String fullyQualifiedName, String ... lines) {
        return FileObjects.ofLines(fullyQualifiedName, String.join((CharSequence)System.lineSeparator(), lines));
    }

    public static JavaFileObject ofLines(String fullyQualifiedName, Iterable<String> lines) {
        return FileObjects.ofLines(fullyQualifiedName, String.join((CharSequence)System.lineSeparator(), lines));
    }

    public static JavaFileObject ofLines(String fullyQualifiedName, String source) {
        return new StringFileObject(URI.create(fullyQualifiedName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE, source);
    }

    public static JavaFileObject ofClass(String fullyQualifiedName) {
        return FileObjects.ofResource(fullyQualifiedName.replace('.', '/') + ".java");
    }

    public static JavaFileObject ofResource(String resource) {
        URL url = FileObjects.class.getClassLoader().getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("\"" + resource + "\" does not exist on the current classpath");
        }
        return FileObjects.ofResource(url);
    }

    public static JavaFileObject ofResource(URL resource) {
        ByteFileObject byteFileObject;
        block9: {
            InputStream stream = resource.openStream();
            try {
                URI uri = FileObjects.uri(resource);
                byteFileObject = new ByteFileObject(uri, FileObjects.deduce(uri), stream.readAllBytes());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            stream.close();
        }
        return byteFileObject;
    }

    static URI uri(URL resource) throws URISyntaxException {
        if (!resource.getProtocol().equals("jar")) {
            return resource.toURI();
        }
        return URI.create(resource.getPath().split("!")[1]);
    }

    public static JavaFileObject.Kind deduce(URI uri) {
        String path = uri.getPath();
        for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (!path.endsWith(kind.extension)) continue;
            return kind;
        }
        return null;
    }
}

