/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.file;

import com.karuslabs.elementary.file.ForwardingFileManager;
import com.karuslabs.elementary.file.MemoryFileObject;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MemoryFileManager
extends ForwardingFileManager {
    private final Map<URI, JavaFileObject> files = new HashMap<URI, JavaFileObject>();

    static URI of(JavaFileManager.Location location, String pack, String relative) {
        return URI.create("mem:///" + URLEncoder.encode(location.getName(), StandardCharsets.UTF_8) + "/" + (String)(pack.isEmpty() ? "" : pack.replace('.', '/') + "/") + relative);
    }

    static URI of(JavaFileManager.Location location, String type, JavaFileObject.Kind kind) {
        return URI.create("mem:///" + URLEncoder.encode(location.getName(), StandardCharsets.UTF_8) + "/" + type.replace('.', '/') + kind.extension);
    }

    public MemoryFileManager(StandardJavaFileManager manager) {
        super(manager);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public @Nullable FileObject getFileForInput(JavaFileManager.Location location, String pack, String relative) throws IOException {
        if (location.isOutputLocation()) {
            return this.files.get(MemoryFileManager.of(location, pack, relative));
        }
        return super.getFileForInput(location, pack, relative);
    }

    @Override
    public @Nullable JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String type, JavaFileObject.Kind kind) throws IOException {
        if (location.isOutputLocation()) {
            return this.files.get(MemoryFileManager.of(location, type, kind));
        }
        return super.getJavaFileForInput(location, type, kind);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String pack, String relative, FileObject sibling) {
        return this.files.computeIfAbsent(MemoryFileManager.of(location, pack, relative), MemoryFileObject::new);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String type, JavaFileObject.Kind kind, FileObject sibling) {
        return this.files.computeIfAbsent(MemoryFileManager.of(location, type, kind), MemoryFileObject::new);
    }

    public List<JavaFileObject> generatedSources() {
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        String prefix = "/" + StandardLocation.SOURCE_OUTPUT.name();
        for (Map.Entry<URI, JavaFileObject> entry : this.files.entrySet()) {
            if (!entry.getKey().getPath().startsWith(prefix) || entry.getValue().getKind() != JavaFileObject.Kind.SOURCE) continue;
            sources.add(entry.getValue());
        }
        return sources;
    }

    public List<JavaFileObject> outputFiles() {
        return new ArrayList<JavaFileObject>(this.files.values());
    }
}

