/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.file;

import com.karuslabs.elementary.file.ByteFileObject;
import com.karuslabs.elementary.file.FileObjects;
import com.karuslabs.elementary.file.ImmutableFileObject;
import com.karuslabs.elementary.file.StringFileObject;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.tools.SimpleJavaFileObject;
import org.checkerframework.checker.nullness.qual.Nullable;

class MemoryFileObject
extends SimpleJavaFileObject {
    @Nullable ImmutableFileObject source;

    MemoryFileObject(URI uri) {
        super(uri, FileObjects.deduce(uri));
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return this.source().openInputStream();
    }

    @Override
    public OutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                MemoryFileObject.this.source = new ByteFileObject(MemoryFileObject.this.uri, MemoryFileObject.this.kind, this.toByteArray());
            }
        };
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws FileNotFoundException {
        return this.source().openReader(ignoreEncodingErrors);
    }

    @Override
    public Writer openWriter() {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                MemoryFileObject.this.source = new StringFileObject(MemoryFileObject.this.uri, MemoryFileObject.this.kind, this.toString());
            }
        };
    }

    @Override
    public boolean delete() {
        this.source = null;
        return true;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws FileNotFoundException {
        return this.source().getCharContent(ignoreEncodingErrors);
    }

    @Override
    public long getLastModified() {
        return this.source == null ? 0L : this.source.timestamp;
    }

    ImmutableFileObject source() throws FileNotFoundException {
        if (this.source != null) {
            return this.source;
        }
        throw new FileNotFoundException();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{uri = " + this.toUri() + ", kind = " + this.kind + "}";
    }
}

