/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.junit.DaemonCompiler;
import com.karuslabs.elementary.junit.Tools;
import com.karuslabs.elementary.junit.annotations.Inline;
import com.karuslabs.elementary.junit.annotations.Resource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;

abstract class Daemon
implements TestInstanceFactory,
InvocationInterceptor,
AfterAllCallback {
    private static final String PARALLEL = "junit.jupiter.execution.parallel.enabled";
    private static final String PARALLEL_CLASS_MODE = "junit.jupiter.execution.parallel.mode.classes.default";
    private static final String PARALLEL_METHOD_MODE = "junit.jupiter.execution.parallel.mode.default";
    private static final String COMPILER = "tools.extension.compiler";

    Daemon() {
    }

    public Object createTestInstance(TestInstanceFactoryContext factory, ExtensionContext context) throws TestInstantiationException {
        Constructor<?>[] constructors = context.getRequiredTestClass().getDeclaredConstructors();
        if (constructors.length != 1) {
            throw new TestInstantiationException("Test class contains " + constructors.length + " constructors, should contain only 1");
        }
        if (this.parallel(context)) {
            throw new UnsupportedOperationException("ToolsExtension currently does not support parallel test execution");
        }
        return this.create(constructors[0], this.initialize(context));
    }

    abstract Object create(Constructor var1, DaemonCompiler.Environment var2) throws TestInstantiationException;

    DaemonCompiler.Environment initialize(ExtensionContext context) {
        DaemonCompiler.Environment environment;
        DaemonCompiler compiler = this.compiler(context);
        if (compiler == null) {
            compiler = DaemonCompiler.of(context.getRequiredTestClass());
            compiler.start();
            context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestClass()})).put((Object)COMPILER, (Object)compiler);
        }
        Tools.environment = environment = compiler.environment();
        return environment;
    }

    private boolean parallel(ExtensionContext context) {
        return context.getConfigurationParameter(PARALLEL).orElse("").equalsIgnoreCase("true") && (context.getConfigurationParameter(PARALLEL_CLASS_MODE).orElse("").equalsIgnoreCase("concurrent") || context.getConfigurationParameter(PARALLEL_METHOD_MODE).orElse("").equalsIgnoreCase("concurrent"));
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> method, ExtensionContext context) throws Throwable {
        Method executable = (Method)method.getExecutable();
        if (((Resource[])executable.getAnnotationsByType(Resource.class)).length > 0 || ((Inline[])executable.getAnnotationsByType(Inline.class)).length > 0) {
            throw new IllegalArgumentException("Method cannot be annotated with @Classpath, @Inline or @Resource when using ToolsExtension");
        }
        invocation.proceed();
    }

    public void afterAll(ExtensionContext context) {
        this.compiler(context).shutdown();
        Tools.environment = null;
    }

    @Nullable DaemonCompiler compiler(ExtensionContext context) {
        return (DaemonCompiler)context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestClass()})).get((Object)COMPILER, DaemonCompiler.class);
    }
}

