/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.Compiler;
import com.karuslabs.elementary.Results;
import com.karuslabs.elementary.file.FileObjects;
import com.karuslabs.elementary.junit.annotations.Options;
import com.karuslabs.elementary.junit.annotations.Processors;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileObject;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class JavacExtension
implements ParameterResolver {
    private static final String[] EMPTY = new String[0];

    public Object resolveParameter(ParameterContext parameter, ExtensionContext context) throws ParameterResolutionException {
        Class type = context.getRequiredTestClass();
        Executable executable = parameter.getDeclaringExecutable();
        Compiler compiler = Compiler.javac();
        this.resolve(compiler, type);
        this.resolve(compiler, executable);
        List<JavaFileObject> files = FileObjects.scan(type);
        files.addAll(FileObjects.scan(executable));
        return compiler.currentClasspath().compile(files);
    }

    void resolve(Compiler compiler, AnnotatedElement annotated) {
        Options flags = annotated.getAnnotation(Options.class);
        compiler.options(flags == null ? EMPTY : flags.value().split(" "));
        ArrayList<Processor> processors = new ArrayList<Processor>();
        Processors annotation = annotated.getAnnotation(Processors.class);
        if (annotation != null) {
            for (Class<? extends Processor> type : annotation.value()) {
                try {
                    Constructor<? extends Processor> constructor = type.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    processors.add(constructor.newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    throw new ParameterResolutionException("Failed to create \"" + type.getName() + "\", annotation processor should have a constructor with no arguments", (Throwable)e);
                }
            }
        }
        compiler.processors(processors);
    }

    public boolean supportsParameter(ParameterContext parameter, ExtensionContext context) {
        return parameter.getParameter().getType() == Results.class;
    }
}

