/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.type;

import com.karuslabs.utilitary.Texts;
import com.karuslabs.utilitary.type.QualifiedTypePrinter;
import com.karuslabs.utilitary.type.SimpleTypePrinter;
import com.karuslabs.utilitary.type.TypeMirrors;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor9;

public abstract class TypePrinter
extends SimpleTypeVisitor9<Void, StringBuilder> {
    private final Set<TypeMirror> visited = new HashSet<TypeMirror>();

    public static String qualified(TypeMirror type) {
        StringBuilder builder = new StringBuilder();
        type.accept(TypePrinter.qualified(), builder);
        return builder.toString();
    }

    public static final TypePrinter qualified() {
        return new QualifiedTypePrinter();
    }

    public static String simple(TypeMirror type) {
        StringBuilder builder = new StringBuilder();
        type.accept(TypePrinter.simple(), builder);
        return builder.toString();
    }

    public static TypePrinter simple() {
        return new SimpleTypePrinter();
    }

    @Override
    public Void visitDeclared(DeclaredType type, StringBuilder builder) {
        this.rawType(type, builder);
        List<? extends TypeMirror> arguments = type.getTypeArguments();
        if (!arguments.isEmpty()) {
            builder.append('<');
            for (int i = 0; i < arguments.size() - 1; ++i) {
                arguments.get(i).accept(this, builder);
                builder.append(", ");
            }
            arguments.get(arguments.size() - 1).accept(this, builder);
            builder.append('>');
        }
        return null;
    }

    @Override
    public Void visitTypeVariable(TypeVariable variable, StringBuilder builder) {
        builder.append(variable.asElement().getSimpleName());
        if (!this.visited.add(variable)) {
            return null;
        }
        TypeMirror upper = variable.getUpperBound();
        if (!TypeMirrors.is(upper, Object.class)) {
            upper.accept(this, builder.append(" extends "));
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardType type, StringBuilder builder) {
        TypeMirror superBound;
        builder.append('?');
        TypeMirror extension = type.getExtendsBound();
        if (extension != null) {
            extension.accept(this, builder.append(" extends "));
        }
        if ((superBound = type.getSuperBound()) != null) {
            superBound.accept(this, builder.append(" super "));
        }
        return null;
    }

    @Override
    public Void visitIntersection(IntersectionType intersection, StringBuilder builder) {
        Texts.join(builder, intersection.getBounds(), (bound, sb) -> bound.accept(this, builder), " & ");
        return null;
    }

    @Override
    public Void visitArray(ArrayType type, StringBuilder builder) {
        type.getComponentType().accept(this, builder);
        builder.append("[]");
        return null;
    }

    @Override
    public Void visitPrimitive(PrimitiveType type, StringBuilder builder) {
        builder.append(type.getKind().toString().toLowerCase());
        return null;
    }

    @Override
    public Void visitNoType(NoType type, StringBuilder builder) {
        builder.append("void");
        return null;
    }

    @Override
    protected Void defaultAction(TypeMirror type, StringBuilder builder) {
        builder.setLength(0);
        throw new UnsupportedOperationException("TypePrinter does not support " + type.getKind());
    }

    protected abstract void rawType(DeclaredType var1, StringBuilder var2);
}

