/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.common.log.filterlog;

import com.kaspersky.adbserver.common.log.filterlog.LogData;
import com.kaspersky.adbserver.common.log.filterlog.LogRecorder;
import com.kaspersky.adbserver.common.log.filterlog.ReadyRecord;
import com.kaspersky.adbserver.common.log.filterlog.RecordAnswer;
import com.kaspersky.adbserver.common.log.filterlog.RecordInProgress;
import com.kaspersky.adbserver.common.log.fulllogger.FullLogger;
import com.kaspersky.adbserver.common.log.logger.LogLevel;
import com.kaspersky.adbserver.common.log.utils.AdbLoggerReflection;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J0\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/kaspersky/adbserver/common/log/filterlog/FullLoggerOptimiser;", "Lcom/kaspersky/adbserver/common/log/fulllogger/FullLogger;", "originalFullLogger", "generateLogs", "", "recordingStackMaxSize", "", "(Lcom/kaspersky/adbserver/common/log/fulllogger/FullLogger;ZI)V", "logRecorder", "Lcom/kaspersky/adbserver/common/log/filterlog/LogRecorder;", "logStack", "Ljava/util/Deque;", "Lcom/kaspersky/adbserver/common/log/filterlog/LogData;", "handleLog", "", "key", "", "logLevel", "Lcom/kaspersky/adbserver/common/log/logger/LogLevel;", "action", "Lkotlin/Function0;", "log", "tag", "method", "text", "outputRecord", "readyRecord", "Lcom/kaspersky/adbserver/common/log/filterlog/ReadyRecord;", "updateState", "Companion", "adbserver-common"})
public final class FullLoggerOptimiser
implements FullLogger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FullLogger originalFullLogger;
    private final boolean generateLogs;
    @NotNull
    private final Deque<LogData> logStack;
    @NotNull
    private LogRecorder logRecorder;
    @Deprecated
    private static final int SLASH_AT_THE_BEGINNING = 40;
    @Deprecated
    private static final int SLASH_AT_THE_END = 100;
    @Deprecated
    private static final int DEFAULT_RECORDING_STACK_MAX_SIZE = 100;

    public FullLoggerOptimiser(@NotNull FullLogger originalFullLogger, boolean generateLogs, int recordingStackMaxSize) {
        Intrinsics.checkNotNullParameter((Object)originalFullLogger, (String)"originalFullLogger");
        this.originalFullLogger = originalFullLogger;
        this.generateLogs = generateLogs;
        this.logStack = new ArrayDeque();
        this.logRecorder = new LogRecorder(recordingStackMaxSize);
    }

    public /* synthetic */ FullLoggerOptimiser(FullLogger fullLogger, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(fullLogger, bl, n);
    }

    @Override
    public void log(@Nullable LogLevel logLevel, @Nullable String tag, @Nullable String method, @Nullable String text) {
        String string = tag;
        String formattedTag = string == null ? (this.generateLogs ? AdbLoggerReflection.INSTANCE.getGeneratedClass() : null) : string;
        String string2 = method;
        String formattedMethod = string2 == null ? (this.generateLogs ? AdbLoggerReflection.INSTANCE.getGeneratedMethod() : null) : string2;
        string2 = (Object)((Object)logLevel) + tag + method + text;
        this.handleLog(string2, logLevel, (Function0<Unit>)((Function0)new Function0<Unit>(this, logLevel, formattedTag, formattedMethod, text){
            final /* synthetic */ FullLoggerOptimiser this$0;
            final /* synthetic */ LogLevel $logLevel;
            final /* synthetic */ String $formattedTag;
            final /* synthetic */ String $formattedMethod;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$logLevel = $logLevel;
                this.$formattedTag = $formattedTag;
                this.$formattedMethod = $formattedMethod;
                this.$text = $text;
                super(0);
            }

            public final void invoke() {
                FullLoggerOptimiser.access$getOriginalFullLogger$p(this.this$0).log(this.$logLevel, this.$formattedTag, this.$formattedMethod, this.$text);
            }
        }));
    }

    private final void handleLog(String key, LogLevel logLevel, Function0<Unit> action) {
        LogData logData = new LogData(key, action);
        int position = CollectionsKt.indexOf((Iterable)this.logStack, (Object)logData);
        RecordAnswer answer = this.logRecorder.put(position, new LogData(key, action));
        RecordAnswer recordAnswer = answer;
        if (recordAnswer instanceof RecordInProgress) {
            return;
        }
        if (recordAnswer instanceof ReadyRecord) {
            this.outputRecord((ReadyRecord)answer, logLevel);
            this.updateState((ReadyRecord)answer);
        }
    }

    private final void outputRecord(ReadyRecord readyRecord, LogLevel logLevel) {
        LogData it;
        Iterator<LogData> it2;
        boolean bl;
        Iterator<LogData> iterator;
        Object fragmentStartString = null;
        String fragmentEndString = null;
        if (readyRecord.getCountOfRecordingStack() > 0) {
            fragmentStartString = StringsKt.repeat((CharSequence)"/", (int)40) + "FRAGMENT IS REPEATED " + readyRecord.getCountOfRecordingStack() + " TIMES" + StringsKt.repeat((CharSequence)"/", (int)40);
            fragmentEndString = StringsKt.repeat((CharSequence)"/", (int)100);
        }
        if ((iterator = fragmentStartString) != null) {
            Iterator<LogData> iterator2 = iterator;
            boolean bl2 = false;
            bl = false;
            it2 = iterator2;
            boolean bl3 = false;
            this.originalFullLogger.log(logLevel, "ServiceInfo", "Start", (String)fragmentStartString);
        }
        iterator = readyRecord.getRecordingStack().descendingIterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"readyRecord.recordingStack.descendingIterator()");
        Object $this$forEach$iv = iterator;
        boolean $i$f$forEach2 = false;
        Iterator<LogData> iterator3 = $this$forEach$iv;
        bl = false;
        it2 = iterator3;
        while (it2.hasNext()) {
            LogData element$iv;
            it = element$iv = it2.next();
            boolean bl4 = false;
            it.getLogOutput().invoke();
        }
        $this$forEach$iv = fragmentEndString;
        if ($this$forEach$iv != null) {
            Iterator<LogData> $i$f$forEach2 = $this$forEach$iv;
            boolean bl5 = false;
            bl = false;
            it2 = $i$f$forEach2;
            boolean bl6 = false;
            this.originalFullLogger.log(logLevel, "ServiceInfo", "End", fragmentEndString);
        }
        $this$forEach$iv = readyRecord.getRemainedStack().descendingIterator();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"readyRecord.remainedStack.descendingIterator()");
        boolean $i$f$forEach3 = false;
        Iterator<LogData> iterator4 = $this$forEach$iv;
        bl = false;
        Iterator<LogData> iterator5 = iterator4;
        while (iterator5.hasNext()) {
            LogData element$iv;
            it = element$iv = iterator5.next();
            boolean bl7 = false;
            it.getLogOutput().invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateState(ReadyRecord readyRecord) {
        void $this$forEach$iv;
        Object object = readyRecord.getRecordingStack();
        boolean bl = false;
        if (!object.isEmpty()) {
            this.logStack.clear();
        }
        object = readyRecord.getRemainedStack().descendingIterator();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readyRecord.remainedStack.descendingIterator()");
        boolean $i$f$forEach = false;
        void var4_4 = $this$forEach$iv;
        boolean bl2 = false;
        void var6_6 = var4_4;
        while (var6_6.hasNext()) {
            Object element$iv = var6_6.next();
            LogData it = (LogData)element$iv;
            boolean bl3 = false;
            this.logStack.addFirst(it);
        }
    }

    public static final /* synthetic */ FullLogger access$getOriginalFullLogger$p(FullLoggerOptimiser $this) {
        return $this.originalFullLogger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/kaspersky/adbserver/common/log/filterlog/FullLoggerOptimiser$Companion;", "", "()V", "DEFAULT_RECORDING_STACK_MAX_SIZE", "", "SLASH_AT_THE_BEGINNING", "SLASH_AT_THE_END", "adbserver-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

