/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.common.log.filterlog;

import com.kaspersky.adbserver.common.log.filterlog.LogData;
import com.kaspersky.adbserver.common.log.filterlog.ReadyRecord;
import com.kaspersky.adbserver.common.log.filterlog.RecordAnswer;
import com.kaspersky.adbserver.common.log.filterlog.RecordInProgress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/kaspersky/adbserver/common/log/filterlog/LogRecorder;", "", "recordingStackMaxSize", "", "(I)V", "countOfRecordingStack", "forecastedPositionAtInitialStack", "recordingStack", "Ljava/util/Deque;", "Lcom/kaspersky/adbserver/common/log/filterlog/LogData;", "recordingStackSize", "state", "Lcom/kaspersky/adbserver/common/log/filterlog/LogRecorder$State;", "addNewLogToStack", "", "logData", "getRecord", "Lcom/kaspersky/adbserver/common/log/filterlog/RecordAnswer;", "newLog", "getSingleUniqueRecord", "Lcom/kaspersky/adbserver/common/log/filterlog/ReadyRecord;", "put", "foundPosition", "resetState", "startRecording", "Companion", "State", "adbserver-common"})
public final class LogRecorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int recordingStackMaxSize;
    private int forecastedPositionAtInitialStack;
    private int recordingStackSize;
    @NotNull
    private final Deque<LogData> recordingStack;
    private int countOfRecordingStack;
    @NotNull
    private State state;
    private static final int UNBOUND_INDEX = -1;

    public LogRecorder(int recordingStackMaxSize) {
        this.recordingStackMaxSize = recordingStackMaxSize;
        this.forecastedPositionAtInitialStack = -1;
        this.recordingStack = new ArrayDeque();
        this.state = State.NO_RECORDING;
    }

    @NotNull
    public final RecordAnswer put(int foundPosition, @NotNull LogData logData) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        if (this.state == State.NO_RECORDING && foundPosition == -1) {
            return this.getSingleUniqueRecord(logData);
        }
        if (this.state == State.NO_RECORDING) {
            this.startRecording(foundPosition);
        }
        if (foundPosition != this.forecastedPositionAtInitialStack) {
            RecordAnswer record = this.getRecord(logData);
            this.resetState();
            return record;
        }
        this.addNewLogToStack(logData);
        if (this.countOfRecordingStack >= this.recordingStackMaxSize) {
            RecordAnswer record = this.getRecord(null);
            this.resetState();
            return record;
        }
        return new RecordInProgress();
    }

    private final ReadyRecord getSingleUniqueRecord(LogData logData) {
        Deque remainedStack = new ArrayDeque();
        remainedStack.addFirst(logData);
        return new ReadyRecord(new ArrayDeque(), 0, remainedStack);
    }

    private final void startRecording(int foundPosition) {
        this.state = State.RECORDING;
        this.recordingStackSize = foundPosition + 1;
        this.forecastedPositionAtInitialStack = this.recordingStackSize - 1;
    }

    /*
     * WARNING - void declaration
     */
    private final RecordAnswer getRecord(LogData newLog) {
        Deque remainedStack = new ArrayDeque();
        LogData logData = newLog;
        if (logData != null) {
            LogData logData2 = logData;
            boolean bl = false;
            boolean bl2 = false;
            LogData it = logData2;
            boolean bl3 = false;
            remainedStack.addFirst(newLog);
        }
        if (this.forecastedPositionAtInitialStack > -1) {
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv = this.recordingStack;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n = index$iv$iv$iv2++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl4 = false;
                LogData logData3 = (LogData)element$iv$iv;
                int index = index$iv$iv;
                boolean bl5 = false;
                if (!(index > this.forecastedPositionAtInitialStack)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEachIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void logData4;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LogData index$iv$iv$iv2 = (LogData)item$iv;
                int $noName_0 = n;
                boolean bl6 = false;
                remainedStack.addLast(logData4);
            }
        }
        return new ReadyRecord(new ArrayDeque(this.recordingStack), this.countOfRecordingStack, remainedStack);
    }

    static /* synthetic */ RecordAnswer getRecord$default(LogRecorder logRecorder, LogData logData, int n, Object object) {
        if ((n & 1) != 0) {
            logData = null;
        }
        return logRecorder.getRecord(logData);
    }

    private final void resetState() {
        this.forecastedPositionAtInitialStack = -1;
        this.recordingStackSize = 0;
        this.recordingStack.clear();
        this.countOfRecordingStack = 0;
        this.state = State.NO_RECORDING;
    }

    private final void addNewLogToStack(LogData logData) {
        if (this.countOfRecordingStack == 0) {
            this.recordingStack.addFirst(logData);
        }
        LogRecorder logRecorder = this;
        int n = logRecorder.forecastedPositionAtInitialStack;
        logRecorder.forecastedPositionAtInitialStack = n + -1;
        if (this.forecastedPositionAtInitialStack == -1) {
            logRecorder = this;
            n = logRecorder.countOfRecordingStack;
            logRecorder.countOfRecordingStack = n + 1;
            this.forecastedPositionAtInitialStack = this.recordingStackSize - 1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/adbserver/common/log/filterlog/LogRecorder$Companion;", "", "()V", "UNBOUND_INDEX", "", "adbserver-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/adbserver/common/log/filterlog/LogRecorder$State;", "", "(Ljava/lang/String;I)V", "RECORDING", "NO_RECORDING", "adbserver-common"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State RECORDING = new State();
        public static final /* enum */ State NO_RECORDING = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.RECORDING, State.NO_RECORDING};
        }
    }
}

