/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.common.log.fulllogger;

import com.kaspersky.adbserver.common.log.fulllogger.FullLogger;
import com.kaspersky.adbserver.common.log.logger.LogLevel;
import com.kaspersky.adbserver.common.log.utils.AdbLoggerReflection;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002J0\u0010\u0014\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/kaspersky/adbserver/common/log/fulllogger/FullLoggerSystemImpl;", "Lcom/kaspersky/adbserver/common/log/fulllogger/FullLogger;", "logLevel", "Lcom/kaspersky/adbserver/common/log/logger/LogLevel;", "desktopName", "", "deviceName", "(Lcom/kaspersky/adbserver/common/log/logger/LogLevel;Ljava/lang/String;Ljava/lang/String;)V", "formatter", "Ljava/text/SimpleDateFormat;", "getDate", "getDesktop", "getDevice", "getLogType", "getMethod", "method", "getTag", "tag", "getText", "text", "log", "", "Companion", "adbserver-common"})
public final class FullLoggerSystemImpl
implements FullLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogLevel logLevel;
    @Nullable
    private final String desktopName;
    @Nullable
    private final String deviceName;
    @NotNull
    private final SimpleDateFormat formatter;
    @NotNull
    private static final String DEVICE = "device=";
    @NotNull
    private static final String TAG = "tag=";
    @NotNull
    private static final String METHOD = "method=";
    @NotNull
    private static final String MESSAGE = "message: ";
    @NotNull
    private static final String DESKTOP = "desktop=";
    @NotNull
    private static final String EMPTY_STRING = "";

    public FullLoggerSystemImpl(@NotNull LogLevel logLevel, @Nullable String desktopName, @Nullable String deviceName) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.logLevel = logLevel;
        this.desktopName = desktopName;
        this.deviceName = deviceName;
        this.formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    }

    @Override
    public void log(@Nullable LogLevel logLevel, @Nullable String tag, @Nullable String method, @Nullable String text) {
        if (logLevel != null && this.logLevel.compareTo((Enum)logLevel) <= 0) {
            String fullLog = this.getLogType(logLevel) + ' ' + this.getDate() + ' ' + this.getDesktop() + ' ' + this.getDevice() + ' ' + this.getTag(tag) + ' ' + this.getMethod(method) + ' ' + this.getText(text);
            if (logLevel == LogLevel.ERROR) {
                System.err.println(fullLog);
                return;
            }
            boolean bl = false;
            System.out.println((Object)fullLog);
        }
    }

    private final String getLogType(LogLevel logLevel) {
        String string;
        LogLevel logLevel2 = logLevel;
        return logLevel2 == null ? EMPTY_STRING : ((string = logLevel2.name()) == null ? EMPTY_STRING : string);
    }

    private final String getDevice() {
        return this.deviceName != null ? Intrinsics.stringPlus((String)DEVICE, (Object)this.deviceName) : EMPTY_STRING;
    }

    private final String getDesktop() {
        return this.desktopName != null ? Intrinsics.stringPlus((String)DESKTOP, (Object)this.desktopName) : EMPTY_STRING;
    }

    private final String getTag(String tag) {
        if (this.logLevel.compareTo((Enum)LogLevel.DEBUG) > 0) {
            return EMPTY_STRING;
        }
        if (tag != null) {
            return TAG + tag + ' ';
        }
        String generatedTagName = AdbLoggerReflection.INSTANCE.getGeneratedClass();
        return TAG + generatedTagName + ' ';
    }

    private final String getMethod(String method) {
        if (this.logLevel.compareTo((Enum)LogLevel.DEBUG) > 0) {
            return EMPTY_STRING;
        }
        if (method != null) {
            return METHOD + method + ' ';
        }
        String generatedMethodName = AdbLoggerReflection.INSTANCE.getGeneratedMethod();
        return METHOD + generatedMethodName + ' ';
    }

    private final String getText(String text) {
        return text != null ? Intrinsics.stringPlus((String)MESSAGE, (Object)text) : EMPTY_STRING;
    }

    private final String getDate() {
        String date = this.formatter.format(new Date());
        return date != null ? Intrinsics.stringPlus((String)date, (Object)" ") : EMPTY_STRING;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/kaspersky/adbserver/common/log/fulllogger/FullLoggerSystemImpl$Companion;", "", "()V", "DESKTOP", "", "DEVICE", "EMPTY_STRING", "MESSAGE", "METHOD", "TAG", "adbserver-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

