/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.connection.implementation;

import com.kaspersky.adbserver.common.log.logger.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\rJ\u0014\u0010\u000f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/ConnectionMaker;", "", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "(Lcom/kaspersky/adbserver/common/log/logger/Logger;)V", "connectionState", "Lcom/kaspersky/adbserver/connection/implementation/ConnectionMaker$ConnectionState;", "connect", "", "connectAction", "Lkotlin/Function0;", "successConnectAction", "failureConnectAction", "Lkotlin/Function1;", "", "disconnect", "isConnected", "", "ConnectionState", "adbserver-connection"})
public final class ConnectionMaker {
    @NotNull
    private final Logger logger;
    @NotNull
    private volatile ConnectionState connectionState;

    public ConnectionMaker(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.connectionState = ConnectionState.DISCONNECTED;
    }

    public final void connect(@NotNull Function0<Unit> connectAction, @NotNull Function0<Unit> successConnectAction, @NotNull Function1<? super Throwable, Unit> failureConnectAction) {
        Intrinsics.checkNotNullParameter(connectAction, (String)"connectAction");
        Intrinsics.checkNotNullParameter(successConnectAction, (String)"successConnectAction");
        Intrinsics.checkNotNullParameter(failureConnectAction, (String)"failureConnectAction");
        this.logger.d(Intrinsics.stringPlus((String)"Start a connection establishment. The current state=", (Object)((Object)this.connectionState)));
        if (this.connectionState == ConnectionState.CONNECTING) {
            this.logger.d("The connection establishment process is in progress. Skip the new attempt");
            return;
        }
        if (this.connectionState == ConnectionState.DISCONNECTING) {
            this.logger.d("The connection interruption process is in progress. Skip the new attempt");
            return;
        }
        if (this.connectionState == ConnectionState.CONNECTED) {
            this.logger.d("The connection has been established. Skip the new attempt");
            return;
        }
        this.connectionState = ConnectionState.CONNECTING;
        this.logger.d(Intrinsics.stringPlus((String)"The current state=", (Object)((Object)this.connectionState)));
        try {
            connectAction.invoke();
            this.connectionState = ConnectionState.CONNECTED;
            this.logger.d(Intrinsics.stringPlus((String)"The connection is established. The current state=", (Object)((Object)this.connectionState)));
            successConnectAction.invoke();
        }
        catch (Throwable exception) {
            this.connectionState = ConnectionState.DISCONNECTED;
            this.logger.d(Intrinsics.stringPlus((String)"The connection establishment process failed. The current state=", (Object)((Object)this.connectionState)));
            failureConnectAction.invoke((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(@NotNull Function0<Unit> connectAction) {
        Intrinsics.checkNotNullParameter(connectAction, (String)"connectAction");
        this.logger.d(Intrinsics.stringPlus((String)"Start a connection interruption. The current state=", (Object)((Object)this.connectionState)));
        if (this.connectionState == ConnectionState.DISCONNECTING) {
            this.logger.d("The connection interruption process is in progress. Skip the new attempt");
            return;
        }
        if (this.connectionState == ConnectionState.DISCONNECTED) {
            this.logger.d("The connection has been disconnected. Skip the new attempt");
            return;
        }
        this.connectionState = ConnectionState.DISCONNECTING;
        this.logger.d(Intrinsics.stringPlus((String)"The current state=", (Object)((Object)this.connectionState)));
        try {
            connectAction.invoke();
        }
        finally {
            this.connectionState = ConnectionState.DISCONNECTED;
            this.logger.d(Intrinsics.stringPlus((String)"The connection is disconnected. The current state=", (Object)((Object)this.connectionState)));
        }
    }

    public final boolean isConnected() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/ConnectionMaker$ConnectionState;", "", "(Ljava/lang/String;I)V", "CONNECTING", "CONNECTED", "DISCONNECTING", "DISCONNECTED", "adbserver-connection"})
    private static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value) {
            return Enum.valueOf(ConnectionState.class, value);
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTING, ConnectionState.DISCONNECTED};
        }
    }
}

