/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.connection.implementation;

import com.kaspersky.adbserver.common.api.CommandExecutor;
import com.kaspersky.adbserver.common.api.CommandResult;
import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.connection.api.ConnectionServer;
import com.kaspersky.adbserver.connection.api.ConnectionServerLifecycle;
import com.kaspersky.adbserver.connection.implementation.ConnectionMaker;
import com.kaspersky.adbserver.connection.implementation.ConnectionServerImplBySocket;
import com.kaspersky.adbserver.connection.implementation.lightsocket.LightSocketWrapper;
import com.kaspersky.adbserver.connection.implementation.lightsocket.LightSocketWrapperImpl;
import com.kaspersky.adbserver.connection.implementation.transferring.ExpectedEOFException;
import com.kaspersky.adbserver.connection.implementation.transferring.ResultMessage;
import com.kaspersky.adbserver.connection.implementation.transferring.SocketMessagesTransferring;
import com.kaspersky.adbserver.connection.implementation.transferring.TaskMessage;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/ConnectionServerImplBySocket;", "Lcom/kaspersky/adbserver/connection/api/ConnectionServer;", "socketCreation", "Lkotlin/Function0;", "Ljava/net/Socket;", "commandExecutor", "Lcom/kaspersky/adbserver/common/api/CommandExecutor;", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "connectionServerLifecycle", "Lcom/kaspersky/adbserver/connection/api/ConnectionServerLifecycle;", "(Lkotlin/jvm/functions/Function0;Lcom/kaspersky/adbserver/common/api/CommandExecutor;Lcom/kaspersky/adbserver/common/log/logger/Logger;Lcom/kaspersky/adbserver/connection/api/ConnectionServerLifecycle;)V", "_socket", "_socketMessagesTransferring", "Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "Lcom/kaspersky/adbserver/connection/implementation/transferring/TaskMessage;", "Lcom/kaspersky/adbserver/connection/implementation/transferring/ResultMessage;", "Lcom/kaspersky/adbserver/common/api/CommandResult;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "connectionMaker", "Lcom/kaspersky/adbserver/connection/implementation/ConnectionMaker;", "socket", "getSocket", "()Ljava/net/Socket;", "socketMessagesTransferring", "getSocketMessagesTransferring", "()Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "handleMessages", "", "isConnected", "", "tryConnect", "tryDisconnect", "adbserver-connection"})
public final class ConnectionServerImplBySocket
implements ConnectionServer {
    @NotNull
    private final Function0<Socket> socketCreation;
    @NotNull
    private final CommandExecutor commandExecutor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConnectionServerLifecycle connectionServerLifecycle;
    @NotNull
    private ConnectionMaker connectionMaker;
    @Nullable
    private Socket _socket;
    @Nullable
    private SocketMessagesTransferring<TaskMessage, ResultMessage<CommandResult>> _socketMessagesTransferring;
    private final ExecutorService backgroundExecutor;

    public ConnectionServerImplBySocket(@NotNull Function0<? extends Socket> socketCreation, @NotNull CommandExecutor commandExecutor, @NotNull Logger logger, @NotNull ConnectionServerLifecycle connectionServerLifecycle) {
        Intrinsics.checkNotNullParameter(socketCreation, (String)"socketCreation");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)connectionServerLifecycle, (String)"connectionServerLifecycle");
        this.socketCreation = socketCreation;
        this.commandExecutor = commandExecutor;
        this.logger = logger;
        this.connectionServerLifecycle = connectionServerLifecycle;
        this.connectionMaker = new ConnectionMaker(this.logger);
        this.backgroundExecutor = Executors.newCachedThreadPool();
    }

    private final Socket getSocket() {
        Socket socket = this._socket;
        if (socket == null) {
            throw new IllegalStateException("Socket is not initialised. Please call `tryConnect` function at first.");
        }
        return socket;
    }

    private final SocketMessagesTransferring<TaskMessage, ResultMessage<CommandResult>> getSocketMessagesTransferring() {
        SocketMessagesTransferring<TaskMessage, ResultMessage<CommandResult>> socketMessagesTransferring = this._socketMessagesTransferring;
        if (socketMessagesTransferring == null) {
            throw new IllegalStateException("Socket transferring is not initialised. Please call `tryConnect` function at first.");
        }
        return socketMessagesTransferring;
    }

    @Override
    public void tryConnect() {
        this.logger.d("Start the process");
        this.connectionMaker.connect((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConnectionServerImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void logger$iv;
                void disruptAction$iv;
                void lightSocketWrapper$iv;
                ConnectionServerImplBySocket.access$set_socket$p(this.this$0, (Socket)ConnectionServerImplBySocket.access$getSocketCreation$p(this.this$0).invoke());
                SocketMessagesTransferring.Companion companion = SocketMessagesTransferring.Companion;
                LightSocketWrapper lightSocketWrapper = new LightSocketWrapperImpl(ConnectionServerImplBySocket.access$getSocket(this.this$0));
                Function0 function0 = (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ConnectionServerImplBySocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.tryDisconnect();
                        ConnectionServerImplBySocket.access$getConnectionServerLifecycle$p(this.this$0).onDisconnectedBySocketProblems();
                    }
                };
                Logger logger = ConnectionServerImplBySocket.access$getLogger$p(this.this$0);
                boolean $i$f$createTransferring = false;
                ConnectionServerImplBySocket.access$set_socketMessagesTransferring$p(this.this$0, new SocketMessagesTransferring<ReceiveModel, SendModel>((LightSocketWrapper)lightSocketWrapper$iv, TaskMessage.class, ResultMessage.class, (Function0)disruptAction$iv, (Logger)logger$iv, null));
                ConnectionServerImplBySocket.access$getSocketMessagesTransferring(this.this$0).prepareListening();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConnectionServerImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConnectionServerImplBySocket.access$getLogger$p(this.this$0).d("The connection is ready. Start messages listening");
                ConnectionServerImplBySocket.access$handleMessages(this.this$0);
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ ConnectionServerImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                Socket socket = ConnectionServerImplBySocket.access$get_socket$p(this.this$0);
                if (socket != null) {
                    socket.close();
                }
                ConnectionServerImplBySocket.access$set_socket$p(this.this$0, null);
                ConnectionServerImplBySocket.access$set_socketMessagesTransferring$p(this.this$0, null);
                String errorReasonMessage = exception instanceof ExpectedEOFException ? "The most possible reason is the opposite socket is not ready yet" : "The exception=" + exception;
                ConnectionServerImplBySocket.access$getLogger$p(this.this$0).d("The connection establishment attempt failed. " + errorReasonMessage);
            }
        }));
    }

    private final void handleMessages() {
        this.getSocketMessagesTransferring().startListening((Function1<TaskMessage, Unit>)((Function1)new Function1<TaskMessage, Unit>(this){
            final /* synthetic */ ConnectionServerImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TaskMessage taskMessage) {
                Intrinsics.checkNotNullParameter((Object)taskMessage, (String)"taskMessage");
                ConnectionServerImplBySocket.access$getConnectionServerLifecycle$p(this.this$0).onReceivedTask(taskMessage.getCommand());
                ConnectionServerImplBySocket.access$getLogger$p(this.this$0).d("Received taskMessage=" + taskMessage);
                ConnectionServerImplBySocket.access$getBackgroundExecutor$p(this.this$0).execute(() -> handleMessages.1.invoke$lambda-0(this.this$0, taskMessage));
            }

            private static final void invoke$lambda-0(ConnectionServerImplBySocket this$0, TaskMessage $taskMessage) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$taskMessage, (String)"$taskMessage");
                CommandResult result = ConnectionServerImplBySocket.access$getCommandExecutor$p(this$0).execute($taskMessage.getCommand());
                ConnectionServerImplBySocket.access$getConnectionServerLifecycle$p(this$0).onExecutedTask($taskMessage.getCommand(), result);
                ConnectionServerImplBySocket.access$getLogger$p(this$0).d("Result of taskMessage=" + $taskMessage + " => result=" + result);
                ConnectionServerImplBySocket.access$getSocketMessagesTransferring(this$0).sendMessage(new ResultMessage<CommandResult>($taskMessage.getCommand(), result));
            }
        }));
    }

    @Override
    public void tryDisconnect() {
        this.logger.d("Start the process");
        this.connectionMaker.disconnect((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConnectionServerImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConnectionServerImplBySocket.access$getSocketMessagesTransferring(this.this$0).stopListening();
                ConnectionServerImplBySocket.access$getSocket(this.this$0).close();
            }
        }));
        this.logger.d("Success disconnection");
    }

    @Override
    public boolean isConnected() {
        return this.connectionMaker.isConnected();
    }

    public static final /* synthetic */ void access$set_socket$p(ConnectionServerImplBySocket $this, Socket socket) {
        $this._socket = socket;
    }

    public static final /* synthetic */ Function0 access$getSocketCreation$p(ConnectionServerImplBySocket $this) {
        return $this.socketCreation;
    }

    public static final /* synthetic */ void access$set_socketMessagesTransferring$p(ConnectionServerImplBySocket $this, SocketMessagesTransferring socketMessagesTransferring) {
        $this._socketMessagesTransferring = socketMessagesTransferring;
    }

    public static final /* synthetic */ Socket access$getSocket(ConnectionServerImplBySocket $this) {
        return $this.getSocket();
    }

    public static final /* synthetic */ ConnectionServerLifecycle access$getConnectionServerLifecycle$p(ConnectionServerImplBySocket $this) {
        return $this.connectionServerLifecycle;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ConnectionServerImplBySocket $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SocketMessagesTransferring access$getSocketMessagesTransferring(ConnectionServerImplBySocket $this) {
        return $this.getSocketMessagesTransferring();
    }

    public static final /* synthetic */ void access$handleMessages(ConnectionServerImplBySocket $this) {
        $this.handleMessages();
    }

    public static final /* synthetic */ Socket access$get_socket$p(ConnectionServerImplBySocket $this) {
        return $this._socket;
    }

    public static final /* synthetic */ ExecutorService access$getBackgroundExecutor$p(ConnectionServerImplBySocket $this) {
        return $this.backgroundExecutor;
    }

    public static final /* synthetic */ CommandExecutor access$getCommandExecutor$p(ConnectionServerImplBySocket $this) {
        return $this.commandExecutor;
    }
}

