/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.connection.implementation;

import com.kaspersky.adbserver.common.api.Command;
import com.kaspersky.adbserver.common.api.CommandResult;
import com.kaspersky.adbserver.common.api.ExecutorResultStatus;
import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.connection.api.ConnectionClient;
import com.kaspersky.adbserver.connection.api.ConnectionClientLifecycle;
import com.kaspersky.adbserver.connection.implementation.ConnectionMaker;
import com.kaspersky.adbserver.connection.implementation.ResultWaiter;
import com.kaspersky.adbserver.connection.implementation.lightsocket.LightSocketWrapper;
import com.kaspersky.adbserver.connection.implementation.lightsocket.LightSocketWrapperImpl;
import com.kaspersky.adbserver.connection.implementation.transferring.ExpectedEOFException;
import com.kaspersky.adbserver.connection.implementation.transferring.ResultMessage;
import com.kaspersky.adbserver.connection.implementation.transferring.SocketMessagesTransferring;
import com.kaspersky.adbserver.connection.implementation.transferring.TaskMessage;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/ConnectionClientImplBySocket;", "Lcom/kaspersky/adbserver/connection/api/ConnectionClient;", "socketCreation", "Lkotlin/Function0;", "Ljava/net/Socket;", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "connectionClientLifecycle", "Lcom/kaspersky/adbserver/connection/api/ConnectionClientLifecycle;", "(Lkotlin/jvm/functions/Function0;Lcom/kaspersky/adbserver/common/log/logger/Logger;Lcom/kaspersky/adbserver/connection/api/ConnectionClientLifecycle;)V", "_socket", "_socketMessagesTransferring", "Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "Lcom/kaspersky/adbserver/connection/implementation/transferring/ResultMessage;", "Lcom/kaspersky/adbserver/common/api/CommandResult;", "Lcom/kaspersky/adbserver/connection/implementation/transferring/TaskMessage;", "commandsInProgress", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/kaspersky/adbserver/common/api/Command;", "Lcom/kaspersky/adbserver/connection/implementation/ResultWaiter;", "connectionMaker", "Lcom/kaspersky/adbserver/connection/implementation/ConnectionMaker;", "socket", "getSocket", "()Ljava/net/Socket;", "socketMessagesTransferring", "getSocketMessagesTransferring", "()Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "executeCommand", "command", "handleMessages", "", "isConnected", "", "resetCommandsInProgress", "failureReason", "", "tryConnect", "tryDisconnect", "tryDisconnectBySocketProblems", "tryDisconnectCommon", "Companion", "adb-server-connection"})
public final class ConnectionClientImplBySocket
implements ConnectionClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Socket> socketCreation;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConnectionClientLifecycle connectionClientLifecycle;
    @Nullable
    private Socket _socket;
    @Nullable
    private SocketMessagesTransferring<ResultMessage<CommandResult>, TaskMessage> _socketMessagesTransferring;
    @NotNull
    private ConnectionMaker connectionMaker;
    @NotNull
    private final ConcurrentHashMap<Command, ResultWaiter<ResultMessage<CommandResult>>> commandsInProgress;
    private static final long COMMAND_TIMEOUT_MIN = TimeUnit.MINUTES.toSeconds(3L);

    public ConnectionClientImplBySocket(@NotNull Function0<? extends Socket> socketCreation, @NotNull Logger logger, @NotNull ConnectionClientLifecycle connectionClientLifecycle) {
        Intrinsics.checkNotNullParameter(socketCreation, (String)"socketCreation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)connectionClientLifecycle, (String)"connectionClientLifecycle");
        this.socketCreation = socketCreation;
        this.logger = logger;
        this.connectionClientLifecycle = connectionClientLifecycle;
        this.connectionMaker = new ConnectionMaker(this.logger);
        this.commandsInProgress = new ConcurrentHashMap();
    }

    private final Socket getSocket() {
        Socket socket = this._socket;
        if (socket == null) {
            throw new IllegalStateException("Socket is not initialised. Please call `tryConnect` function at first.");
        }
        return socket;
    }

    private final SocketMessagesTransferring<ResultMessage<CommandResult>, TaskMessage> getSocketMessagesTransferring() {
        SocketMessagesTransferring<ResultMessage<CommandResult>, TaskMessage> socketMessagesTransferring = this._socketMessagesTransferring;
        if (socketMessagesTransferring == null) {
            throw new IllegalStateException("Socket transferring is not initialised. Please call `tryConnect` function at first.");
        }
        return socketMessagesTransferring;
    }

    @Override
    public void tryConnect() {
        this.logger.d("Start the process");
        this.connectionMaker.connect((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConnectionClientImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void logger$iv;
                void disruptAction$iv;
                void lightSocketWrapper$iv;
                ConnectionClientImplBySocket.access$set_socket$p(this.this$0, (Socket)ConnectionClientImplBySocket.access$getSocketCreation$p(this.this$0).invoke());
                SocketMessagesTransferring.Companion companion = SocketMessagesTransferring.Companion;
                LightSocketWrapper lightSocketWrapper = new LightSocketWrapperImpl(ConnectionClientImplBySocket.access$getSocket(this.this$0));
                Function0 function0 = (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ConnectionClientImplBySocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ConnectionClientImplBySocket.access$tryDisconnectBySocketProblems(this.this$0);
                        ConnectionClientImplBySocket.access$getConnectionClientLifecycle$p(this.this$0).onDisconnectedBySocketProblems();
                    }
                };
                Logger logger = ConnectionClientImplBySocket.access$getLogger$p(this.this$0);
                boolean $i$f$createTransferring = false;
                ConnectionClientImplBySocket.access$set_socketMessagesTransferring$p(this.this$0, new SocketMessagesTransferring<ReceiveModel, SendModel>((LightSocketWrapper)lightSocketWrapper$iv, ResultMessage.class, TaskMessage.class, (Function0)disruptAction$iv, (Logger)logger$iv, null));
                ConnectionClientImplBySocket.access$getSocketMessagesTransferring(this.this$0).prepareListening();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConnectionClientImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConnectionClientImplBySocket.access$getLogger$p(this.this$0).d("The connection is ready. Start messages listening");
                ConnectionClientImplBySocket.access$handleMessages(this.this$0);
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ ConnectionClientImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                Socket socket = ConnectionClientImplBySocket.access$get_socket$p(this.this$0);
                if (socket != null) {
                    socket.close();
                }
                ConnectionClientImplBySocket.access$set_socket$p(this.this$0, null);
                ConnectionClientImplBySocket.access$set_socketMessagesTransferring$p(this.this$0, null);
                String errorReasonMessage = exception instanceof ExpectedEOFException ? "The most possible reason is the opposite socket is not ready yet" : "The exception=" + exception;
                ConnectionClientImplBySocket.access$getLogger$p(this.this$0).d("The connection establishment attempt failed. \n" + errorReasonMessage);
            }
        }));
    }

    private final void handleMessages() {
        this.getSocketMessagesTransferring().startListening((Function1<ResultMessage<CommandResult>, Unit>)((Function1)new Function1<ResultMessage<CommandResult>, Unit>(this){
            final /* synthetic */ ConnectionClientImplBySocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ResultMessage<CommandResult> resultMessage) {
                block0: {
                    Intrinsics.checkNotNullParameter(resultMessage, (String)"resultMessage");
                    ConnectionClientImplBySocket.access$getLogger$p(this.this$0).d("Received resultMessage=" + resultMessage);
                    ResultWaiter resultWaiter = (ResultWaiter)ConnectionClientImplBySocket.access$getCommandsInProgress$p(this.this$0).get(resultMessage.getCommand());
                    if (resultWaiter == null) break block0;
                    resultWaiter.latchResult(resultMessage);
                }
            }
        }));
    }

    private final void tryDisconnectBySocketProblems() {
        this.logger.d("Start the process");
        String failureReason = "There was some problem inside a Socket creation process or during a Socket connection. \nThe most possible reason is using of old version of 'adbserver-desktop.jar (desktop.jar)'. \nPlease, use the most modern version of 'adbserver-desktop.jar' located in https://github.com/KasperskyLab/Kaspresso/tree/master/artifacts.";
        this.tryDisconnectCommon(failureReason);
        this.logger.d("The disconnection was completed");
    }

    @Override
    public void tryDisconnect() {
        this.logger.d("Start the process");
        String failureReason = "`ConnectionClientImplBySocket.tryDisconnect` function was called earlier. Please, observe code points and relative logs where this function started.";
        this.tryDisconnectCommon(failureReason);
        this.logger.d("The disconnection was completed");
    }

    private final void tryDisconnectCommon(String failureReason) {
        this.connectionMaker.disconnect((Function0<Unit>)((Function0)new Function0<Unit>(this, failureReason){
            final /* synthetic */ ConnectionClientImplBySocket this$0;
            final /* synthetic */ String $failureReason;
            {
                this.this$0 = $receiver;
                this.$failureReason = $failureReason;
                super(0);
            }

            public final void invoke() {
                SocketMessagesTransferring socketMessagesTransferring = ConnectionClientImplBySocket.access$get_socketMessagesTransferring$p(this.this$0);
                if (socketMessagesTransferring != null) {
                    socketMessagesTransferring.stopListening();
                }
                Socket socket = ConnectionClientImplBySocket.access$get_socket$p(this.this$0);
                if (socket != null) {
                    socket.close();
                }
                ConnectionClientImplBySocket.access$resetCommandsInProgress(this.this$0, this.$failureReason);
            }
        }));
    }

    private final void resetCommandsInProgress(String failureReason) {
        for (Map.Entry entry : ((Map)this.commandsInProgress).entrySet()) {
            Command adbCommand = (Command)entry.getKey();
            ResultWaiter resultWaiter = (ResultWaiter)entry.getValue();
            CommandResult commandResult = new CommandResult(ExecutorResultStatus.FAILURE, failureReason, null, 4, null);
            this.logger.d("The command=" + adbCommand + " was failed because the socket connection had broken up. \nResult=" + commandResult);
            resultWaiter.latchResult(new ResultMessage<CommandResult>(adbCommand, commandResult));
        }
        this.commandsInProgress.clear();
    }

    @Override
    public boolean isConnected() {
        return this.connectionMaker.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CommandResult executeCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.logger.d("Started command=" + command);
        ResultWaiter resultWaiter = new ResultWaiter();
        ((Map)this.commandsInProgress).put(command, resultWaiter);
        this.getSocketMessagesTransferring().sendMessage(new TaskMessage(command));
        ResultMessage resultMessage = null;
        try {
            resultMessage = (ResultMessage)resultWaiter.waitResult(COMMAND_TIMEOUT_MIN, TimeUnit.SECONDS);
        }
        catch (InterruptedException exception) {
            CommandResult failedCommandResult = new CommandResult(ExecutorResultStatus.FAILURE, "Waiting thread was interrupted", null, 4, null);
            this.logger.d("Command=" + command + " failed with commandResult=" + failedCommandResult);
            CommandResult commandResult = failedCommandResult;
            return commandResult;
        }
        finally {
            this.commandsInProgress.remove(command);
        }
        if (resultMessage == null) {
            CommandResult failedCommandResult = new CommandResult(ExecutorResultStatus.FAILURE, "Waiting result timeout was expired", null, 4, null);
            this.logger.d("Command=" + command + " failed with commandResult=" + failedCommandResult);
            return failedCommandResult;
        }
        this.logger.d("Command=" + command + " completed with commandResult=" + resultMessage.getData());
        return (CommandResult)resultMessage.getData();
    }

    public static final /* synthetic */ void access$set_socket$p(ConnectionClientImplBySocket $this, Socket socket) {
        $this._socket = socket;
    }

    public static final /* synthetic */ Function0 access$getSocketCreation$p(ConnectionClientImplBySocket $this) {
        return $this.socketCreation;
    }

    public static final /* synthetic */ void access$set_socketMessagesTransferring$p(ConnectionClientImplBySocket $this, SocketMessagesTransferring socketMessagesTransferring) {
        $this._socketMessagesTransferring = socketMessagesTransferring;
    }

    public static final /* synthetic */ Socket access$getSocket(ConnectionClientImplBySocket $this) {
        return $this.getSocket();
    }

    public static final /* synthetic */ void access$tryDisconnectBySocketProblems(ConnectionClientImplBySocket $this) {
        $this.tryDisconnectBySocketProblems();
    }

    public static final /* synthetic */ ConnectionClientLifecycle access$getConnectionClientLifecycle$p(ConnectionClientImplBySocket $this) {
        return $this.connectionClientLifecycle;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ConnectionClientImplBySocket $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SocketMessagesTransferring access$getSocketMessagesTransferring(ConnectionClientImplBySocket $this) {
        return $this.getSocketMessagesTransferring();
    }

    public static final /* synthetic */ void access$handleMessages(ConnectionClientImplBySocket $this) {
        $this.handleMessages();
    }

    public static final /* synthetic */ Socket access$get_socket$p(ConnectionClientImplBySocket $this) {
        return $this._socket;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCommandsInProgress$p(ConnectionClientImplBySocket $this) {
        return $this.commandsInProgress;
    }

    public static final /* synthetic */ SocketMessagesTransferring access$get_socketMessagesTransferring$p(ConnectionClientImplBySocket $this) {
        return $this._socketMessagesTransferring;
    }

    public static final /* synthetic */ void access$resetCommandsInProgress(ConnectionClientImplBySocket $this, String failureReason) {
        $this.resetCommandsInProgress(failureReason);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/ConnectionClientImplBySocket$Companion;", "", "()V", "COMMAND_TIMEOUT_MIN", "", "adb-server-connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

