/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.connection.api;

import com.kaspersky.adbserver.common.api.CommandExecutor;
import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.connection.api.ConnectionClient;
import com.kaspersky.adbserver.connection.api.ConnectionClientLifecycle;
import com.kaspersky.adbserver.connection.api.ConnectionServer;
import com.kaspersky.adbserver.connection.api.ConnectionServerLifecycle;
import com.kaspersky.adbserver.connection.implementation.ConnectionClientImplBySocket;
import com.kaspersky.adbserver.connection.implementation.ConnectionServerImplBySocket;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/kaspersky/adbserver/connection/api/ConnectionFactory;", "", "()V", "createClient", "Lcom/kaspersky/adbserver/connection/api/ConnectionClient;", "socketCreation", "Lkotlin/Function0;", "Ljava/net/Socket;", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "connectionClientLifecycle", "Lcom/kaspersky/adbserver/connection/api/ConnectionClientLifecycle;", "createServer", "Lcom/kaspersky/adbserver/connection/api/ConnectionServer;", "commandExecutor", "Lcom/kaspersky/adbserver/common/api/CommandExecutor;", "connectionServerLifecycle", "Lcom/kaspersky/adbserver/connection/api/ConnectionServerLifecycle;", "adb-server-connection"})
public final class ConnectionFactory {
    @NotNull
    public static final ConnectionFactory INSTANCE = new ConnectionFactory();

    private ConnectionFactory() {
    }

    @NotNull
    public final ConnectionServer createServer(@NotNull Function0<? extends Socket> socketCreation, @NotNull CommandExecutor commandExecutor, @NotNull Logger logger, @NotNull ConnectionServerLifecycle connectionServerLifecycle) {
        Intrinsics.checkNotNullParameter(socketCreation, (String)"socketCreation");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)connectionServerLifecycle, (String)"connectionServerLifecycle");
        return new ConnectionServerImplBySocket(socketCreation, commandExecutor, logger, connectionServerLifecycle);
    }

    @NotNull
    public final ConnectionClient createClient(@NotNull Function0<? extends Socket> socketCreation, @NotNull Logger logger, @NotNull ConnectionClientLifecycle connectionClientLifecycle) {
        Intrinsics.checkNotNullParameter(socketCreation, (String)"socketCreation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)connectionClientLifecycle, (String)"connectionClientLifecycle");
        return new ConnectionClientImplBySocket(socketCreation, logger, connectionClientLifecycle);
    }
}

