/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.connection.implementation.transferring;

import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.connection.implementation.lightsocket.LightSocketWrapper;
import com.kaspersky.adbserver.connection.implementation.transferring.ExpectedEOFException;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002\u001f BA\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0013\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u0014J\u0006\u0010\u001e\u001a\u00020\u000bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "ReceiveModel", "SendModel", "", "lightSocketWrapper", "Lcom/kaspersky/adbserver/connection/implementation/lightsocket/LightSocketWrapper;", "receiveModelClass", "Ljava/lang/Class;", "sendModelClass", "disruptAction", "Lkotlin/Function0;", "", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "(Lcom/kaspersky/adbserver/connection/implementation/lightsocket/LightSocketWrapper;Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;Lcom/kaspersky/adbserver/common/log/logger/Logger;)V", "inputStream", "Ljava/io/ObjectInputStream;", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "messagesListener", "Lkotlin/Function1;", "outputStream", "Ljava/io/ObjectOutputStream;", "peekNextMessage", "prepareListening", "sendMessage", "sendModel", "(Ljava/lang/Object;)V", "startListening", "listener", "stopListening", "Companion", "MessagesListeningThread", "adb-server-connection"})
public final class SocketMessagesTransferring<ReceiveModel, SendModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LightSocketWrapper lightSocketWrapper;
    @NotNull
    private final Class<ReceiveModel> receiveModelClass;
    @NotNull
    private final Class<SendModel> sendModelClass;
    @NotNull
    private final Function0<Unit> disruptAction;
    @NotNull
    private final Logger logger;
    private ObjectInputStream inputStream;
    private ObjectOutputStream outputStream;
    private Function1<? super ReceiveModel, Unit> messagesListener;
    @NotNull
    private final AtomicBoolean isRunning;

    private SocketMessagesTransferring(LightSocketWrapper lightSocketWrapper, Class<ReceiveModel> receiveModelClass, Class<SendModel> sendModelClass, Function0<Unit> disruptAction, Logger logger) {
        this.lightSocketWrapper = lightSocketWrapper;
        this.receiveModelClass = receiveModelClass;
        this.sendModelClass = sendModelClass;
        this.disruptAction = disruptAction;
        this.logger = logger;
        this.isRunning = new AtomicBoolean(false);
    }

    public final void prepareListening() {
        this.logger.d("Start");
        try {
            this.outputStream = new ObjectOutputStream(this.lightSocketWrapper.getOutputStream());
            this.inputStream = new ObjectInputStream(this.lightSocketWrapper.getInputStream());
            this.logger.d("IO Streams were created");
        }
        catch (EOFException exception) {
            throw new ExpectedEOFException();
        }
    }

    public final void startListening(@NotNull Function1<? super ReceiveModel, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.logger.d("Started");
        this.messagesListener = listener;
        this.isRunning.set(true);
        new MessagesListeningThread().start();
    }

    public final void sendMessage(SendModel sendModel) {
        this.logger.d("Input sendModel=" + sendModel);
        try {
            ObjectOutputStream objectOutputStream = this.outputStream;
            if (objectOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
                objectOutputStream = null;
            }
            objectOutputStream.writeObject(sendModel);
            ObjectOutputStream objectOutputStream2 = this.outputStream;
            if (objectOutputStream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
                objectOutputStream2 = null;
            }
            objectOutputStream2.flush();
        }
        catch (Throwable exception) {
            String string = exception.getLocalizedMessage();
            if (string == null && (string = exception.getMessage()) == null) {
                string = "";
            }
            this.logger.e(string);
            this.disruptAction.invoke();
        }
    }

    public final void stopListening() {
        this.isRunning.set(false);
    }

    private final void peekNextMessage() {
        Object obj = null;
        try {
            ObjectInputStream objectInputStream = this.inputStream;
            if (objectInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputStream");
                objectInputStream = null;
            }
            Object object = objectInputStream.readObject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputStream.readObject()");
            obj = object;
            if (Intrinsics.areEqual(obj.getClass(), this.receiveModelClass)) {
                this.logger.d("The message=" + obj);
                Function1<? super ReceiveModel, Unit> function1 = this.messagesListener;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messagesListener");
                    function1 = null;
                }
                function1.invoke(obj);
            } else {
                this.logger.e("The message=" + obj + " but this message type is not " + this.receiveModelClass);
                this.disruptAction.invoke();
            }
        }
        catch (Throwable exception) {
            if (!this.isRunning.get()) {
                return;
            }
            if (exception instanceof EOFException) {
                this.logger.d("EOFException occurred in Socket inputStream. The most possible reason is the opposite socket just broke up the connection. Additional info: exception=" + exception);
            } else {
                String string = exception.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exception.localizedMessage");
                this.logger.e(string);
            }
            this.disruptAction.invoke();
        }
    }

    public /* synthetic */ SocketMessagesTransferring(LightSocketWrapper lightSocketWrapper, Class receiveModelClass, Class sendModelClass, Function0 disruptAction, Logger logger, DefaultConstructorMarker $constructor_marker) {
        this(lightSocketWrapper, receiveModelClass, sendModelClass, (Function0<Unit>)disruptAction, logger);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u0001\"\u0006\b\u0003\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring$Companion;", "", "()V", "createTransferring", "Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;", "Receive", "Send", "lightSocketWrapper", "Lcom/kaspersky/adbserver/connection/implementation/lightsocket/LightSocketWrapper;", "disruptAction", "Lkotlin/Function0;", "", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "adb-server-connection"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <Receive, Send> SocketMessagesTransferring<Receive, Send> createTransferring(LightSocketWrapper lightSocketWrapper, Function0<Unit> disruptAction, Logger logger) {
            Intrinsics.checkNotNullParameter((Object)lightSocketWrapper, (String)"lightSocketWrapper");
            Intrinsics.checkNotNullParameter(disruptAction, (String)"disruptAction");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            boolean $i$f$createTransferring = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"Receive");
            Intrinsics.reifiedOperationMarker((int)4, (String)"Send");
            return new SocketMessagesTransferring(lightSocketWrapper, Object.class, Object.class, disruptAction, logger, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring$MessagesListeningThread;", "Ljava/lang/Thread;", "(Lcom/kaspersky/adbserver/connection/implementation/transferring/SocketMessagesTransferring;)V", "run", "", "adb-server-connection"})
    private final class MessagesListeningThread
    extends Thread {
        @Override
        public void run() {
            SocketMessagesTransferring.this.logger.d("Start listening");
            while (SocketMessagesTransferring.this.isRunning.get()) {
                SocketMessagesTransferring.this.peekNextMessage();
            }
        }
    }
}

