/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.adbserver.desdevconnection;

import com.kaspersky.adbserver.commandtypes.AdbCommand;
import com.kaspersky.adbserver.common.api.Command;
import com.kaspersky.adbserver.common.api.CommandExecutor;
import com.kaspersky.adbserver.common.api.CommandResult;
import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.desdevconnection.DesktopDeviceSocketConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kaspersky/adbserver/desdevconnection/DesktopDeviceSocketConnectionForwardImpl;", "Lcom/kaspersky/adbserver/desdevconnection/DesktopDeviceSocketConnection;", "()V", "clientPortsList", "", "", "forwardPorts", "", "executor", "Lcom/kaspersky/adbserver/common/api/CommandExecutor;", "fromPort", "toPort", "logger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "getDesktopSocketLoad", "Lkotlin/Function0;", "Ljava/net/Socket;", "getDeviceSocketLoad", "getFreePort", "Companion", "adbserver-desktop-device-connection"})
public final class DesktopDeviceSocketConnectionForwardImpl
implements DesktopDeviceSocketConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> clientPortsList = new ArrayList();
    private static final int DEVICE_PORT = 8500;
    private static final int MIN_CLIENT_PORT = 6000;
    private static final int MAX_CLIENT_PORT = 49000;
    @NotNull
    private static final String LOCAL_HOST = "127.0.0.1";

    @Override
    @NotNull
    public Function0<Socket> getDesktopSocketLoad(@NotNull CommandExecutor executor, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        int clientPort = this.getFreePort();
        logger.d("calculated desktop client port=" + clientPort);
        this.forwardPorts(executor, clientPort, 8500, logger);
        logger.d("desktop client port=" + clientPort + " is forwarding with device server port=8500");
        return (Function0)new Function0<Socket>(logger, clientPort){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ int $clientPort;
            {
                this.$logger = $logger;
                this.$clientPort = $clientPort;
                super(0);
            }

            @NotNull
            public final Socket invoke() {
                this.$logger.d("started with ip=127.0.0.1, port=" + this.$clientPort);
                Socket readyClientSocket = new Socket("127.0.0.1", this.$clientPort);
                this.$logger.d("completed with ip=127.0.0.1, port=" + this.$clientPort);
                return readyClientSocket;
            }
        };
    }

    private final int getFreePort() {
        int newClientPort = 0;
        while (this.clientPortsList.contains(newClientPort = Random.Default.nextInt(6000, 49000))) {
            this.clientPortsList.add(newClientPort);
        }
        return newClientPort;
    }

    private final void forwardPorts(CommandExecutor executor, int fromPort, int toPort, Logger logger) {
        logger.d("fromPort=" + fromPort + ", toPort=" + toPort + " started");
        CommandResult result = executor.execute((Command)new AdbCommand("forward tcp:" + fromPort + " tcp:" + toPort));
        logger.d("fromPort=" + fromPort + ", toPort=" + toPort + ") finished with result=" + result);
    }

    @Override
    @NotNull
    public Function0<Socket> getDeviceSocketLoad(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        return (Function0)new Function0<Socket>(logger){
            final /* synthetic */ Logger $logger;
            {
                this.$logger = $logger;
                super(0);
            }

            public final Socket invoke() {
                this.$logger.d("Started");
                ServerSocket serverSocket = new ServerSocket(8500);
                Socket readyServerSocket = serverSocket.accept();
                this.$logger.d("Completed");
                Intrinsics.checkNotNullExpressionValue((Object)readyServerSocket, (String)"readyServerSocket");
                return readyServerSocket;
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/kaspersky/adbserver/desdevconnection/DesktopDeviceSocketConnectionForwardImpl$Companion;", "", "()V", "DEVICE_PORT", "", "LOCAL_HOST", "", "MAX_CLIENT_PORT", "MIN_CLIENT_PORT", "adbserver-desktop-device-connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

