/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.autoscroll;

import androidx.test.uiautomator.UiScrollable;
import androidx.test.uiautomator.UiSelector;
import com.kaspersky.components.kautomator.intercept.interaction.UiObjectInteraction;
import com.kaspersky.kaspresso.autoscroll.AutoScrollProvider;
import com.kaspersky.kaspresso.internal.extensions.other.ThrowableExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.AutoScrollParams;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J1\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/kaspersky/kaspresso/autoscroll/ObjectAutoScrollProviderImpl;", "Lcom/kaspersky/kaspresso/autoscroll/AutoScrollProvider;", "Lcom/kaspersky/components/kautomator/intercept/interaction/UiObjectInteraction;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "autoScrollParams", "Lcom/kaspersky/kaspresso/params/AutoScrollParams;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/params/AutoScrollParams;)V", "scroll", "T", "interaction", "action", "Lkotlin/Function0;", "cachedError", "", "(Lcom/kaspersky/components/kautomator/intercept/interaction/UiObjectInteraction;Lkotlin/jvm/functions/Function0;Ljava/lang/Throwable;)Ljava/lang/Object;", "withAutoScroll", "(Lcom/kaspersky/components/kautomator/intercept/interaction/UiObjectInteraction;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kaspresso_release"})
public final class ObjectAutoScrollProviderImpl
implements AutoScrollProvider<UiObjectInteraction> {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final AutoScrollParams autoScrollParams;

    public ObjectAutoScrollProviderImpl(@NotNull UiTestLogger logger, @NotNull AutoScrollParams autoScrollParams) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)autoScrollParams, (String)"autoScrollParams");
        this.logger = logger;
        this.autoScrollParams = autoScrollParams;
    }

    @Override
    public <T> T withAutoScroll(@NotNull UiObjectInteraction interaction, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            object = action.invoke();
        }
        catch (Throwable error) {
            if (ThrowableExtKt.isAllowed(error, this.autoScrollParams.getAllowedExceptions()) && new UiScrollable(new UiSelector().scrollable(true)).exists()) {
                return this.scroll(interaction, action, error);
            }
            throw error;
        }
        return (T)object;
    }

    @Override
    public <T> T scroll(@NotNull UiObjectInteraction interaction, @NotNull Function0<? extends T> action, @NotNull Throwable cachedError) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)cachedError, (String)"cachedError");
        UiScrollable scrollable = new UiScrollable(new UiSelector().scrollable(true));
        do {
            if (interaction.getUiObject2() != null) {
                this.logger.i("UiObject autoscroll to the bottom successfully performed.");
                return (T)action.invoke();
            }
            interaction.reFindUiObject();
        } while (scrollable.scrollForward());
        do {
            if (interaction.getUiObject2() != null) {
                this.logger.i("UiObject autoscroll to the beginning successfully performed.");
                return (T)action.invoke();
            }
            interaction.reFindUiObject();
        } while (scrollable.scrollBackward());
        this.logger.i("UiObject autoscroll did not help. Throwing exception.");
        throw cachedError;
    }
}

