/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.autoscroll;

import androidx.test.espresso.web.sugar.Web;
import androidx.test.espresso.web.webdriver.DriverAtoms;
import com.kaspersky.kaspresso.autoscroll.AutoScrollProvider;
import com.kaspersky.kaspresso.internal.extensions.other.ThrowableExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.AutoScrollParams;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/kaspersky/kaspresso/autoscroll/WebAutoScrollProviderImpl;", "Lcom/kaspersky/kaspresso/autoscroll/AutoScrollProvider;", "Landroidx/test/espresso/web/sugar/Web$WebInteraction;", "params", "Lcom/kaspersky/kaspresso/params/AutoScrollParams;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/params/AutoScrollParams;Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "scroll", "T", "interaction", "action", "Lkotlin/Function0;", "cachedError", "", "(Landroidx/test/espresso/web/sugar/Web$WebInteraction;Lkotlin/jvm/functions/Function0;Ljava/lang/Throwable;)Ljava/lang/Object;", "withAutoScroll", "(Landroidx/test/espresso/web/sugar/Web$WebInteraction;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kaspresso_release"})
public final class WebAutoScrollProviderImpl
implements AutoScrollProvider<Web.WebInteraction<?>> {
    @NotNull
    private final AutoScrollParams params;
    @NotNull
    private final UiTestLogger logger;

    public WebAutoScrollProviderImpl(@NotNull AutoScrollParams params, @NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.params = params;
        this.logger = logger;
    }

    @Override
    public <T> T withAutoScroll(@NotNull Web.WebInteraction<?> interaction, @NotNull Function0<? extends T> action) throws Throwable {
        Object object;
        Intrinsics.checkNotNullParameter(interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            object = action.invoke();
        }
        catch (Throwable error) {
            if (ThrowableExtKt.isAllowed(error, this.params.getAllowedExceptions())) {
                return this.scroll(interaction, action, error);
            }
            throw error;
        }
        return (T)object;
    }

    @Override
    public <T> T scroll(@NotNull Web.WebInteraction<?> interaction, @NotNull Function0<? extends T> action, @NotNull Throwable cachedError) throws Throwable {
        Object object;
        Intrinsics.checkNotNullParameter(interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)cachedError, (String)"cachedError");
        try {
            interaction.perform(DriverAtoms.webScrollIntoView());
            this.logger.i("Web autoScroll successfully performed.");
            object = action.invoke();
        }
        catch (Throwable error) {
            throw cachedError;
        }
        return (T)object;
    }
}

