/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.accessibility;

import android.annotation.TargetApi;
import androidx.test.uiautomator.Configurator;
import com.kaspersky.kaspresso.device.accessibility.Accessibility;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/kaspersky/kaspresso/device/accessibility/AccessibilityImpl;", "Lcom/kaspersky/kaspresso/device/accessibility/Accessibility;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "disable", "", "enable", "packageName", "", "className", "kaspresso_release"})
public final class AccessibilityImpl
implements Accessibility {
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final UiTestLogger logger;

    public AccessibilityImpl(@NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.logger = logger;
    }

    @Override
    @TargetApi(value=24)
    public void enable(@NotNull String packageName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String string = "enabled_accessibility_services";
        String cmd = "settings put secure " + string + ' ' + packageName + '/' + className;
        int flags = 1;
        Configurator.getInstance().setUiAutomationFlags(flags);
        this.instrumentalDependencyProvider.getUiAutomation(1).executeShellCommand(cmd).close();
        this.logger.i("Accessibility service " + packageName + '.' + className + " enabled");
    }

    @Override
    @TargetApi(value=24)
    public void disable() {
        String string = "enabled_accessibility_services";
        String cmd = "settings put secure " + string + " null";
        this.instrumentalDependencyProvider.getUiAutomation(1).executeShellCommand(cmd).close();
        this.logger.i("Accessibility services disabled");
    }
}

