/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.apps;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.BySelector;
import androidx.test.uiautomator.SearchCondition;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObject;
import androidx.test.uiautomator.UiSelector;
import androidx.test.uiautomator.Until;
import com.kaspersky.kaspresso.device.apps.Apps;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\fH\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/kaspersky/kaspresso/device/apps/AppsImpl;", "Lcom/kaspersky/kaspresso/device/apps/Apps;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "context", "Landroid/content/Context;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Landroid/content/Context;Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "chromePackageName", "", "targetAppLauncherPackageName", "getTargetAppLauncherPackageName", "()Ljava/lang/String;", "targetAppPackageName", "getTargetAppPackageName", "uiDevice", "Landroidx/test/uiautomator/UiDevice;", "getUiDevice", "()Landroidx/test/uiautomator/UiDevice;", "install", "", "apkPath", "installIfNotExists", "packageName", "isInstalled", "", "kill", "launch", "data", "Landroid/net/Uri;", "openRecent", "contentDescription", "openUrlInChrome", "url", "uninstall", "uninstallIfExists", "waitForAppLaunchAndReady", "timeout", "", "waitForLauncher", "launcherPackageName", "Companion", "kaspresso_release"})
public final class AppsImpl
implements Apps {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Context context;
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final AdbServer adbServer;
    @NotNull
    private final String chromePackageName;
    @NotNull
    private final String targetAppPackageName;
    public static final long LAUNCH_RECENT_TIMEOUT = 1000L;
    public static final long LAUNCH_APP_TIMEOUT = 5000L;

    public AppsImpl(@NotNull UiTestLogger logger, @NotNull Context context, @NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.context = context;
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.adbServer = adbServer;
        this.chromePackageName = "com.android.chrome";
        String string = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        this.targetAppPackageName = string;
    }

    private final UiDevice getUiDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    @Override
    @NotNull
    public String getTargetAppLauncherPackageName() {
        String string = this.getUiDevice().getLauncherPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uiDevice.launcherPackageName");
        return string;
    }

    @Override
    @NotNull
    public String getTargetAppPackageName() {
        return this.targetAppPackageName;
    }

    @Override
    public void install(@NotNull String apkPath) {
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"install ", (Object)apkPath)};
        this.adbServer.performAdb(stringArray);
        this.logger.i("App " + apkPath + " installed");
    }

    @Override
    public void installIfNotExists(@NotNull String packageName, @NotNull String apkPath) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        if (!this.isInstalled(packageName)) {
            this.install(apkPath);
        }
    }

    @Override
    public void uninstall(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"uninstall ", (Object)packageName)};
        this.adbServer.performAdb(stringArray);
        this.logger.i("App " + packageName + " uninstalled");
    }

    @Override
    public void uninstallIfExists(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (this.isInstalled(packageName)) {
            this.uninstall(packageName);
        }
    }

    @Override
    public boolean isInstalled(@NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        PackageManager packageManager2 = packageManager;
        try {
            packageManager2.getApplicationInfo(packageName, 0);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e2) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void waitForLauncher(long timeout, @NotNull String launcherPackageName) {
        Intrinsics.checkNotNullParameter((Object)launcherPackageName, (String)"launcherPackageName");
        MatcherAssert.assertThat((Object)this.getUiDevice().getLauncherPackageName(), (Matcher)CoreMatchers.notNullValue());
        SearchCondition condition = Until.hasObject((BySelector)By.pkg((String)launcherPackageName).depth(0));
        this.logger.i("Wait " + timeout + " for " + launcherPackageName + " launch");
        Object object = this.getUiDevice().wait(condition, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uiDevice.wait(condition, timeout)");
        Assert.assertTrue((boolean)((Boolean)object));
    }

    @Override
    public void waitForAppLaunchAndReady(long timeout, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        SearchCondition condition = Until.hasObject((BySelector)By.pkg((String)packageName).depth(0));
        this.logger.i("Wait " + timeout + " for " + packageName + " launch and ready");
        Object object = this.getUiDevice().wait(condition, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uiDevice.wait(condition, timeout)");
        Assert.assertTrue((boolean)((Boolean)object));
    }

    @Override
    public void openUrlInChrome(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.launch(this.chromePackageName, Uri.parse((String)url));
    }

    @Override
    public void launch(@NotNull String packageName, @Nullable Uri data) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        PackageManager packageManager = this.context.getPackageManager();
        Intent intent = packageManager == null ? null : ((stringArray = packageManager.getLaunchIntentForPackage(packageName)) == null ? null : stringArray.addFlags(32768));
        packageManager = intent;
        if (packageManager == null) {
            stringArray = this;
            boolean bl = false;
            boolean bl2 = false;
            AppsImpl $this$launch_u24lambda_u2d0 = (AppsImpl)stringArray;
            boolean bl3 = false;
            $this$launch_u24lambda_u2d0.logger.e(Intrinsics.stringPlus((String)"Can not build an intent to launch app for: ", (Object)packageName));
            return;
        }
        packageManager = data;
        if (packageManager != null) {
            stringArray = packageManager;
            boolean bl = false;
            boolean bl4 = false;
            Object it = stringArray;
            boolean bl5 = false;
            Intent intent2 = intent;
            Intrinsics.checkNotNull((Object)intent2);
            intent2.setData((Uri)it);
        }
        try {
            this.context.startActivity(intent);
        }
        catch (SecurityException e2) {
            stringArray = new String[]{"monkey -p " + packageName + " 1"};
            this.adbServer.performShell(stringArray);
        }
        SearchCondition condition = Until.hasObject((BySelector)By.pkg((String)packageName).depth(0));
        this.logger.i("Wait 5000 for " + packageName + " launch");
        this.getUiDevice().wait(condition, 5000L);
    }

    @Override
    public void openRecent(@NotNull String contentDescription) {
        Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
        this.logger.i("Open " + contentDescription + " from recents");
        this.getUiDevice().pressRecentApps();
        UiSelector appSelector = new UiSelector().descriptionContains(contentDescription);
        UiObject recentApp = this.getUiDevice().findObject(appSelector);
        Thread.sleep(1000L);
        if (recentApp.exists()) {
            recentApp.click();
        }
        Thread.sleep(1000L);
    }

    @Override
    public void kill(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String[] stringArray = new String[]{"am", "force-stop", packageName};
        Runtime.getRuntime().exec(stringArray);
        this.logger.i(Intrinsics.stringPlus((String)"Force stop ", (Object)packageName));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/kaspersky/kaspresso/device/apps/AppsImpl$Companion;", "", "()V", "LAUNCH_APP_TIMEOUT", "", "LAUNCH_RECENT_TIMEOUT", "kaspresso_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

