/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.exploit;

import android.app.Activity;
import androidx.test.espresso.Espresso;
import androidx.test.uiautomator.UiDevice;
import com.kaspersky.kaspresso.device.activities.Activities;
import com.kaspersky.kaspresso.device.exploit.Exploit;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/kaspersky/kaspresso/device/exploit/ExploitImpl;", "Lcom/kaspersky/kaspresso/device/exploit/Exploit;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "activities", "Lcom/kaspersky/kaspresso/device/activities/Activities;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/activities/Activities;Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "uiDevice", "Landroidx/test/uiautomator/UiDevice;", "getUiDevice", "()Landroidx/test/uiautomator/UiDevice;", "pressBack", "", "failTestIfAppUnderTestClosed", "", "pressHome", "rotate", "setAutoRotationEnabled", "enabled", "setOrientation", "deviceOrientation", "Lcom/kaspersky/kaspresso/device/exploit/Exploit$DeviceOrientation;", "kaspresso_release"})
public final class ExploitImpl
implements Exploit {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Activities activities;
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final AdbServer adbServer;

    public ExploitImpl(@NotNull UiTestLogger logger, @NotNull Activities activities, @NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)activities, (String)"activities");
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.activities = activities;
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.adbServer = adbServer;
    }

    private final UiDevice getUiDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    @Override
    public void rotate() {
        Exploit.DeviceOrientation deviceOrientation;
        Activity activity = this.activities.getResumed();
        if (activity == null) {
            return;
        }
        Activity resumedActivity = activity;
        int n = resumedActivity.getResources().getConfiguration().orientation;
        switch (n) {
            case 2: {
                deviceOrientation = Exploit.DeviceOrientation.Portrait;
                break;
            }
            case 1: {
                deviceOrientation = Exploit.DeviceOrientation.Landscape;
                break;
            }
            default: {
                throw new RuntimeException("Current device orientation is incorrect.");
            }
        }
        Exploit.DeviceOrientation neededDeviceOrientation = deviceOrientation;
        this.setOrientation(neededDeviceOrientation);
        this.logger.i(Intrinsics.stringPlus((String)"Device orientation set to ", (Object)((Object)neededDeviceOrientation)));
    }

    @Override
    public void setOrientation(@NotNull Exploit.DeviceOrientation deviceOrientation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)deviceOrientation, (String)"deviceOrientation");
        this.setAutoRotationEnabled(false);
        String[] stringArray = deviceOrientation;
        int n2 = WhenMappings.$EnumSwitchMapping$0[stringArray.ordinal()];
        switch (n2) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int value = n;
        stringArray = new String[]{Intrinsics.stringPlus((String)"content insert --uri content://settings/system --bind name:s:user_rotation --bind value:i:", (Object)value)};
        this.adbServer.performShell(stringArray);
        this.logger.i(Intrinsics.stringPlus((String)"Device orientation set to ", (Object)deviceOrientation));
    }

    @Override
    public void setAutoRotationEnabled(boolean enabled) {
        int value = enabled ? 1 : 0;
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"content insert --uri content://settings/system --bind name:s:accelerometer_rotation --bind value:i:", (Object)value)};
        this.adbServer.performShell(stringArray);
        this.logger.i("Device auto rotation " + (enabled ? "en" : "dis") + "abled");
    }

    @Override
    public void pressBack(boolean failTestIfAppUnderTestClosed) {
        this.logger.i("Press back button");
        if (failTestIfAppUnderTestClosed) {
            Espresso.pressBack();
        } else {
            Espresso.pressBackUnconditionally();
        }
    }

    @Override
    public boolean pressHome() {
        this.logger.i("Press home button");
        return this.getUiDevice().pressHome();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Exploit.DeviceOrientation.values().length];
            nArray[Exploit.DeviceOrientation.Portrait.ordinal()] = 1;
            nArray[Exploit.DeviceOrientation.Landscape.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

