/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.files;

import com.kaspersky.kaspresso.device.files.Files;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/kaspersky/kaspresso/device/files/FilesImpl;", "Lcom/kaspersky/kaspresso/device/files/Files;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "pull", "", "devicePath", "", "serverPath", "push", "remove", "path", "kaspresso_release"})
public final class FilesImpl
implements Files {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final AdbServer adbServer;

    public FilesImpl(@NotNull UiTestLogger logger, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.adbServer = adbServer;
    }

    @Override
    public void push(@NotNull String serverPath, @NotNull String devicePath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)devicePath, (String)"devicePath");
        String[] stringArray = new String[]{"push " + serverPath + ' ' + devicePath};
        this.adbServer.performAdb(stringArray);
        this.logger.i("Push file from " + serverPath + " to " + devicePath);
    }

    @Override
    public void remove(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"rm -f ", (Object)path)};
        this.adbServer.performShell(stringArray);
        this.logger.i(Intrinsics.stringPlus((String)"Remove file from ", (Object)path));
    }

    @Override
    public void pull(@NotNull String devicePath, @NotNull String serverPath) {
        Intrinsics.checkNotNullParameter((Object)devicePath, (String)"devicePath");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        String[] stringArray = new String[]{"pull " + devicePath + ' ' + serverPath};
        this.adbServer.performAdb(stringArray);
        this.logger.i("Pull file from " + devicePath + " to " + serverPath);
    }
}

