/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.languages;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import androidx.core.os.ConfigurationCompat;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import com.kaspersky.kaspresso.device.languages.Language;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/kaspersky/kaspresso/device/languages/LanguageImpl;", "Lcom/kaspersky/kaspresso/device/languages/Language;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "context", "Landroid/content/Context;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Landroid/content/Context;)V", "cachedActivity", "Landroid/app/Activity;", "lifecycleCallback", "Landroidx/test/runner/lifecycle/ActivityLifecycleCallback;", "applyCurrentLocaleToContext", "", "locale", "Ljava/util/Locale;", "getCurrentLocale", "switchInApp", "kaspresso_release"})
public final class LanguageImpl
implements Language {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Context context;
    @Nullable
    private Activity cachedActivity;
    @NotNull
    private final ActivityLifecycleCallback lifecycleCallback;

    public LanguageImpl(@NotNull UiTestLogger logger, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger = logger;
        this.context = context;
        this.lifecycleCallback = (arg_0, arg_1) -> LanguageImpl.lifecycleCallback$lambda-0(this, arg_0, arg_1);
        ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(this.lifecycleCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchInApp(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.logger.i("Switch the language in the Application to " + locale + ": start");
        if (Intrinsics.areEqual((Object)this.getCurrentLocale(), (Object)locale)) {
            this.logger.i("Switch the language in the Application to " + locale + " is not needed because it's a current app's language");
            return;
        }
        try {
            Activity activity = this.cachedActivity;
            this.applyCurrentLocaleToContext(activity == null ? this.context : (Context)activity, locale);
            this.logger.i("Switch the language in the Application to " + locale + ": success");
        }
        catch (Throwable error) {
            this.logger.e("Switch the language in the Application to " + locale + ": failed with the error: " + error);
            throw error;
        }
        finally {
            this.cachedActivity = null;
        }
    }

    private final Locale getCurrentLocale() {
        Locale locale = ConfigurationCompat.getLocales((Configuration)this.context.getResources().getConfiguration()).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocales(context.resources.configuration).get(0)");
        return locale;
    }

    private final void applyCurrentLocaleToContext(Context context, Locale locale) {
        Resources resources = context.getResources();
        Locale.setDefault(locale);
        Configuration configuration = resources.getConfiguration();
        configuration.setLocale(locale);
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
    }

    private static final void lifecycleCallback$lambda-0(LanguageImpl this$0, Activity activity, Stage stage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (stage == Stage.CREATED) {
            this$0.cachedActivity = activity;
        }
    }
}

