/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.locales;

import androidx.test.platform.app.InstrumentationRegistry;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/kaspersky/kaspresso/device/locales/Locales;", "", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "createLocale", "Ljava/util/Locale;", "locale", "", "getLocaleString", "getSupportedLocales", "", "parseLocales", "locales", "Companion", "kaspresso_release"})
public final class Locales {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private static final String LOCALES_ARG = "localizations";
    @NotNull
    private static final String LANGUAGE_COUNTRY_SEPARATOR = "-";
    @NotNull
    private static final String DEFAULT_LOCALES = "en,ru";

    public Locales(@NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Set<Locale> getSupportedLocales() {
        this.logger.i("Getting supported locales");
        return this.parseLocales(this.getLocaleString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Locale> parseLocales(@NotNull String locales) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)locales, (String)"locales");
        String[] stringArray = new String[]{","};
        List localizationsArray = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)locales, (String)" ", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$map$iv = localizationsArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Locale locale = this.createLocale((String)it);
            collection.add(locale);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Locale createLocale(String locale) {
        Locale locale2;
        if (StringsKt.isBlank((CharSequence)locale)) {
            throw new IllegalArgumentException("Blank locale string");
        }
        if (StringsKt.contains$default((CharSequence)locale, (CharSequence)LANGUAGE_COUNTRY_SEPARATOR, (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{LANGUAGE_COUNTRY_SEPARATOR};
            List langCountry = StringsKt.split$default((CharSequence)locale, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            locale2 = new Locale((String)langCountry.get(0), (String)langCountry.get(1));
        } else {
            locale2 = new Locale(locale, "");
        }
        return locale2;
    }

    private final String getLocaleString() {
        String string;
        String localizations = InstrumentationRegistry.getArguments().getString(LOCALES_ARG);
        CharSequence charSequence = localizations;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.logger.d("Parameter localizations is not set, default value is used: en,ru");
            string = DEFAULT_LOCALES;
        } else {
            string = localizations;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/kaspersky/kaspresso/device/locales/Locales$Companion;", "", "()V", "DEFAULT_LOCALES", "", "LANGUAGE_COUNTRY_SEPARATOR", "LOCALES_ARG", "kaspresso_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

