/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.location;

import com.kaspersky.kaspresso.device.location.Location;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/kaspersky/kaspresso/device/location/LocationImpl;", "Lcom/kaspersky/kaspresso/device/location/Location;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "disableGps", "", "enableGps", "setLocation", "lat", "", "lon", "setLocationProviders", "providers", "", "kaspresso_release"})
public final class LocationImpl
implements Location {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final AdbServer adbServer;

    public LocationImpl(@NotNull UiTestLogger logger, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.adbServer = adbServer;
    }

    @Override
    public void enableGps() {
        this.setLocationProviders("+gps");
        this.logger.i("GPS enabled");
    }

    @Override
    public void disableGps() {
        this.setLocationProviders("-gps");
        this.logger.i("GPS disabled");
    }

    @Override
    public void setLocation(double lat, double lon) {
        String[] stringArray = new String[]{"emu geo fix " + lon + ' ' + lat};
        this.adbServer.performAdb(stringArray);
        this.logger.i("Location set to " + lat + ',' + lon);
    }

    private final void setLocationProviders(String providers) {
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"settings put secure location_providers_allowed ", (Object)providers)};
        this.adbServer.performShell(stringArray);
    }
}

