/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.logcat;

import android.os.Build;
import android.util.Log;
import com.kaspersky.kaspresso.device.logcat.Logcat;
import com.kaspersky.kaspresso.device.logcat.LogcatBufferSize;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016JV\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J]\u0010\u001e\u001a\u00020\u00152\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010!JI\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010#Jf\u0010\"\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00070%H\u0016\u00a2\u0006\u0002\u0010)JS\u0010*\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010+2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u00152!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u00070%J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/kaspersky/kaspresso/device/logcat/LogcatImpl;", "Lcom/kaspersky/kaspresso/device/logcat/Logcat;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "isNeededToPrintExecutedCommand", "", "defaultBufferSize", "Lcom/kaspersky/kaspresso/device/logcat/LogcatBufferSize;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/server/AdbServer;ZLcom/kaspersky/kaspresso/device/logcat/LogcatBufferSize;)V", "clear", "", "buffer", "Lcom/kaspersky/kaspresso/device/logcat/Logcat$Buffer;", "disableChatty", "dumpLogcat", "file", "Ljava/io/File;", "tags", "", "", "timeFrom", "excludePattern", "excludePatternIsIgnoreCase", "includePattern", "includePatternIsIgnoreCase", "executeCommand", "Ljava/lang/Process;", "command", "prepareCommand", "rowLimit", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;ZLcom/kaspersky/kaspresso/device/logcat/Logcat$Buffer;Ljava/lang/Integer;)Ljava/lang/String;", "readLogcatRows", "(Ljava/lang/String;ZLjava/lang/String;ZLcom/kaspersky/kaspresso/device/logcat/Logcat$Buffer;Ljava/lang/Integer;)Ljava/util/List;", "readingBlock", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "logcatRow", "(Ljava/lang/String;ZLjava/lang/String;ZLcom/kaspersky/kaspresso/device/logcat/Logcat$Buffer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)Z", "readLogcatRowsViaAdb", "Lkotlin/text/Regex;", "logcatFilePath", "logRow", "setBufferSize", "size", "setDefaultBufferSize", "Companion", "kaspresso_release"})
public final class LogcatImpl
implements Logcat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final AdbServer adbServer;
    private final boolean isNeededToPrintExecutedCommand;
    @NotNull
    private final LogcatBufferSize defaultBufferSize;
    public static final int DEFAULT_BUFFER_SIZE = 256;
    public static final long DEFAULT_LOGCAT_CLEAR_DELAY = 1000L;

    public LogcatImpl(@NotNull UiTestLogger logger, @NotNull AdbServer adbServer, boolean isNeededToPrintExecutedCommand, @NotNull LogcatBufferSize defaultBufferSize) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        Intrinsics.checkNotNullParameter((Object)defaultBufferSize, (String)"defaultBufferSize");
        this.logger = logger;
        this.adbServer = adbServer;
        this.isNeededToPrintExecutedCommand = isNeededToPrintExecutedCommand;
        this.defaultBufferSize = defaultBufferSize;
    }

    public /* synthetic */ LogcatImpl(UiTestLogger uiTestLogger, AdbServer adbServer, boolean bl, LogcatBufferSize logcatBufferSize, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            logcatBufferSize = new LogcatBufferSize(256, LogcatBufferSize.Dimension.KILOBYTES);
        }
        this(uiTestLogger, adbServer, bl, logcatBufferSize);
    }

    @Override
    public void disableChatty() {
        if (Build.VERSION.SDK_INT < 26) {
            String[] stringArray = new String[]{"setprop ro.logd.filter disable"};
            this.adbServer.performShell(stringArray);
            stringArray = new String[]{"setprop persist.logd.filter disable"};
            this.adbServer.performShell(stringArray);
        }
        this.logger.i("Chatty disabled");
    }

    @Override
    public void setBufferSize(@NotNull LogcatBufferSize size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"logcat -G ", (Object)size)};
        this.adbServer.performShell(stringArray);
        this.logger.i(Intrinsics.stringPlus((String)"Logcat buffer size set to ", (Object)size));
    }

    @Override
    public void setDefaultBufferSize() {
        this.setBufferSize(this.defaultBufferSize);
        this.logger.i(Intrinsics.stringPlus((String)"Logcat buffer size set to default ", (Object)this.defaultBufferSize));
    }

    @Override
    public void clear(@NotNull Logcat.Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)buffer), (String)"buffer");
        String[] stringArray = new String[]{"logcat -b " + buffer.getBufferName() + " -c"};
        this.adbServer.performShell(stringArray);
        Thread.sleep(1000L);
        this.logger.i("Logcat buffer cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpLogcat(@NotNull File file, @Nullable List<String> tags, @Nullable String timeFrom, @Nullable String excludePattern, boolean excludePatternIsIgnoreCase, @Nullable String includePattern, boolean includePatternIsIgnoreCase, @NotNull Logcat.Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)buffer), (String)"buffer");
        String command = this.prepareCommand(tags, timeFrom, excludePattern, excludePatternIsIgnoreCase, includePattern, includePatternIsIgnoreCase, buffer, null);
        this.logger.i("Dump logcat buffer to " + file + ": " + command);
        Process process = this.executeCommand(command);
        try {
            Object object = file;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Throwable e2) {
            this.logger.e(Intrinsics.stringPlus((String)"Dump logcat buffer error: ", (Object)Log.getStackTraceString((Throwable)e2)));
        }
        finally {
            process.destroy();
        }
    }

    @Override
    @NotNull
    public List<String> readLogcatRows(@Nullable String excludePattern, boolean excludePatternIsIgnoreCase, @Nullable String includePattern, boolean includePatternIsIgnoreCase, @NotNull Logcat.Buffer buffer, @Nullable Integer rowLimit) {
        Intrinsics.checkNotNullParameter((Object)((Object)buffer), (String)"buffer");
        boolean bl = false;
        List logcatOutput = new ArrayList();
        this.readLogcatRows(excludePattern, excludePatternIsIgnoreCase, includePattern, includePatternIsIgnoreCase, buffer, rowLimit, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((List<String>)logcatOutput){
            final /* synthetic */ List<String> $logcatOutput;
            {
                this.$logcatOutput = $logcatOutput;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String logcatRow) {
                Intrinsics.checkNotNullParameter((Object)logcatRow, (String)"logcatRow");
                this.$logcatOutput.add(logcatRow);
                return false;
            }
        }));
        return logcatOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readLogcatRows(@Nullable String excludePattern, boolean excludePatternIsIgnoreCase, @Nullable String includePattern, boolean includePatternIsIgnoreCase, @NotNull Logcat.Buffer buffer, @Nullable Integer rowLimit, @NotNull Function1<? super String, Boolean> readingBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)buffer), (String)"buffer");
        Intrinsics.checkNotNullParameter(readingBlock, (String)"readingBlock");
        String command = this.prepareCommand(null, null, excludePattern, excludePatternIsIgnoreCase, includePattern, includePatternIsIgnoreCase, buffer, rowLimit);
        Process process = this.executeCommand(command);
        InputStreamReader logcatStream = new InputStreamReader(process.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(logcatStream);
        String logcatReadedLine = bufferedReader.readLine();
        try {
            while (logcatReadedLine != null) {
                String string = logcatReadedLine;
                if (((Boolean)readingBlock.invoke((Object)string)).booleanValue()) {
                    boolean bl = true;
                    return bl;
                }
                logcatReadedLine = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
            logcatStream.close();
            process.destroy();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readLogcatRowsViaAdb(@Nullable Regex excludePattern, @Nullable Regex includePattern, @NotNull Logcat.Buffer buffer, @NotNull String logcatFilePath, @NotNull Function1<? super String, Boolean> readingBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)buffer), (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)logcatFilePath, (String)"logcatFilePath");
        Intrinsics.checkNotNullParameter(readingBlock, (String)"readingBlock");
        long id = System.currentTimeMillis();
        File logcatFile = new File(logcatFilePath + "/logcat_dump_" + id + ".txt");
        String[] stringArray = new String[]{"logcat -b " + buffer.getBufferName() + " -d > " + logcatFile.getAbsolutePath() + ' '};
        this.adbServer.performShell(stringArray);
        try {
            for (String logRow : FilesKt.readLines$default((File)logcatFile, null, (int)1, null)) {
                boolean bl;
                CharSequence charSequence;
                if (excludePattern != null) {
                    charSequence = logRow;
                    bl = false;
                    if (excludePattern.containsMatchIn(charSequence)) continue;
                }
                if (includePattern != null) {
                    charSequence = logRow;
                    bl = false;
                    if (!includePattern.containsMatchIn(charSequence)) continue;
                }
                if (!((Boolean)readingBlock.invoke((Object)logRow)).booleanValue()) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            logcatFile.delete();
        }
        return false;
    }

    public static /* synthetic */ boolean readLogcatRowsViaAdb$default(LogcatImpl logcatImpl, Regex regex, Regex regex2, Logcat.Buffer buffer, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            regex = null;
        }
        if ((n & 2) != 0) {
            regex2 = null;
        }
        if ((n & 4) != 0) {
            buffer = Logcat.Buffer.DEFAULT;
        }
        return logcatImpl.readLogcatRowsViaAdb(regex, regex2, buffer, string, (Function1<? super String, Boolean>)function1);
    }

    private final String prepareCommand(List<String> tags, String timeFrom, String excludePattern, boolean excludePatternIsIgnoreCase, String includePattern, boolean includePatternIsIgnoreCase, Logcat.Buffer buffer, Integer rowLimit) {
        String command = "logcat -b " + buffer.getBufferName() + " -d ";
        Object object = timeFrom;
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.length() == 0)) {
            command = command + "-t \"" + timeFrom + "\" ";
        }
        if (rowLimit != null && rowLimit > 0) {
            command = command + "-m " + rowLimit + ' ';
        }
        object = tags;
        bl = false;
        bl2 = false;
        if (!(object == null || object.isEmpty())) {
            command = command + "-s " + CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)"\",\"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null);
        }
        if (excludePattern != null) {
            command = command + "| grep -" + (excludePatternIsIgnoreCase ? "i" : "") + "Ev '" + StringsKt.replace$default((String)excludePattern, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "' ";
        }
        if (includePattern != null) {
            command = command + "| grep -" + (includePatternIsIgnoreCase ? "i" : "") + "E '" + StringsKt.replace$default((String)includePattern, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "' ";
        }
        return command;
    }

    private final Process executeCommand(String command) {
        Object object = new String[]{"sh", "-c", command};
        Process process = Runtime.getRuntime().exec((String[])object);
        if (this.isNeededToPrintExecutedCommand) {
            object = Intrinsics.stringPlus((String)"Executed command: ", (Object)command);
            boolean bl = false;
            System.out.println(object);
        }
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
        return process;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/kaspersky/kaspresso/device/logcat/LogcatImpl$Companion;", "", "()V", "DEFAULT_BUFFER_SIZE", "", "DEFAULT_LOGCAT_CLEAR_DELAY", "", "kaspresso_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

