/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.logcat.dumper;

import android.util.Log;
import com.kaspersky.kaspresso.device.logcat.Logcat;
import com.kaspersky.kaspresso.device.logcat.dumper.LogcatDumper;
import com.kaspersky.kaspresso.files.resources.ResourceFilesProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0019\u0010\u0013\u001a\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0016J)\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\u0002\b\u0016H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/kaspersky/kaspresso/device/logcat/dumper/LogcatDumperImpl;", "Lcom/kaspersky/kaspresso/device/logcat/dumper/LogcatDumper;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "resourceFilesProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;", "logcat", "Lcom/kaspersky/kaspresso/device/logcat/Logcat;", "loggerTags", "", "", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;Lcom/kaspersky/kaspresso/device/logcat/Logcat;Ljava/util/List;)V", "dateTimeFormat", "Ljava/text/SimpleDateFormat;", "timeDumpFrom", "charge", "", "doDump", "tag", "block", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ExtensionFunctionType;", "dump", "dumpAndApply", "kaspresso_release"})
public final class LogcatDumperImpl
implements LogcatDumper {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final ResourceFilesProvider resourceFilesProvider;
    @NotNull
    private final Logcat logcat;
    @NotNull
    private final List<String> loggerTags;
    @NotNull
    private final SimpleDateFormat dateTimeFormat;
    @Nullable
    private String timeDumpFrom;

    public LogcatDumperImpl(@NotNull UiTestLogger logger, @NotNull ResourceFilesProvider resourceFilesProvider, @NotNull Logcat logcat, @NotNull List<String> loggerTags) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceFilesProvider, (String)"resourceFilesProvider");
        Intrinsics.checkNotNullParameter((Object)logcat, (String)"logcat");
        Intrinsics.checkNotNullParameter(loggerTags, (String)"loggerTags");
        this.logger = logger;
        this.resourceFilesProvider = resourceFilesProvider;
        this.logcat = logcat;
        this.loggerTags = loggerTags;
        this.dateTimeFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.getDefault());
    }

    @Override
    public void charge() {
        this.timeDumpFrom = this.dateTimeFormat.format(new Date());
        this.logger.i(Intrinsics.stringPlus((String)"Logcat buffer may be dumped from ", (Object)this.timeDumpFrom));
    }

    @Override
    public void dump(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.doDump(tag, null);
    }

    @Override
    public void dumpAndApply(@NotNull String tag, @NotNull Function1<? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.doDump(tag, block);
    }

    private final void doDump(String tag, Function1<? super File, Unit> block) {
        try {
            File logcatFile = ResourceFilesProvider.DefaultImpls.provideLogcatFile$default(this.resourceFilesProvider, tag, null, 2, null);
            Logcat.DefaultImpls.dumpLogcat$default(this.logcat, logcatFile, this.loggerTags, this.timeDumpFrom, null, false, null, false, null, 248, null);
            Function1<? super File, Unit> function1 = block;
            if (function1 != null) {
                function1.invoke((Object)logcatFile);
            }
        }
        catch (Throwable e2) {
            this.logger.e(Intrinsics.stringPlus((String)"Logcat dumping error occurred: ", (Object)Log.getStackTraceString((Throwable)e2)));
        }
    }
}

